/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactSinkException;
import org.eclipse.tycho.IArtifactSink;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.IRawArtifactProvider;
import org.eclipse.tycho.IRawArtifactSink;
import org.eclipse.tycho.core.shared.DuplicateFilteringLoggingProgressMonitor;
import org.eclipse.tycho.core.shared.LoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.helper.StatusTool;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicy;
import org.eclipse.tycho.p2.repository.GAVArtifactDescriptor;
import org.eclipse.tycho.p2.repository.LocalArtifactRepository;
import org.eclipse.tycho.p2.repository.ProviderOnlyArtifactRepository;

public class MirroringArtifactProvider
implements IRawArtifactFileProvider {
    protected final MavenLogger logger;
    protected final MavenLogger splittingLogger;
    protected final IRawArtifactProvider remoteProviders;
    protected final LocalArtifactRepository localArtifactRepository;
    protected final IProgressMonitor monitor;
    private MavenContext mavenContext;
    private IArtifactRepository shaddowRepository;

    public static MirroringArtifactProvider createInstance(LocalArtifactRepository localArtifactRepository, IRawArtifactProvider remoteProviders, MavenContext context) {
        return new MirroringArtifactProvider(localArtifactRepository, remoteProviders, context);
    }

    MirroringArtifactProvider(LocalArtifactRepository localArtifactRepository, IRawArtifactProvider remoteProviders, MavenContext mavenContext) {
        this.remoteProviders = remoteProviders;
        this.localArtifactRepository = localArtifactRepository;
        this.mavenContext = mavenContext;
        this.logger = mavenContext.getLogger();
        this.splittingLogger = new MultiLineLogger(this.logger);
        this.monitor = new LoggingProgressMonitor(this.logger);
        this.shaddowRepository = new ProviderOnlyArtifactRepository(this, localArtifactRepository.getProvisioningAgent(), null);
    }

    public final boolean contains(IArtifactKey key) {
        if (this.localArtifactRepository.contains(key)) {
            return true;
        }
        return this.remoteProviders.contains(key);
    }

    public final IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        IQueryable[] sources = new IQueryable[]{this.localArtifactRepository, this.remoteProviders};
        return new CompoundQueryable(sources).query(query, MirroringArtifactProvider.nonNull(monitor));
    }

    public final File getArtifactFile(IArtifactKey key) throws MirroringFailedException {
        if (this.makeLocallyAvailable(key)) {
            return this.localArtifactRepository.getArtifactFile(key);
        }
        return null;
    }

    public final File getArtifactFile(IArtifactDescriptor descriptor) throws MirroringFailedException {
        if (this.makeLocallyAvailable(descriptor.getArtifactKey())) {
            return this.localArtifactRepository.getArtifactFile(descriptor);
        }
        return null;
    }

    public final IStatus getArtifact(IArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException, MirroringFailedException {
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        if (this.makeLocallyAvailable(requestedKey)) {
            return this.localArtifactRepository.getArtifact(sink, monitor);
        }
        return MirroringArtifactProvider.artifactNotFoundStatus(requestedKey);
    }

    public final IStatus getRawArtifact(IRawArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException, MirroringFailedException {
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        if (this.makeLocallyAvailable(requestedKey)) {
            return this.localArtifactRepository.getRawArtifact(sink, monitor);
        }
        return MirroringArtifactProvider.artifactNotFoundStatus(requestedKey);
    }

    public final IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) throws MirroringFailedException {
        if (this.localArtifactRepository.contains(key)) {
            return this.localArtifactRepository.getArtifactDescriptors(key);
        }
        if (this.remoteProviders.contains(key)) {
            return (IArtifactDescriptor[])Arrays.stream(this.remoteProviders.getArtifactDescriptors(key)).filter(ArtifactTransferPolicy::isCanonicalFormat).map(base -> new MirrorArtifactDescriptor((IArtifactDescriptor)base, this)).toArray(IArtifactDescriptor[]::new);
        }
        return new IArtifactDescriptor[0];
    }

    public final boolean contains(IArtifactDescriptor descriptor) throws MirroringFailedException {
        if (descriptor instanceof MirrorArtifactDescriptor) {
            MirrorArtifactDescriptor mirrorDescriptor = (MirrorArtifactDescriptor)descriptor;
            return mirrorDescriptor.provider == this;
        }
        return this.localArtifactRepository.contains(descriptor) || this.remoteProviders.contains(descriptor);
    }

    private boolean makeLocallyAvailable(IArtifactKey key) throws MirroringFailedException {
        try {
            boolean isAvailable = this.makeOneFormatLocallyAvailable(key);
            if (isAvailable) {
                this.ensureArtifactIsPresentInCanonicalFormat(key);
            }
            return isAvailable;
        }
        catch (ProvisionException e) {
            if (1201 == e.getStatus().getCode()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.makeLocallyAvailable(key);
            }
            throw new MirroringFailedException("Error while mirroring artifact " + String.valueOf(key) + " to the local Maven repository" + e.getMessage(), e);
        }
        catch (ArtifactSinkException e) {
            throw new MirroringFailedException("Error while mirroring artifact " + String.valueOf(key) + " to the local Maven repository" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean makeOneFormatLocallyAvailable(IArtifactKey key) throws MirroringFailedException, ProvisionException, ArtifactSinkException {
        if (this.isFileAlreadyAvailable(key)) {
            return true;
        }
        if (this.remoteProviders.contains(key)) {
            Lock downloadLock = this.localArtifactRepository.getLockForDownload(key);
            downloadLock.lock();
            try {
                if (!this.isFileAlreadyAvailable(key)) {
                    GAVArtifactDescriptor descriptor;
                    File artifactFile;
                    if (this.localArtifactRepository.contains(key)) {
                        artifactFile = this.localArtifactRepository.getArtifactFile(key);
                        this.localArtifactRepository.removeDescriptor(key);
                    } else {
                        artifactFile = this.localArtifactRepository.internalGetArtifactStorageLocation((IArtifactDescriptor)this.localArtifactRepository.createArtifactDescriptor(key));
                    }
                    if (artifactFile != null && artifactFile.isFile() && this.fileMatchesProperties(artifactFile, (descriptor = this.newLocalDescriptor(key)).getProperties(), this.mavenContext.getChecksumsMode() == MavenContext.ChecksumPolicy.STRICT)) {
                        this.localArtifactRepository.internalAddDescriptor((IArtifactDescriptor)descriptor);
                        this.localArtifactRepository.save();
                        boolean bl = true;
                        return bl;
                    }
                    this.downloadArtifact(key);
                    this.localArtifactRepository.save();
                }
            }
            finally {
                downloadLock.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileMatchesProperties(File file, Map<String, String> properties, boolean logFailure) {
        String downloadSize = properties.get("download.size");
        if (downloadSize != null && !downloadSize.equals(String.valueOf(file.length()))) {
            if (!logFailure) return false;
            this.mavenContext.getLogger().warn("File size for " + file.getAbsolutePath() + " does not match, attempting to download file again...");
            return false;
        }
        String sha256 = properties.get("download.checksum.sha-256");
        if (sha256 != null) {
            try (FileInputStream stream2 = new FileInputStream(file);){
                String fileSha256 = DigestUtils.sha256Hex((InputStream)stream2);
                if (fileSha256.equalsIgnoreCase(sha256)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                this.mavenContext.getLogger().debug("Computing hash sum failed, assume file is corrupted (" + String.valueOf(e) + ")");
            }
            if (!logFailure) return false;
            this.mavenContext.getLogger().warn("sha-256 checksum for " + file.getAbsolutePath() + " does not match, attempting to download file again...");
            return false;
        }
        String md5 = properties.get("download.checksum.md5");
        if (md5 == null) return false;
        try (FileInputStream stream = new FileInputStream(file);){
            String fileMd5 = DigestUtils.md5Hex((InputStream)stream);
            if (fileMd5.equalsIgnoreCase(md5)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.mavenContext.getLogger().debug("Computing hash sum failed, assume file is corrupted (" + String.valueOf(e) + ")");
        }
        if (!logFailure) return false;
        this.mavenContext.getLogger().warn("md5 checksum for " + file.getAbsolutePath() + " does not match, attempting to download file again...");
        return false;
    }

    protected final void downloadArtifact(IArtifactKey key) throws MirroringFailedException, ProvisionException, ArtifactSinkException {
        IStatus transferStatus = this.downloadMostSpecificNeededFormatOfArtifact(key);
        if (transferStatus.matches(12)) {
            this.splittingLogger.error(StatusTool.toLogMessage((IStatus)transferStatus));
            throw new MirroringFailedException("Could not mirror artifact " + String.valueOf(key) + " into the local Maven repository.See log output for details.", StatusTool.findException((IStatus)transferStatus));
        }
        if (transferStatus.matches(2)) {
            this.splittingLogger.warn(StatusTool.toLogMessage((IStatus)transferStatus));
        }
    }

    protected IStatus downloadMostSpecificNeededFormatOfArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        return this.downloadCanonicalArtifact(key);
    }

    protected final IStatus downloadCanonicalArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        GAVArtifactDescriptor localDescriptor = this.newLocalDescriptor(key);
        IArtifactSink localSink = this.localArtifactRepository.newAddingArtifactSink((IArtifactDescriptor)localDescriptor);
        return this.remoteProviders.getArtifact(localSink, this.monitorForDownload());
    }

    protected GAVArtifactDescriptor newLocalDescriptor(IArtifactKey key) {
        GAVArtifactDescriptor localDescriptor = this.localArtifactRepository.createArtifactDescriptor(key);
        IArtifactDescriptor remoteDescriptor = MirroringArtifactProvider.findCanonicalDescriptor(this.remoteProviders.getArtifactDescriptors(key));
        Map<String, String> properties = this.getProperties(remoteDescriptor);
        properties.forEach((arg_0, arg_1) -> ((GAVArtifactDescriptor)localDescriptor).setProperty(arg_0, arg_1));
        return localDescriptor;
    }

    private void ensureArtifactIsPresentInCanonicalFormat(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        if (MirroringArtifactProvider.findCanonicalDescriptor(this.localArtifactRepository.getArtifactDescriptors(key)) == null) {
            this.downloadCanonicalArtifact(key);
        }
    }

    static IArtifactDescriptor findCanonicalDescriptor(IArtifactDescriptor[] descriptors) {
        for (IArtifactDescriptor descriptor : descriptors) {
            if (!ArtifactTransferPolicy.isCanonicalFormat(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    private static IStatus artifactNotFoundStatus(IArtifactKey key) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", 1200, "Artifact " + String.valueOf(key) + " is neither available in the local Maven repository nor in the configured remote repositories", null);
    }

    final IProgressMonitor monitorForDownload() {
        return new DuplicateFilteringLoggingProgressMonitor(this.logger);
    }

    private static IProgressMonitor nonNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        if (this.localArtifactRepository.contains(artifactKey)) {
            if (this.mavenContext.isOffline()) {
                return true;
            }
            if (this.remoteProviders.contains(artifactKey)) {
                Map<String, String> localProperties;
                Map<String, String> remoteProperties;
                File artifactFile;
                IArtifactDescriptor[] remoteDescriptors = this.remoteProviders.getArtifactDescriptors(artifactKey);
                IArtifactDescriptor remoteDescriptor = MirroringArtifactProvider.findCanonicalDescriptor(remoteDescriptors);
                IArtifactDescriptor[] localDescriptors = this.localArtifactRepository.getArtifactDescriptors(artifactKey);
                GAVArtifactDescriptor localDescriptor = (GAVArtifactDescriptor)MirroringArtifactProvider.findCanonicalDescriptor(localDescriptors);
                if (this.mavenContext.getChecksumsMode() == MavenContext.ChecksumPolicy.STRICT && remoteDescriptor != null && localDescriptor != null && (artifactFile = this.localArtifactRepository.getArtifactFile((IArtifactDescriptor)localDescriptor)) != null && artifactFile.isFile() && !this.fileMatchesProperties(artifactFile, remoteDescriptor.getProperties(), false)) {
                    return false;
                }
                if (remoteDescriptor != null && localDescriptor != null && localDescriptor.getMavenCoordinates().getGroupId().startsWith("p2.") && !Objects.equals(remoteProperties = this.getProperties(remoteDescriptor), localProperties = this.getProperties((IArtifactDescriptor)localDescriptor))) {
                    if (this.logger.isExtendedDebugEnabled()) {
                        this.logger.info("ArtifactKey " + String.valueOf(artifactKey) + " differs between local and remote:");
                        TreeSet<String> allKeys = new TreeSet<String>();
                        allKeys.addAll(remoteProperties.keySet());
                        allKeys.addAll(localProperties.keySet());
                        for (String key : allKeys) {
                            String localValue;
                            String remoteValue = remoteProperties.get(key);
                            if (Objects.equals(remoteValue, localValue = localProperties.get(key))) continue;
                            this.logger.info("\t" + key + " diverged, remote = " + remoteValue + ", local = " + localValue);
                        }
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private Map<String, String> getProperties(IArtifactDescriptor descriptor) {
        if (descriptor == null) {
            return Map.of();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(descriptor.getProperties());
        if (ArtifactTransferPolicy.isCanonicalFormat(descriptor) && "pack200".equals(map.get("maven-classifier"))) {
            map.remove("maven-classifier");
            map.put("maven-extension", "jar");
            map.put("maven-type", "eclipse-plugin");
        }
        return map;
    }

    private static final class MirrorArtifactDescriptor
    extends ArtifactDescriptor {
        final MirroringArtifactProvider provider;
        private IArtifactDescriptor base;

        MirrorArtifactDescriptor(IArtifactDescriptor base, MirroringArtifactProvider provider) {
            super(base);
            this.base = base;
            this.provider = provider;
            this.setRepository(provider.shaddowRepository);
        }

        public boolean equals(Object obj) {
            boolean equals = super.equals(obj);
            if (!equals) {
                return this.base.equals(obj);
            }
            return equals;
        }

        public int hashCode() {
            return this.base.hashCode();
        }
    }

    public static class MirroringFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        MirroringFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

