/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.ArtifactSinkException;
import org.eclipse.tycho.IArtifactSink;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.IRawArtifactSink;
import org.eclipse.tycho.p2.repository.AbstractArtifactRepository2;
import org.eclipse.tycho.p2.repository.ArtifactProviderImplUtilities;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicy;

public abstract class ArtifactRepositoryBaseImpl<ArtifactDescriptorT extends IArtifactDescriptor>
extends AbstractArtifactRepository2
implements IFileArtifactRepository,
IRawArtifactFileProvider {
    private static final IArtifactDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new IArtifactDescriptor[0];
    protected Map<IArtifactKey, Set<ArtifactDescriptorT>> descriptorsMap = new ConcurrentHashMap<IArtifactKey, Set<ArtifactDescriptorT>>();
    private ArtifactTransferPolicy transferPolicy;

    protected ArtifactRepositoryBaseImpl(IProvisioningAgent agent, URI location, ArtifactTransferPolicy transferPolicy) {
        super(agent, null, null, null, location, null, null, null);
        this.transferPolicy = transferPolicy;
    }

    protected abstract IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor var1);

    public final boolean contains(IArtifactKey key) {
        return this.descriptorsMap.containsKey(key);
    }

    public final boolean contains(IArtifactDescriptor descriptor) {
        IArtifactDescriptor comparableDescriptor = this.getComparableDescriptor(descriptor);
        return this.descriptorsMap.values().stream().anyMatch(set -> set.contains(comparableDescriptor));
    }

    public final IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        Set<ArtifactDescriptorT> descriptors = this.descriptorsMap.get(key);
        if (descriptors == null) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return descriptors.toArray(EMPTY_DESCRIPTOR_ARRAY);
    }

    public final IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return query.perform(this.descriptorsMap.keySet().iterator());
    }

    public final IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return (query, monitor) -> query.perform(this.flattenedValues().iterator());
    }

    protected final Stream<ArtifactDescriptorT> flattenedValues() {
        return this.descriptorsMap.values().stream().flatMap(Collection::stream);
    }

    protected abstract ArtifactDescriptorT getInternalDescriptorForAdding(IArtifactDescriptor var1) throws IllegalArgumentException;

    @Override
    protected void internalAddDescriptor(IArtifactDescriptor descriptor) {
        this.internalAddInternalDescriptor(this.getInternalDescriptorForAdding(descriptor));
    }

    protected final void internalAddInternalDescriptor(ArtifactDescriptorT internalDescriptor) {
        Set descriptorsForKey = this.descriptorsMap.computeIfAbsent(internalDescriptor.getArtifactKey(), k -> ConcurrentHashMap.newKeySet());
        descriptorsForKey.add(internalDescriptor);
    }

    @Override
    protected final void internalRemoveDescriptor(IArtifactDescriptor descriptor) {
        IArtifactDescriptor comparableDescriptor = this.getComparableDescriptor(descriptor);
        IArtifactKey artifactKey = comparableDescriptor.getArtifactKey();
        this.descriptorsMap.computeIfPresent(artifactKey, (k, descriptors) -> {
            descriptors.remove(comparableDescriptor);
            return descriptors.isEmpty() ? null : descriptors;
        });
    }

    @Override
    protected final void internalRemoveDescriptors(IArtifactDescriptor[] descriptors) {
        for (IArtifactDescriptor descriptor : descriptors) {
            this.internalRemoveDescriptor(descriptor);
        }
    }

    @Override
    protected void internalRemoveDescriptors(IArtifactKey key) {
        this.descriptorsMap.remove(key);
    }

    @Override
    protected final void internalRemoveDescriptors(IArtifactKey[] keys) {
        for (IArtifactKey key : keys) {
            this.internalRemoveDescriptors(key);
        }
    }

    @Override
    protected final void internalRemoveAllDescriptors() {
        this.descriptorsMap.clear();
    }

    @Override
    protected void internalStore(IProgressMonitor monitor) {
    }

    protected abstract File internalGetArtifactStorageLocation(IArtifactDescriptor var1);

    public final File getArtifactFile(IArtifactDescriptor descriptor) {
        if (this.contains(descriptor)) {
            return this.internalGetArtifactStorageLocation(descriptor);
        }
        return null;
    }

    public final File getArtifactFile(IArtifactKey key) {
        Set<ArtifactDescriptorT> descriptors = this.descriptorsMap.get(key);
        if (descriptors != null) {
            for (IArtifactDescriptor descriptor : descriptors) {
                if (!ArtifactTransferPolicy.isCanonicalFormat(descriptor)) continue;
                return this.internalGetArtifactStorageLocation(descriptor);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        IStatus status = !this.contains(descriptor) ? ArtifactRepositoryBaseImpl.errorStatus("Artifact " + String.valueOf(descriptor) + " is not available in the repository " + String.valueOf(this.getLocation()), null, 1200) : this.getProcessedRawArtifact(descriptor, destination, monitor);
        ArtifactRepositoryBaseImpl.setStatusOnStreamIfPossible(destination, status);
        return status;
    }

    public final IStatus getArtifact(IArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        ArtifactProviderImplUtilities.canWriteToSink(sink);
        ArtifactProviderImplUtilities.canWriteCanonicalArtifactToSink(sink);
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        IArtifactDescriptor[] availableFormats = this.getArtifactDescriptors(requestedKey);
        List<IArtifactDescriptor> formatsByPreference = this.transferPolicy.sortFormatsByPreference(availableFormats);
        Iterator<IArtifactDescriptor> iterator = formatsByPreference.iterator();
        if (iterator.hasNext()) {
            IArtifactDescriptor descriptor = iterator.next();
            IStatus result = this.getProcessedRawArtifact(descriptor, sink.beginWrite(), monitor);
            ArtifactRepositoryBaseImpl.closeSinkAccordingToStatus(sink, result);
            return result;
        }
        return ArtifactRepositoryBaseImpl.errorStatus("Artifact " + String.valueOf(requestedKey) + " is not available in the repository " + String.valueOf(this.getLocation()), null, 1200);
    }

    private IStatus getProcessedRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        OutputStream destinationWithProcessing = new ProcessingStepHandler().createAndLink(this.getProvisioningAgent(), descriptor.getProcessingSteps(), descriptor, destination, monitor);
        IStatus initStatus = ProcessingStepHandler.getStatus((OutputStream)destinationWithProcessing, (boolean)true);
        if (ArtifactRepositoryBaseImpl.isFatal(initStatus)) {
            return initStatus;
        }
        IStatus rawReadingStatus = this.readRawArtifact(descriptor, destinationWithProcessing);
        if (ArtifactRepositoryBaseImpl.isFatal(rawReadingStatus)) {
            return rawReadingStatus;
        }
        try {
            this.closeProcessingSteps(destinationWithProcessing);
        }
        catch (IOException e) {
            return ArtifactRepositoryBaseImpl.errorStatus("I/O exception while processing raw artifact " + String.valueOf(descriptor), e);
        }
        IStatus processingStatus = ProcessingStepHandler.getStatus((OutputStream)destinationWithProcessing, (boolean)true);
        return processingStatus;
    }

    private void closeProcessingSteps(OutputStream destinationWithProcessing) throws IOException {
        if (destinationWithProcessing instanceof ProcessingStep) {
            destinationWithProcessing.close();
        }
    }

    public final IStatus getRawArtifact(IRawArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        ArtifactProviderImplUtilities.canWriteToSink((IArtifactSink)sink);
        IArtifactDescriptor descriptor = sink.getArtifactFormatToBeWritten();
        if (!this.contains(descriptor)) {
            return ArtifactRepositoryBaseImpl.errorStatus("Artifact " + String.valueOf(descriptor) + " is not available in the repository " + String.valueOf(this.getLocation()), null, 1200);
        }
        IStatus status = this.readRawArtifact(descriptor, sink.beginWrite());
        ArtifactRepositoryBaseImpl.closeSinkAccordingToStatus((IArtifactSink)sink, status);
        return status;
    }

    private IStatus readRawArtifact(IArtifactDescriptor descriptor, OutputStream destination) {
        File file = this.internalGetArtifactStorageLocation(descriptor);
        if (file.isFile()) {
            try (FileInputStream source = new FileInputStream(file);){
                ((InputStream)source).transferTo(destination);
            }
            catch (IOException e) {
                return ArtifactRepositoryBaseImpl.errorStatus("I/O exception while reading artifact " + String.valueOf(descriptor), e);
            }
            return Status.OK_STATUS;
        }
        IArtifactRepository repository = descriptor.getRepository();
        if (repository != this && repository != null) {
            return repository.getArtifact(descriptor, destination, null);
        }
        return Status.error((String)("File " + String.valueOf(file) + " points to a non existing file and can't be fetched from the descriptors repository!"));
    }

    private static void closeSinkAccordingToStatus(IArtifactSink sink, IStatus status) throws ArtifactSinkException {
        if (ArtifactRepositoryBaseImpl.isFatal(status)) {
            sink.abortWrite();
        } else {
            sink.commitWrite();
        }
    }

    @Override
    public final IArtifactSink newAddingArtifactSink(IArtifactDescriptor descriptor) throws ProvisionException {
        ArtifactDescriptorT newDescriptor = this.getInternalDescriptorForAdding(descriptor);
        return this.internalNewAddingArtifactSink(newDescriptor);
    }

    protected final AddingArtifactSink internalNewAddingArtifactSink(ArtifactDescriptorT canonicalDescriptorToBeAdded) throws ProvisionException {
        return new AddingArtifactSink(this, canonicalDescriptorToBeAdded);
    }

    @Override
    public final IRawArtifactSink newAddingRawArtifactSink(IArtifactDescriptor newDescriptor) throws ProvisionException {
        ArtifactDescriptorT newInternalDescriptorToBeAdded = this.getInternalDescriptorForAdding(newDescriptor);
        return new RawAddingArtifactSink(this, newInternalDescriptorToBeAdded);
    }

    static IStatus errorStatus(String message, Throwable cause) {
        return ArtifactRepositoryBaseImpl.errorStatus(message, cause, 0);
    }

    static IStatus errorStatus(String message, Throwable cause, int code) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, cause);
    }

    private static class AddingArtifactSink
    implements IArtifactSink {
        protected final ArtifactDescriptorT newDescriptor;
        private OutputStream currentOutputStream = null;
        private boolean committed = false;
        final /* synthetic */ ArtifactRepositoryBaseImpl this$0;

        AddingArtifactSink(ArtifactDescriptorT newDescriptor) throws ProvisionException {
            this.this$0 = var1_1;
            if (var1_1.contains((IArtifactDescriptor)newDescriptor)) {
                IStatus status = ArtifactRepositoryBaseImpl.errorStatus("Artifact " + String.valueOf(newDescriptor) + " already exists in repository " + String.valueOf(var1_1.getLocation()), null, 1201);
                throw new ProvisionException(status);
            }
            this.newDescriptor = newDescriptor;
        }

        public IArtifactKey getArtifactToBeWritten() {
            return this.newDescriptor.getArtifactKey();
        }

        public boolean canBeginWrite() {
            return !this.committed;
        }

        public OutputStream beginWrite() throws IllegalStateException, ArtifactSinkException {
            if (this.committed) {
                throw new IllegalStateException("This sink has already been used to add an artifact. Cannot start another write operation.");
            }
            this.abortWrite();
            File artifactFile = this.this$0.internalGetArtifactStorageLocation((IArtifactDescriptor)this.newDescriptor);
            artifactFile.getParentFile().mkdirs();
            try {
                this.currentOutputStream = new BufferedOutputStream(new FileOutputStream(artifactFile));
            }
            catch (FileNotFoundException e) {
                throw new ArtifactSinkException("I/O error while creating artifact file " + String.valueOf(artifactFile), (Throwable)e);
            }
            return this.currentOutputStream;
        }

        public void commitWrite() throws IllegalStateException, ArtifactSinkException {
            if (this.currentOutputStream == null) {
                throw new IllegalStateException("Write operation has not yet been started. Cannot add artifact.");
            }
            try {
                this.currentOutputStream.close();
            }
            catch (IOException e) {
                throw new ArtifactSinkException("I/O error while closing artifact file", (Throwable)e);
            }
            finally {
                this.currentOutputStream = null;
            }
            this.this$0.internalAddInternalDescriptor(this.newDescriptor);
            this.this$0.internalStore(null);
        }

        public void abortWrite() throws ArtifactSinkException {
            if (this.currentOutputStream == null) {
                return;
            }
            try {
                this.currentOutputStream.close();
            }
            catch (IOException e) {
                throw new ArtifactSinkException("I/O error while closing artifact file", (Throwable)e);
            }
            finally {
                this.currentOutputStream = null;
            }
        }
    }

    private class RawAddingArtifactSink
    extends AddingArtifactSink
    implements IRawArtifactSink {
        RawAddingArtifactSink(ArtifactDescriptorT newDescriptor) throws ProvisionException {
            super((ArtifactRepositoryBaseImpl)var1_1, newDescriptor);
        }

        public IArtifactDescriptor getArtifactFormatToBeWritten() {
            return this.newDescriptor;
        }
    }
}

