/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.MetadataIO;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public abstract class AbstractMavenMetadataRepository
extends AbstractMetadataRepository {
    protected final TychoRepositoryIndex metadataIndex;
    protected final RepositoryReader contentLocator;
    protected Set<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
    protected Map<GAV, Set<IInstallableUnit>> unitsMap = new LinkedHashMap<GAV, Set<IInstallableUnit>>();

    public AbstractMavenMetadataRepository(IProvisioningAgent agent, URI location, TychoRepositoryIndex metadataIndex, RepositoryReader contentLocator) {
        super(agent);
        this.setLocation(location);
        this.metadataIndex = metadataIndex;
        this.contentLocator = contentLocator;
        if (metadataIndex != null && contentLocator != null) {
            this.load();
        }
    }

    protected void load() {
        MetadataIO io = new MetadataIO();
        for (GAV gav : this.metadataIndex.getProjectGAVs()) {
            try {
                File localArtifactFileLocation = this.contentLocator.getLocalArtifactLocation(gav, "p2metadata", "p2-metadata");
                if (!localArtifactFileLocation.exists()) {
                    this.metadataIndex.removeGav(gav);
                    continue;
                }
                try (FileInputStream is = new FileInputStream(localArtifactFileLocation);){
                    Set<IInstallableUnit> gavUnits = io.readXML(is);
                    this.unitsMap.put(gav, gavUnits);
                    this.units.addAll(gavUnits);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return query.perform(this.units.iterator());
    }

    public Map<GAV, Set<IInstallableUnit>> getGAVs() {
        return this.unitsMap;
    }

    public Collection<IRepositoryReference> getReferences() {
        return Collections.emptyList();
    }
}

