/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.publisher.rootfiles;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tycho.p2.publisher.rootfiles.AbstractFileSet;
import org.eclipse.tycho.p2.publisher.rootfiles.FileToPathMap;

public class FileSet
extends AbstractFileSet {
    private File baseDir;
    private String destinationDir;

    public FileSet(File baseDir, String pattern) {
        this(baseDir, pattern, "", true);
    }

    public FileSet(File baseDir, String pattern, String destinationDir, boolean useDefaultExcludes) {
        super(pattern, useDefaultExcludes);
        this.baseDir = baseDir;
        this.destinationDir = destinationDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public FileToPathMap scan() {
        FileToPathMap result = new FileToPathMap();
        this.recursiveScan(this.baseDir, result, Path.fromOSString((String)this.baseDir.getAbsolutePath()), Path.fromOSString((String)this.destinationDir));
        return result;
    }

    private void recursiveScan(File file, FileToPathMap result, IPath baseDirPath, IPath destinationPath) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                if (subFile.isDirectory()) {
                    this.recursiveScan(subFile, result, baseDirPath, destinationPath);
                    continue;
                }
                if (!subFile.isFile()) continue;
                this.addFileIfMatch(subFile, result, baseDirPath, destinationPath);
            }
        } else if (file.isFile()) {
            this.addFileIfMatch(file, result, baseDirPath, destinationPath);
        }
    }

    private void addFileIfMatch(File file, FileToPathMap result, IPath baseDir, IPath destination) {
        IPath relativePath = Path.fromOSString((String)file.getAbsolutePath()).makeRelativeTo(baseDir);
        IPath destinationPath = destination.append(relativePath);
        if (this.matches(relativePath)) {
            result.put(file, destinationPath);
        }
    }
}

