/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.repository.RepositoryContent;

public class ArtifactDescriptorRepositoryContentCapability
implements Capability,
RepositoryContent {
    private IArtifactDescriptor descriptor;
    private IArtifactRepository artifactRepository;
    private Map<String, Object> attributes;
    private Resource resource;

    public ArtifactDescriptorRepositoryContentCapability(Resource resource, IArtifactDescriptor descriptor, IArtifactRepository artifactRepository) {
        String contentType;
        String size;
        this.resource = resource;
        this.descriptor = descriptor;
        this.artifactRepository = artifactRepository;
        HashMap<String, Object> map = new HashMap<String, Object>(descriptor.getProperties());
        String content = descriptor.getProperty("download.checksum.sha-256");
        if (content != null) {
            map.put("osgi.content", content);
        }
        if ((size = descriptor.getProperty("download.size")) != null) {
            map.put("size", Long.parseLong(size));
        }
        if ((contentType = descriptor.getProperty("download.contentType")) != null) {
            map.put("mime", contentType);
        }
        this.attributes = Map.copyOf(map);
    }

    public InputStream getContent() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        final IStatus status = this.artifactRepository.getArtifact(this.descriptor, (OutputStream)outputStream, null);
        if (!status.isOK()) {
            return new InputStream(this){

                @Override
                public int read() throws IOException {
                    throw new IOException(status.toString(), status.getException());
                }
            };
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public String getNamespace() {
        return "osgi.content";
    }

    public Map<String, String> getDirectives() {
        return Map.of();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Resource getResource() {
        return this.resource;
    }
}

