/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;

class EclipseModuleConnector
implements ModuleConnector {
    private static final SwtClassLoader SWT_CLASS_LOADER = new SwtClassLoader();
    private Map<String, ConnectModule> modules = new ConcurrentHashMap<String, ConnectModule>();

    public void initialize(File storage, Map<String, String> configuration) {
    }

    public Optional<ConnectModule> connect(String location) throws BundleException {
        return Optional.ofNullable(this.modules.get(location));
    }

    public Optional<BundleActivator> newBundleActivator() {
        return Optional.empty();
    }

    public String newBundle(Class<?> clazz, String[] requireBundles) {
        URI location = EclipseModuleConnector.getLocationFromClass(clazz);
        if (location == null) {
            throw new RuntimeException("can't get location of class " + String.valueOf(clazz));
        }
        String id = "eclipse-" + UUID.randomUUID().toString();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Bundle-Name", clazz.getName());
        header.put("Bundle-SymbolicName", id);
        header.put("Bundle-Version", "1.0.0");
        header.put("DynamicImport-Package", "*");
        if (requireBundles != null && requireBundles.length > 0) {
            header.put("Require-Bundle", Arrays.stream(requireBundles).collect(Collectors.joining(",")));
        }
        this.modules.put(id, new TempBundle(new File(location), header));
        return id;
    }

    public String newFragment(Class<?> clazz, Bundle bundle) {
        URI location = EclipseModuleConnector.getLocationFromClass(clazz);
        if (location == null) {
            throw new RuntimeException("can't get location of class " + String.valueOf(clazz));
        }
        String id = "eclipse-fragment" + UUID.randomUUID().toString();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Bundle-Name", clazz.getName());
        header.put("Bundle-SymbolicName", id);
        header.put("Bundle-Version", "1.0.0");
        header.put("Fragment-Host", bundle.getSymbolicName());
        this.modules.put(id, new TempBundle(new File(location), header));
        return id;
    }

    public void release(String id) {
        this.modules.remove(id);
    }

    public String loadSWT(Path bundleFile) {
        if (bundleFile.getFileName().toString().contains("org.eclipse.swt")) {
            return this.loadGlobalSWT(bundleFile);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadGlobalSWT(Path bundleFile) {
        try (JarFile jarFile = new JarFile(bundleFile.toFile());){
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            String bsn = attributes.getValue("Bundle-SymbolicName").split(";")[0];
            if ("org.eclipse.swt".equals(bsn)) {
                String string = this.createSingleSwtBundleLoader(bundleFile, bsn);
                return string;
            }
            String value = attributes.getValue("Fragment-Host");
            if (value == null) return null;
            String host = value.split(";")[0];
            if (!"org.eclipse.swt".equals(host)) return null;
            String string = this.createSingleSwtBundleLoader(bundleFile, bsn);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String createSingleSwtBundleLoader(Path bundleFile, String bsn) {
        this.modules.put(bsn, new SwtBundle(bundleFile));
        return bsn;
    }

    static URI getLocationFromClass(Class<?> clazz) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return null;
        }
        try {
            return url.toURI().normalize();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static final class TempBundle
    extends ZipBundle {
        private Map<String, String> header;

        public TempBundle(File location, Map<String, String> header) {
            super(location);
            this.header = header;
        }

        public Optional<Map<String, String>> getHeaders() {
            return Optional.of(this.header);
        }

        public Optional<ClassLoader> getClassLoader() {
            return Optional.empty();
        }
    }

    private static final class SwtBundle
    extends ZipBundle {
        public SwtBundle(Path location) {
            super(location.toFile());
            SWT_CLASS_LOADER.addURL(location);
        }

        public Optional<Map<String, String>> getHeaders() {
            return Optional.empty();
        }

        public Optional<ClassLoader> getClassLoader() {
            return Optional.of(SWT_CLASS_LOADER);
        }
    }

    private static final class SwtClassLoader
    extends URLClassLoader {
        private Set<String> added = new HashSet<String>();

        public SwtClassLoader() {
            super(new URL[0], (ClassLoader)null);
        }

        public synchronized void addURL(Path path) {
            if (this.added.add(path.toAbsolutePath().toString())) {
                try {
                    super.addURL(path.toFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    System.err.println("Can't add path " + String.valueOf(path) + ": " + String.valueOf(e));
                }
            }
        }
    }

    private static final class ZipConnectEntry
    implements ConnectContent.ConnectEntry {
        private ZipEntry entry;
        private JarFile jarFile;

        public ZipConnectEntry(JarFile jarFile, ZipEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public long getContentLength() {
            return this.entry.getSize();
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.entry);
        }
    }

    private static abstract class ZipBundle
    implements ConnectModule,
    ConnectContent {
        private JarFile jarFile;
        private final File location;

        public ZipBundle(File location) {
            this.location = location;
        }

        public ConnectContent getContent() throws IOException {
            return this;
        }

        public Iterable<String> getEntries() throws IOException {
            if (this.jarFile == null) {
                return Collections.emptyList();
            }
            return this.jarFile.stream().map(ZipEntry::getName).toList();
        }

        public Optional<ConnectContent.ConnectEntry> getEntry(String path) {
            if (this.jarFile == null) {
                return Optional.empty();
            }
            ZipEntry entry = this.jarFile.getEntry(path);
            if (entry == null) {
                return Optional.empty();
            }
            return Optional.of(new ZipConnectEntry(this.jarFile, entry));
        }

        public void open() throws IOException {
            if (this.jarFile == null && this.location != null) {
                this.jarFile = new JarFile(this.location);
            }
        }

        public void close() throws IOException {
            if (this.jarFile != null) {
                try {
                    this.jarFile.close();
                }
                finally {
                    this.jarFile = null;
                }
            }
        }
    }
}

