/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;

@Component(role=EclipseApplicationFactory.class)
@SessionScoped
public class EclipseApplicationFactory {
    @Requirement
    private ToolchainManager toolchainManager;
    @Requirement
    private P2ResolverFactory resolverFactory;
    @Requirement
    private TargetPlatformFactory platformFactory;
    @Requirement
    private Logger logger;
    private MavenSession mavenSession;

    @Inject
    public EclipseApplicationFactory(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public EclipseApplication createEclipseApplication(MavenRepositoryLocation repositoryLocation, String name) {
        return this.createEclipseApplication(this.createTargetPlatform(List.of(repositoryLocation)), name);
    }

    public EclipseApplication createEclipseApplication(TargetPlatform targetPlatform, String name) {
        P2Resolver resolver = this.createResolver();
        EclipseApplication application = new EclipseApplication(name, resolver, targetPlatform, this.logger, this.mavenSession.getAllProjects().stream().collect(Collectors.toMap(MavenProject::getBasedir, Function.identity())));
        application.addBundle("org.eclipse.core.runtime");
        application.addBundle("org.apache.felix.scr");
        application.addBundle("org.eclipse.equinox.app");
        application.addBundle("org.eclipse.equinox.launcher");
        return application;
    }

    public TargetPlatform createTargetPlatform(Collection<MavenRepositoryLocation> locations) {
        TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
        tpConfiguration.setIgnoreLocalArtifacts(true);
        tpConfiguration.setIncludeSourceMode(IncludeSourceMode.ignore);
        for (MavenRepositoryLocation location : locations) {
            tpConfiguration.addP2Repository(location);
        }
        int javaVersion = Runtime.version().feature();
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, false, this.toolchainManager, this.mavenSession);
        eeConfiguration.setProfileConfiguration("JavaSE-" + javaVersion, "tycho-eclipse-application-resolver");
        TargetPlatform targetPlatform = this.platformFactory.createTargetPlatform(tpConfiguration, eeConfiguration, null);
        return targetPlatform;
    }

    public Collection<Path> getApiBaselineBundles(Collection<MavenRepositoryLocation> baselineRepoLocations, ArtifactKey artifactKey, Collection<TargetEnvironment> environment) throws IllegalArtifactReferenceException {
        P2Resolver resolver = this.createResolver(environment);
        resolver.addDependency("p2-installable-unit", artifactKey.getId(), "0.0.0");
        ArrayList<Path> resolvedBundles = new ArrayList<Path>();
        TargetPlatform targetPlatform = this.createTargetPlatform(baselineRepoLocations);
        for (P2ResolutionResult result : resolver.resolveTargetDependencies(targetPlatform, null).values()) {
            for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
                if (!"eclipse-plugin".equals(entry.getType()) || "org.eclipse.osgi".equals(entry.getId())) continue;
                File location = entry.getLocation(true);
                if (location == null) {
                    this.logger.warn("Cannot resolve location for bundle " + entry.getId() + " " + entry.getVersion() + ". The artifact may not be available or failed to download.");
                    continue;
                }
                resolvedBundles.add(location.toPath());
            }
        }
        return resolvedBundles;
    }

    public P2Resolver createResolver() {
        return this.createResolver(List.of(TargetEnvironment.getRunningEnvironment()));
    }

    public P2Resolver createResolver(Collection<TargetEnvironment> environments) {
        P2Resolver resolver = this.resolverFactory.createResolver(environments);
        return resolver;
    }
}

