/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.shared.MavenLogger;

@Component(role=MavenLogger.class, hint="filtering")
public class FilteringMavenLogger
implements MavenLogger {
    static final String HINT = "filtering";
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private Logger logger;
    private Map<MavenProject, Set<LogKey>> messageLogMap = new ConcurrentHashMap<MavenProject, Set<LogKey>>();

    @Override
    public void error(String message, Throwable cause) {
        if (this.logger.isErrorEnabled() && this.mustLog(message, cause, 1)) {
            this.logger.error(message, cause);
        }
    }

    private boolean mustLog(String message, Throwable cause, int type) {
        if (this.legacySupport == null) {
            return true;
        }
        MavenSession session = this.legacySupport.getSession();
        if (session == null) {
            return true;
        }
        MavenProject project = session.getCurrentProject();
        if (project == null) {
            return true;
        }
        LogKey logKey = cause == null ? new LogKey(message, "", type) : new LogKey(message, cause.toString(), type);
        return this.messageLogMap.computeIfAbsent(project, p -> ConcurrentHashMap.newKeySet()).add(logKey);
    }

    @Override
    public void warn(String message, Throwable cause) {
        if (this.logger.isWarnEnabled() && this.mustLog(message, cause, 2)) {
            this.logger.warn(message, cause);
        }
    }

    @Override
    public void info(String message) {
        if (this.logger.isInfoEnabled() && this.mustLog(message, null, 3)) {
            this.logger.info(message);
        }
    }

    @Override
    public void debug(String message, Throwable cause) {
        if (this.logger.isDebugEnabled() && this.mustLog(message, cause, 4)) {
            this.logger.warn(message, cause);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public <T> T adapt(Class<T> adapt) {
        if (adapt == Logger.class) {
            return adapt.cast(this.logger);
        }
        return null;
    }

    private record LogKey(String msg, String t, int type) {
    }
}

