/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import java.util.regex.Pattern;
import org.eclipse.tycho.core.shared.LoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenLogger;

public final class DuplicateFilteringLoggingProgressMonitor
extends LoggingProgressMonitor {
    private static final String NON_MATCHING_LINE = "";
    private String lastLine = "";
    private static final Pattern PATTERN_FETCHING = Pattern.compile("Fetching \\S+ from");

    public DuplicateFilteringLoggingProgressMonitor(MavenLogger logger) {
        super(logger);
    }

    @Override
    public boolean suppressOutputOf(String text) {
        if (text.equals("1 operation remaining.")) {
            return true;
        }
        if (text.equals("Performing subquery")) {
            return true;
        }
        boolean isUnneededLine = this.checkIfDuplicateOfLastOutput(text);
        return isUnneededLine;
    }

    private boolean checkIfDuplicateOfLastOutput(String message) {
        if (!PATTERN_FETCHING.matcher(message).find()) {
            this.lastLine = NON_MATCHING_LINE;
            return false;
        }
        boolean duplicate = message.equals(this.lastLine);
        this.lastLine = message;
        return duplicate;
    }
}

