/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.m2e.pde.target.shared.AdditionalRepository;
import org.eclipse.m2e.pde.target.shared.DependencyDepth;
import org.eclipse.m2e.pde.target.shared.DependencyResult;
import org.eclipse.m2e.pde.target.shared.MavenBundleWrapper;
import org.eclipse.m2e.pde.target.shared.MavenDependencyCollector;
import org.eclipse.m2e.pde.target.shared.MavenRootDependency;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;
import org.eclipse.m2e.pde.target.shared.WrappedBundle;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.core.DependencyResolutionException;
import org.eclipse.tycho.core.MavenDependenciesResolver;
import org.eclipse.tycho.core.MavenModelFacade;
import org.eclipse.tycho.core.maven.AetherArtifactFacade;
import org.eclipse.tycho.core.publisher.TychoMavenPropertiesAdvice;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.resolver.target.SupplierMetadataRepository;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.resolver.BundlePublisher;
import org.eclipse.tycho.p2.resolver.FeatureGenerator;
import org.eclipse.tycho.p2.resolver.FeaturePublisher;
import org.eclipse.tycho.p2.resolver.WrappedArtifact;
import org.eclipse.tycho.p2maven.advices.MavenChecksumAdvice;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.osgi.framework.BundleException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenTargetDefinitionContent
implements TargetDefinitionContent {
    private static final RemoteRepository CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").setReleasePolicy(new RepositoryPolicy(true, "never", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "never", "warn")).build();
    private static final String POM_PACKAGING_TYPE = "pom";
    private final Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private SupplierMetadataRepository metadataRepository;
    private FileArtifactRepository artifactRepository;
    private MavenContext mavenContext;

    MavenTargetDefinitionContent(TargetDefinition.MavenGAVLocation location, MavenDependenciesResolver mavenDependenciesResolver, IncludeSourceMode sourceMode, IProvisioningAgent agent, MavenContext mavenContext, SyncContextFactory syncContextFactory, MavenSession mavenSession, RepositorySystem repositorySystem) {
        this.mavenContext = mavenContext;
        MavenLogger logger = mavenContext.getLogger();
        File repositoryRoot = mavenDependenciesResolver.getRepositoryRoot();
        boolean includeSource = sourceMode == IncludeSourceMode.force || sourceMode == IncludeSourceMode.honor && location.includeSource();
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.repositoryContent.values().iterator());
        this.metadataRepository.setLocation(repositoryRoot.toURI());
        this.metadataRepository.setName(repositoryRoot.getName());
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.repositoryContent.keySet().stream().filter(Predicate.not(FeaturePublisher::isMetadataOnly)).iterator());
        this.artifactRepository.setName(repositoryRoot.getName());
        this.artifactRepository.setLocation(repositoryRoot.toURI());
        Collection instructions = location.getInstructions();
        ArrayList<Feature> features = new ArrayList<Feature>();
        logger.info("Resolving " + String.valueOf(location));
        HashMap<String, Properties> instructionsMap = new HashMap<String, Properties>();
        for (TargetDefinition.BNDInstructions instruction : instructions) {
            String reference = instruction.getReference();
            Properties properties = instruction.getInstructions();
            instructionsMap.put(reference, properties);
            logger.info((reference.isEmpty() ? "default instructions" : reference) + " = " + String.valueOf(properties));
        }
        List<AdditionalRepository> references = location.getRepositoryReferences().stream().map(rr -> new AdditionalRepository(rr.getId(), rr.getUrl())).toList();
        MavenDependencyCollector collector = new MavenDependencyCollector(repositorySystem, mavenSession.getRepositorySession(), this.getRepos(mavenSession), references, this.convert(location.getIncludeDependencyDepth()), location.getIncludeDependencyScopes());
        ArrayList<IInstallableUnit> locationBundles = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> locationSourceBundles = new ArrayList<IInstallableUnit>();
        for (TargetDefinition.MavenDependency mavenDependency : location.getRoots()) {
            Optional<File> pomFacade;
            ResolvedMavenArtifacts resolve;
            try {
                resolve = this.resolveRoot(collector, mavenDependency);
            }
            catch (RepositoryException re) {
                throw new TargetDefinitionResolutionException("MavenDependency " + String.valueOf(mavenDependency) + " of location " + String.valueOf(location) + " could not be resolved", (Throwable)re);
            }
            Iterator resolvedArtifacts = resolve.facades().stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
            Properties defaultProperties = WrappedArtifact.createPropertiesForPrefix("wrapped");
            ArrayList<IInstallableUnit> bundles = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> sourceBundles = new ArrayList<IInstallableUnit>();
            while (resolvedArtifacts.hasNext()) {
                String bundleVersion;
                String symbolicName;
                IArtifactFacade mavenArtifact = (IArtifactFacade)resolvedArtifacts.next();
                if (mavenDependency.isIgnored(mavenArtifact)) {
                    logger.debug("Skip ignored " + String.valueOf(mavenArtifact));
                    continue;
                }
                if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenArtifact.getPackagingType())) {
                    logger.debug("Skip pom artifact " + String.valueOf(mavenArtifact));
                    continue;
                }
                String fileName = mavenArtifact.getLocation().getName();
                if (!"jar".equalsIgnoreCase(FilenameUtils.getExtension((String)fileName))) {
                    logger.info("Skip non-jar artifact (" + fileName + ")");
                    continue;
                }
                logger.debug("Resolved " + String.valueOf(mavenArtifact));
                Feature feature = new FeatureParser().parse(mavenArtifact.getLocation());
                if (feature != null) {
                    feature.setLocation(mavenArtifact.getLocation().getAbsolutePath());
                    features.add(feature);
                    continue;
                }
                String debugString = this.asDebugString(mavenArtifact);
                try {
                    IInstallableUnit unit;
                    File bundleLocation = mavenArtifact.getLocation();
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                    symbolicName = bundleDescription != null ? bundleDescription.getSymbolicName() : null;
                    String string = bundleVersion = bundleDescription != null ? bundleDescription.getVersion().toString() : null;
                    if (symbolicName == null) {
                        if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE) {
                            logger.info("Ignoring " + debugString + " as it is not a bundle and MissingManifestStrategy is set to ignore for this location");
                            continue;
                        }
                        if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR) {
                            throw new TargetDefinitionResolutionException("Artifact " + debugString + " is not a bundle and MissingManifestStrategy is set to error for this location");
                        }
                        try {
                            Function<DependencyNode, Properties> instructionsLookup = node -> instructionsMap.getOrDefault(MavenTargetDefinitionContent.getKey(node.getArtifact()), instructionsMap.getOrDefault("", defaultProperties));
                            WrappedBundle wrappedBundle = MavenBundleWrapper.getWrappedArtifact((Artifact)new DefaultArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getClassifier(), mavenArtifact.getPackagingType(), mavenArtifact.getVersion()), instructionsLookup, collector.getEffectiveRepositories(), repositorySystem, mavenSession.getRepositorySession(), syncContextFactory);
                            List<ProcessingMessage> directErrors = wrappedBundle.messages(false).filter(msg -> msg.type() == ProcessingMessage.Type.ERROR).toList();
                            if (!directErrors.isEmpty()) {
                                String error = directErrors.stream().map(ProcessingMessage::message).collect(Collectors.joining(System.lineSeparator()));
                                String hint = String.format("You can exclude it by adding <exclude>%s</exclude> to your location", debugString);
                                throw new RuntimeException(String.format("Dependency %s of %s can not be wrapped: %s%s%s", debugString, mavenDependency, error, System.lineSeparator().repeat(2), hint));
                            }
                            wrappedBundle.messages(true).map(ProcessingMessage::message).forEach(msg -> logger.warn(debugString + ": " + msg));
                            File file = wrappedBundle.getFile().get().toFile();
                            BundleDescription description = BundlesAction.createBundleDescription((File)file);
                            WrappedArtifact wrappedArtifact = new WrappedArtifact(file, mavenArtifact, mavenArtifact.getClassifier(), description.getSymbolicName(), description.getVersion().toString(), null);
                            logger.info(debugString + " is wrapped as a bundle with bundle symbolic name " + wrappedArtifact.getWrappedBsn());
                            logger.info(wrappedArtifact.getReferenceHint());
                            if (logger.isDebugEnabled()) {
                                logger.debug("The following manifest was generated for this artifact:\r\n" + wrappedArtifact.getGeneratedManifest());
                            }
                            HashMap<String, String> mavenProperties = new HashMap<String, String>();
                            mavenProperties.put("maven-wrapped-groupId", mavenArtifact.getGroupId());
                            mavenProperties.put("maven-wrapped-artifactId", mavenArtifact.getArtifactId());
                            mavenProperties.put("maven-wrapped-version", mavenArtifact.getVersion());
                            mavenProperties.put("maven-wrapped-classifier", mavenArtifact.getClassifier());
                            unit = this.publish(description, file, (IPropertyAdvice)new MavenPropertiesAdvice(mavenProperties));
                            symbolicName = wrappedArtifact.getWrappedBsn();
                            bundleVersion = wrappedArtifact.getWrappedVersion();
                        }
                        catch (Exception e) {
                            throw new TargetDefinitionResolutionException("Artifact " + debugString + " of location " + String.valueOf(location) + " could not be wrapped as a bundle", (Throwable)e);
                        }
                    } else {
                        unit = this.publish(bundleDescription, bundleLocation, mavenArtifact);
                    }
                    bundles.add(unit);
                    if (logger.isDebugEnabled()) {
                        logger.debug("MavenResolver: artifact " + debugString + " at location " + String.valueOf(bundleLocation) + " resolves installable unit " + String.valueOf(new VersionedId(unit.getId(), unit.getVersion())));
                    }
                }
                catch (IOException | BundleException e) {
                    throw new TargetDefinitionResolutionException("Artifact " + debugString + " of location " + String.valueOf(location) + " could not be read", e);
                }
                if (!includeSource) continue;
                try {
                    Collection<?> sourceArtifacts = mavenDependenciesResolver.resolve(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getPackagingType(), "sources", null, 0, location.getRepositoryReferences());
                    Iterator sources = sourceArtifacts.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
                    while (sources.hasNext()) {
                        IArtifactFacade sourceArtifact = (IArtifactFacade)sources.next();
                        File sourceFile = sourceArtifact.getLocation();
                        try {
                            Manifest manifest;
                            try (JarFile jar = new JarFile(sourceFile);){
                                manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
                            }
                            IInstallableUnit unit = MavenBundleWrapper.isValidSourceManifest(manifest) ? this.publish(BundlesAction.createBundleDescription((File)sourceFile), sourceFile, sourceArtifact) : this.generateSourceBundle(symbolicName, bundleVersion, manifest, sourceFile, sourceArtifact);
                            sourceBundles.add(unit);
                            if (unit == null || !logger.isDebugEnabled()) continue;
                            logger.debug("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + String.valueOf(sourceFile) + " resolves installable unit " + String.valueOf(new VersionedId(unit.getId(), unit.getVersion())));
                        }
                        catch (IOException | BundleException e) {
                            logger.warn("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + String.valueOf(sourceFile) + " cannot be converted to a source bundle: " + String.valueOf(e));
                        }
                    }
                }
                catch (DependencyResolutionException e) {
                    logger.warn("MavenResolver: source-artifact " + debugString + ":sources cannot be resolved: " + String.valueOf(e));
                }
            }
            if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenDependency.getArtifactType()) && (pomFacade = Optional.ofNullable(resolve.root().getFile())).isPresent()) {
                try {
                    MavenModelFacade model = mavenDependenciesResolver.loadModel(pomFacade.get());
                    features.add(FeatureGenerator.generatePomFeature(model, bundles, false, logger));
                    if (includeSource) {
                        features.add(FeatureGenerator.generatePomFeature(model, sourceBundles, true, logger));
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    throw new TargetDefinitionResolutionException("non readable pom file");
                }
            }
            locationBundles.addAll(bundles);
            locationSourceBundles.addAll(sourceBundles);
        }
        Element featureTemplate = location.getFeatureTemplate();
        if (featureTemplate != null) {
            try {
                features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationBundles, false, logger));
                if (includeSource) {
                    features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationSourceBundles, true, logger));
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new TargetDefinitionResolutionException("feature generation failed!", (Throwable)e);
            }
        }
        FeaturePublisher.publishFeatures(features, this.repositoryContent::put, (IArtifactRepository)this.artifactRepository, logger);
    }

    private List<RemoteRepository> getRepos(MavenSession mavenSession) {
        MavenProject project = mavenSession.getCurrentProject();
        if (project != null) {
            return RepositoryUtils.toRepos((List)project.getRemoteArtifactRepositories());
        }
        Settings settings = mavenSession.getSettings();
        List activeProfiles = settings.getActiveProfiles();
        List<RemoteRepository> fromSetting = settings.getProfiles().stream().filter(p -> activeProfiles.contains(p.getId())).flatMap(p -> p.getRepositories().stream()).filter(r -> "default".equals(r.getLayout())).map(r -> new RemoteRepository.Builder(r.getId(), r.getLayout(), r.getUrl()).setReleasePolicy(this.toPolicy(r.getReleases())).setSnapshotPolicy(this.toPolicy(r.getSnapshots())).build()).toList();
        if (fromSetting.size() > 0) {
            return fromSetting;
        }
        return List.of(CENTRAL);
    }

    private RepositoryPolicy toPolicy(org.apache.maven.settings.RepositoryPolicy repositoryPolicy) {
        return new RepositoryPolicy(repositoryPolicy.isEnabled(), "always", "warn");
    }

    private ResolvedMavenArtifacts resolveRoot(MavenDependencyCollector collector, TargetDefinition.MavenDependency mavenDependency) throws RepositoryException {
        DependencyResult collect = collector.collect(new MavenRootDependency(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), mavenDependency.getClassifier(), mavenDependency.getArtifactType()));
        List<AetherArtifactFacade> list = collect.artifacts().stream().filter(a -> a.artifact().getFile() != null).map(a -> new AetherArtifactFacade(a.artifact(), a.repository())).toList();
        return new ResolvedMavenArtifacts(list, collect.root().getArtifact());
    }

    private DependencyDepth convert(TargetDefinition.MavenGAVLocation.DependencyDepth dependencyDepth) {
        switch (dependencyDepth) {
            case DIRECT: {
                return DependencyDepth.DIRECT;
            }
            case INFINITE: {
                return DependencyDepth.INFINITE;
            }
        }
        return DependencyDepth.NONE;
    }

    private IInstallableUnit generateSourceBundle(String symbolicName, String bundleVersion, Manifest manifest, File sourceFile, IArtifactFacade sourceArtifact) throws IOException, BundleException {
        File tempFile = File.createTempFile("tycho_wrapped_source", ".jar");
        tempFile.deleteOnExit();
        MavenBundleWrapper.addSourceBundleMetadata(manifest, symbolicName, bundleVersion);
        MavenBundleWrapper.transferJarEntries(sourceFile, manifest, tempFile);
        return this.publish(BundlesAction.createBundleDescription((File)tempFile), tempFile, sourceArtifact);
    }

    private IInstallableUnit publish(BundleDescription bundleDescription, File bundleLocation, IArtifactFacade mavenArtifact) {
        return this.publish(bundleDescription, bundleLocation, (IPropertyAdvice)new TychoMavenPropertiesAdvice(mavenArtifact, this.mavenContext));
    }

    private IInstallableUnit publish(BundleDescription bundleDescription, File bundleLocation, IPropertyAdvice advice) {
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(bundleLocation, key, (IArtifactRepository)this.artifactRepository);
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.addAdvice((IPublisherAdvice)advice);
        publisherInfo.addAdvice((IPublisherAdvice)new MavenChecksumAdvice(bundleLocation));
        publisherInfo.setArtifactOptions(1);
        IInstallableUnit iu = BundlePublisher.publishBundle(bundleDescription, descriptor, publisherInfo);
        this.repositoryContent.put(descriptor, iu);
        return iu;
    }

    private String asDebugString(IArtifactFacade mavenArtifact) {
        return new GAV(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion()).toString();
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    private static String getKey(Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            key = key + ":" + classifier;
        }
        key = key + ":" + artifact.getVersion();
        return key;
    }

    private record ResolvedMavenArtifacts(Collection<AetherArtifactFacade> facades, Artifact root) {
    }
}

