/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.artifacts.configuration.TargetPlatformFilterConfigurationReader;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.resolver.TargetPlatformConfigurationException;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolver;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetPlatformArtifactResolver;
import org.eclipse.tycho.targetplatform.TargetResolveException;
import org.osgi.framework.Filter;

@Component(role=DefaultTargetPlatformConfigurationReader.class)
public class DefaultTargetPlatformConfigurationReader {
    public static final String TARGET_DEFINITION_INCLUDE_SOURCE = "targetDefinitionIncludeSource";
    public static final String REFERENCED_REPOSITORY_MODE = "referencedRepositoryMode";
    public static final String DEPENDENCY_RESOLUTION = "dependency-resolution";
    public static final String OPTIONAL_DEPENDENCIES = "optionalDependencies";
    public static final String LOCAL_ARTIFACTS = "localArtifacts";
    public static final String LOCAL_ARTIFACTS_PROPERTY = "tycho.localArtifacts";
    public static final String FILTERS = "filters";
    public static final String RESOLVE_WITH_EXECUTION_ENVIRONMENT_CONSTRAINTS = "resolveWithExecutionEnvironmentConstraints";
    public static final String REQUIRE_EAGER_RESOLVE = "requireEagerResolve";
    public static final String PROPERTY_REQUIRE_EAGER_RESOLVE = "tycho.target.eager";
    public static final String PROPERTY_ALIAS_REQUIRE_EAGER_RESOLVE = "tycho.resolver.classic";
    public static final String BREE_HEADER_SELECTION_POLICY = "breeHeaderSelectionPolicy";
    public static final String EXECUTION_ENVIRONMENT_DEFAULT = "executionEnvironmentDefault";
    public static final String EXECUTION_ENVIRONMENT = "executionEnvironment";
    public static final String POM_DEPENDENCIES = "pomDependencies";
    public static final String PROPERTY_POM_DEPENDENCIES = "tycho.target.pomDependencies";
    public static final String TARGET = "target";
    public static final String RESOLVER = "resolver";
    public static final String ENVIRONMENTS = "environments";
    public static final String EXCLUSIONS = "exclusions";
    private static final String OPTIONAL_RESOLUTION_REQUIRE = "require";
    private static final String OPTIONAL_RESOLUTION_IGNORE = "ignore";
    private static final String OPTIONAL_RESOLUTION_OPTIONAL = "optional";
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private TargetPlatformFilterConfigurationReader filterReader;
    @Requirement
    private TargetPlatformArtifactResolver platformArtifactResolver;

    public TargetPlatformConfiguration getTargetPlatformConfiguration(MavenSession session, MavenProject project) throws TargetPlatformConfigurationException {
        TargetEnvironment env;
        Xpp3Dom configuration;
        TargetPlatformConfiguration result = new TargetPlatformConfiguration();
        this.setRequireEagerResolve(result, DefaultTargetPlatformConfigurationReader.getStringValue(null, session, PROPERTY_REQUIRE_EAGER_RESOLVE, PROPERTY_ALIAS_REQUIRE_EAGER_RESOLVE));
        this.setLocalArtifacts(result, DefaultTargetPlatformConfigurationReader.getStringValue(null, session, LOCAL_ARTIFACTS_PROPERTY, null));
        TychoProject tychoProject = this.projectManager.getTychoProject(project).orElse(null);
        Plugin plugin = project.getPlugin("org.eclipse.tycho:target-platform-configuration");
        if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("target-platform-configuration for " + project.toString() + ":\n" + configuration.toString());
            }
            this.addTargetEnvironments(result, project, configuration, tychoProject);
            this.setTargetPlatformResolver(result, configuration);
            this.setTarget(result, session, project, configuration);
            this.setPomDependencies(result, configuration, session);
            this.setDisableP2Mirrors(configuration);
            this.setExecutionEnvironment(result, configuration);
            this.setExecutionEnvironmentDefault(result, configuration);
            this.setBREEHeaderSelectionPolicy(result, configuration);
            this.setResolveWithEEContraints(result, configuration);
            this.setRequireEagerResolve(result, configuration, session);
            this.readFilters(result, configuration);
            try {
                this.readExclusions(result, configuration);
            }
            catch (TargetPlatformConfigurationException e) {
                throw new BuildFailureException("reading exclusions failed", (Throwable)((Object)e));
            }
            this.readDependencyResolutionConfiguration(result, configuration, session);
            this.setTargetDefinitionIncludeSources(result, configuration);
            this.setReferencedRepositoryMode(result, configuration);
        }
        for (Repository repository : project.getRepositories()) {
            if (!TARGET.equals(repository.getLayout())) continue;
            try {
                result.addTarget(new URI(TargetDefinitionResolver.convertRawToUri(repository.getUrl())));
            }
            catch (URISyntaxException e) {
                throw new TargetPlatformConfigurationException("reading <repository> target failed: " + String.valueOf(e), e);
            }
        }
        if (result.getEnvironments().isEmpty() && tychoProject != null && (env = tychoProject.getImplicitTargetEnvironment(project)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Implicit target environment for " + project.toString() + ": " + env.toString());
            }
            result.addEnvironment(env);
        }
        if (result.getEnvironments().isEmpty()) {
            result.addEnvironment(TargetEnvironment.getRunningEnvironment());
            result.setImplicitTargetEnvironment(true);
        } else {
            result.setImplicitTargetEnvironment(false);
        }
        return result;
    }

    private void setTargetDefinitionIncludeSources(TargetPlatformConfiguration result, Xpp3Dom configuration) throws BuildFailureException {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(TARGET_DEFINITION_INCLUDE_SOURCE));
        if (value == null) {
            return;
        }
        try {
            result.setTargetDefinitionIncludeSourceMode(IncludeSourceMode.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            throw new BuildFailureException("Illegal value of <targetDefinitionIncludeSource> target platform configuration parameter: " + value, (Throwable)e);
        }
    }

    private void setReferencedRepositoryMode(TargetPlatformConfiguration result, Xpp3Dom configuration) throws BuildFailureException {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(REFERENCED_REPOSITORY_MODE));
        if (value == null) {
            return;
        }
        try {
            result.setReferencedRepositoryMode(ReferencedRepositoryMode.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            throw new BuildFailureException("Illegal value of <referencedRepositoryMode> target platform configuration parameter: " + value, (Throwable)e);
        }
    }

    protected void readDependencyResolutionConfiguration(TargetPlatformConfiguration result, Xpp3Dom configuration, MavenSession mavenSession) {
        Xpp3Dom resolverDom = configuration.getChild(DEPENDENCY_RESOLUTION);
        if (resolverDom == null) {
            resolverDom = new Xpp3Dom(DEPENDENCY_RESOLUTION);
        }
        this.setOptionalDependencies(result, resolverDom);
        this.setLocalArtifacts(result, resolverDom, mavenSession);
        this.readExtraRequirements(result, resolverDom);
        this.readProfileProperties(result, resolverDom);
    }

    private void setLocalArtifacts(TargetPlatformConfiguration result, Xpp3Dom resolverDom, MavenSession mavenSession) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(resolverDom.getChild(LOCAL_ARTIFACTS), mavenSession, LOCAL_ARTIFACTS_PROPERTY, null);
        this.setLocalArtifacts(result, value);
    }

    private void setLocalArtifacts(TargetPlatformConfiguration result, String value) {
        if (value == null) {
            return;
        }
        if ("default".equalsIgnoreCase(value)) {
            result.setLocalArtifactHandling(TargetPlatformConfiguration.LocalArtifactHandling.include);
            return;
        }
        try {
            result.setLocalArtifactHandling(TargetPlatformConfiguration.LocalArtifactHandling.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            throw new BuildFailureException("Invalid value for localArtifacts setting, given = " + value + ", allowed = " + Arrays.toString((Object[])TargetPlatformConfiguration.LocalArtifactHandling.values()));
        }
    }

    private void setOptionalDependencies(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(resolverDom.getChild(OPTIONAL_DEPENDENCIES));
        if (value == null) {
            return;
        }
        if (OPTIONAL_RESOLUTION_REQUIRE.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.REQUIRE);
        } else if (OPTIONAL_RESOLUTION_IGNORE.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.IGNORE);
        } else if (OPTIONAL_RESOLUTION_OPTIONAL.equals(value)) {
            result.setOptionalResolutionAction(OptionalResolutionAction.OPTIONAL);
        } else {
            throw new BuildFailureException("Illegal value of <optionalDependencies> dependency resolution parameter: " + value);
        }
    }

    protected void readExtraRequirements(TargetPlatformConfiguration result, Xpp3Dom resolverDom) throws BuildFailureException {
        Xpp3Dom requirementsDom = resolverDom.getChild("extraRequirements");
        if (requirementsDom == null) {
            return;
        }
        Xpp3Dom[] xpp3DomArray = requirementsDom.getChildren("requirement");
        int n = xpp3DomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom requirementDom = xpp3DomArray[n2];
            if (requirementDom.getChild("type") == null) {
                throw new BuildFailureException("Element <type> is missing in <extraRequirements><requirement> section.");
            }
            if (requirementDom.getChild("id") == null) {
                throw new BuildFailureException("Element <id> is missing in <extraRequirements><requirement> section.");
            }
            if (requirementDom.getChild("versionRange") == null) {
                throw new BuildFailureException("Element <versionRange> is missing in <extraRequirements><requirement> section.");
            }
            result.addExtraRequirement((ArtifactKey)new DefaultArtifactKey(requirementDom.getChild("type").getValue(), requirementDom.getChild("id").getValue(), requirementDom.getChild("versionRange").getValue()));
            ++n2;
        }
    }

    private void readProfileProperties(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        Xpp3Dom[] propertyDomList;
        Xpp3Dom propertiesDom = resolverDom.getChild("profileProperties");
        if (propertiesDom == null) {
            return;
        }
        Xpp3Dom[] xpp3DomArray = propertyDomList = propertiesDom.getChildren();
        int n = propertyDomList.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom propertyDom = xpp3DomArray[n2];
            result.addProfileProperty(propertyDom.getName(), propertyDom.getValue().trim());
            ++n2;
        }
    }

    private void setExecutionEnvironment(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(EXECUTION_ENVIRONMENT));
        if (value == null) {
            return;
        }
        result.setExecutionEnvironment(value);
    }

    private void setExecutionEnvironmentDefault(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(EXECUTION_ENVIRONMENT_DEFAULT));
        if (value == null) {
            return;
        }
        result.setExecutionEnvironmentDefault(value);
    }

    private void setBREEHeaderSelectionPolicy(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(BREE_HEADER_SELECTION_POLICY));
        if (value == null) {
            return;
        }
        try {
            result.setBREEHeaderSelectionPolicy(TargetPlatformConfiguration.BREEHeaderSelectionPolicy.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illegal value of <breeHeaderSelectionPolicy> target platform parameter: " + value);
        }
    }

    private void setResolveWithEEContraints(TargetPlatformConfiguration result, Xpp3Dom resolverDom) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(resolverDom.getChild(RESOLVE_WITH_EXECUTION_ENVIRONMENT_CONSTRAINTS));
        if (value == null) {
            return;
        }
        result.setResolveWithEEContraints(Boolean.valueOf(value));
    }

    private void setRequireEagerResolve(TargetPlatformConfiguration result, Xpp3Dom resolverDom, MavenSession session) {
        Xpp3Dom child = resolverDom.getChild(REQUIRE_EAGER_RESOLVE);
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(child, session, PROPERTY_REQUIRE_EAGER_RESOLVE, PROPERTY_ALIAS_REQUIRE_EAGER_RESOLVE);
        this.setRequireEagerResolve(result, value);
    }

    private void setRequireEagerResolve(TargetPlatformConfiguration result, String value) {
        if (value == null) {
            return;
        }
        result.setRequireEagerResolve(Boolean.valueOf(value));
    }

    private void setDisableP2Mirrors(Xpp3Dom configuration) {
        Xpp3Dom disableP2mirrorsDom = configuration.getChild("disableP2Mirrors");
        if (disableP2mirrorsDom != null) {
            this.logger.warn("Unsupported target-platform-configuration <disableP2Mirrors>. Use tycho.disableP2Mirrors -D command line parameter or settings.xml property.");
        }
    }

    private void addTargetEnvironments(TargetPlatformConfiguration result, MavenProject project, Xpp3Dom configuration, TychoProject tychoProject) {
        try {
            Xpp3Dom environmentsDom = configuration.getChild(ENVIRONMENTS);
            if (environmentsDom != null) {
                Filter filter = DefaultTargetPlatformConfigurationReader.getTargetEnvironmentFilter(tychoProject, project);
                Xpp3Dom[] xpp3DomArray = environmentsDom.getChildren("environment");
                int n = xpp3DomArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Xpp3Dom environmentDom = xpp3DomArray[n2];
                    TargetEnvironment environment = DefaultTargetPlatformConfigurationReader.newTargetEnvironment(environmentDom);
                    if (environment.match(filter)) {
                        result.addEnvironment(environment);
                    } else {
                        result.addFilteredEnvironment(environment);
                    }
                    ++n2;
                }
                List<TargetEnvironment> filteredEnvironments = result.getFilteredEnvironments();
                if (!filteredEnvironments.isEmpty()) {
                    this.logger.debug(MessageFormat.format("Declared TargetEnvironment(s) {0} are skipped for {1} as they do not match the project filter {2}.", filteredEnvironments.stream().map(TargetEnvironment::toFilterProperties).map(String::valueOf).collect(Collectors.joining(", ")), project.getId(), filter));
                }
            }
        }
        catch (TargetPlatformConfigurationException e) {
            throw new RuntimeException("target-platform-configuration error in project " + project.getId(), (Throwable)((Object)e));
        }
    }

    private static Filter getTargetEnvironmentFilter(TychoProject tychoProject, MavenProject project) {
        if (tychoProject != null) {
            return tychoProject.getTargetEnvironmentFilter(project);
        }
        return null;
    }

    private void setPomDependencies(TargetPlatformConfiguration result, Xpp3Dom configuration, MavenSession session) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(POM_DEPENDENCIES), session, PROPERTY_POM_DEPENDENCIES, null);
        if (value == null) {
            return;
        }
        result.setPomDependencies(PomDependencies.valueOf(value));
    }

    private void setTarget(TargetPlatformConfiguration result, MavenSession session, MavenProject project, Xpp3Dom configuration) throws TargetPlatformConfigurationException {
        Xpp3Dom[] locationsArray;
        Xpp3Dom[] uriDomArray;
        int n;
        Xpp3Dom[] xpp3DomArray;
        Xpp3Dom[] fileDomArray;
        Xpp3Dom targetDom = configuration.getChild(TARGET);
        if (targetDom == null) {
            return;
        }
        Xpp3Dom[] artifactDomArray = targetDom.getChildren("artifact");
        if (artifactDomArray != null && artifactDomArray.length > 0) {
            Xpp3Dom[] xpp3DomArray2 = artifactDomArray;
            int n2 = artifactDomArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Xpp3Dom artifactDom = xpp3DomArray2[n3];
                this.addTargetArtifact(result, session, project, artifactDom);
                ++n3;
            }
        }
        if ((fileDomArray = targetDom.getChildren("file")) != null && fileDomArray.length > 0) {
            Path basedir = Paths.get(project.getBasedir().getAbsolutePath(), new String[0]);
            xpp3DomArray = fileDomArray;
            n = fileDomArray.length;
            int n4 = 0;
            while (n4 < n) {
                Xpp3Dom fileDom = xpp3DomArray[n4];
                String file = fileDom.getValue();
                File target = basedir.resolve(file).toFile();
                if (TargetDefinitionFile.isTargetFile((File)target)) {
                    result.addTarget(target);
                } else {
                    result.addLazyTargetFile(() -> {
                        if (TargetDefinitionFile.isTargetFile((File)target)) {
                            return target;
                        }
                        throw new TargetPlatformConfigurationException("target definition file '" + target.getAbsolutePath() + "' not found for project '" + project.getName() + "'.");
                    });
                }
                ++n4;
            }
        }
        if ((uriDomArray = targetDom.getChildren("uri")) != null && uriDomArray.length > 0) {
            xpp3DomArray = uriDomArray;
            n = uriDomArray.length;
            int n5 = 0;
            while (n5 < n) {
                Xpp3Dom uriDom = xpp3DomArray[n5];
                String uri = uriDom.getValue();
                try {
                    result.addTarget(new URI(TargetDefinitionResolver.convertRawToUri(uri)));
                }
                catch (URISyntaxException e) {
                    throw new TargetPlatformConfigurationException("target definition uri '" + uri + "' can not be parsed for project '" + project.getName() + "'.");
                }
                ++n5;
            }
        }
        if ((locationsArray = targetDom.getChildren("location")) != null && locationsArray.length > 0) {
            Xpp3Dom[] xpp3DomArray3 = locationsArray;
            int n6 = locationsArray.length;
            n = 0;
            while (n < n6) {
                Xpp3Dom locationDom = xpp3DomArray3[n];
                result.addTargetLocation(locationDom);
                ++n;
            }
        }
    }

    protected void addTargetArtifact(TargetPlatformConfiguration result, MavenSession session, MavenProject project, Xpp3Dom artifactDom) throws TargetPlatformConfigurationException {
        Xpp3Dom groupIdDom = artifactDom.getChild("groupId");
        Xpp3Dom artifactIdDom = artifactDom.getChild("artifactId");
        Xpp3Dom versionDom = artifactDom.getChild("version");
        if (groupIdDom == null || artifactIdDom == null || versionDom == null) {
            throw new TargetPlatformConfigurationException("The target artifact configuration is invalid - <groupId>, <artifactId> and <version> are mandatory");
        }
        Xpp3Dom classifierDom = artifactDom.getChild("classifier");
        String groupId = groupIdDom.getValue();
        String artifactId = artifactIdDom.getValue();
        String version = versionDom.getValue();
        String classifier = classifierDom != null ? classifierDom.getValue() : null;
        result.addLazyTargetFile(() -> {
            try {
                return this.platformArtifactResolver.resolveTargetFile(groupId, artifactId, version, classifier, session, project.getRemoteArtifactRepositories());
            }
            catch (TargetResolveException e) {
                throw new TargetPlatformConfigurationException("resolve target artifact " + groupId + ":" + artifactId + ":" + version + ":" + Objects.requireNonNullElse(classifier, "no classifier") + " failed!", e);
            }
        });
    }

    private void setTargetPlatformResolver(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        String value = DefaultTargetPlatformConfigurationReader.getStringValue(configuration.getChild(RESOLVER));
        if (value == null) {
            return;
        }
        result.setResolver(value);
    }

    private void readFilters(TargetPlatformConfiguration result, Xpp3Dom configuration) {
        Xpp3Dom filtersDom = configuration.getChild(FILTERS);
        if (filtersDom != null) {
            result.setFilters(this.filterReader.parseFilterConfiguration(filtersDom));
        }
    }

    private void readExclusions(TargetPlatformConfiguration result, Xpp3Dom configuration) throws TargetPlatformConfigurationException {
        Xpp3Dom exclusionsDom = configuration.getChild(EXCLUSIONS);
        if (exclusionsDom != null) {
            Xpp3Dom[] children;
            Xpp3Dom[] xpp3DomArray = children = exclusionsDom.getChildren("exclusion");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom exclusion = xpp3DomArray[n2];
                Xpp3Dom groupId = exclusion.getChild("groupId");
                if (groupId == null) {
                    throw new TargetPlatformConfigurationException("<groupId> element is missing within target-platform-configuration (element <exclusion>)");
                }
                Xpp3Dom artifactId = exclusion.getChild("artifactId");
                if (artifactId == null) {
                    throw new TargetPlatformConfigurationException("<artifactId> element is missing within target-platform-configuration (element <exclusion>)");
                }
                result.addExclusion(groupId.getValue(), artifactId.getValue());
                ++n2;
            }
        }
    }

    private static TargetEnvironment newTargetEnvironment(Xpp3Dom environmentDom) throws TargetPlatformConfigurationException {
        Xpp3Dom osDom = environmentDom.getChild("os");
        if (osDom == null) {
            String message = "<os> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        Xpp3Dom wsDom = environmentDom.getChild("ws");
        if (wsDom == null) {
            String message = "<ws> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        Xpp3Dom archDom = environmentDom.getChild("arch");
        if (archDom == null) {
            String message = "<arch> element is missing within target-platform-configuration (element <environment>)";
            throw new TargetPlatformConfigurationException(message);
        }
        return new TargetEnvironment(osDom.getValue(), wsDom.getValue(), archDom.getValue());
    }

    private static String getStringValue(Xpp3Dom element, MavenSession session, String property, String alias) {
        if (session != null) {
            Properties userProperties = session.getUserProperties();
            String userProperty = userProperties.getProperty(property);
            if (userProperty != null) {
                return userProperty;
            }
            if (alias != null && (userProperty = userProperties.getProperty(alias)) != null) {
                return userProperty;
            }
        }
        return DefaultTargetPlatformConfigurationReader.getStringValue(element);
    }

    private static String getStringValue(Xpp3Dom element) {
        if (element == null) {
            return null;
        }
        String value = element.getValue().trim();
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    public static boolean isPrimaryTarget(MavenProject project, File targetFile, File[] otherTargetFiles) {
        String baseName;
        if (otherTargetFiles != null && otherTargetFiles.length == 1) {
            return TargetDefinitionFile.isTargetFile((File)otherTargetFiles[0]);
        }
        String name = targetFile.getName();
        return name.toLowerCase().endsWith(".target") && (baseName = FilenameUtils.getBaseName((String)name)).equalsIgnoreCase(project.getArtifactId());
    }

    public static void throwNoPrimaryTargetFound(MavenProject project, File[] targetFiles) throws MojoExecutionException {
        if (targetFiles == null || targetFiles.length == 0) {
            throw new MojoExecutionException("No target definition file(s) found in project '" + project.getName() + "'.");
        }
        throw new MojoExecutionException("One target file must be named  '" + project.getArtifactId() + ".target' when multiple targets are present");
    }
}

