/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.targetplatform.P2TargetPlatform;

@Component(role=TychoProject.class, hint="eclipse-target-definition")
public class TargetPlatformProject
extends AbstractTychoProject {
    @Override
    public ArtifactDependencyWalker getDependencyWalker(ReactorProject project) {
        return new ArtifactDependencyWalker(this){

            @Override
            public void walk(ArtifactDependencyVisitor visitor) {
            }

            @Override
            public void traverseFeature(File location, Feature feature, ArtifactDependencyVisitor visitor) {
            }
        };
    }

    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        String version = project.getVersion();
        version = version.replace("-SNAPSHOT", ".qualifier");
        return new DefaultArtifactKey("target", project.getArtifactId(), version);
    }

    @Override
    public DependencyArtifacts getDependencyArtifacts(ReactorProject reactorProject) {
        return (DependencyArtifacts)reactorProject.computeContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS, () -> {
            MavenProject mavenProject;
            DefaultDependencyArtifacts artifacts = new DefaultDependencyArtifacts(reactorProject);
            MavenSession mavenSession = this.getMavenSession(reactorProject);
            TargetPlatform targetPlatform = this.dependencyResolver.getPreliminaryTargetPlatform(mavenSession, mavenProject = TargetPlatformProject.getMavenProject(reactorProject));
            if (targetPlatform instanceof P2TargetPlatform) {
                P2TargetPlatform p2 = (P2TargetPlatform)targetPlatform;
                Set installableUnits = p2.getInstallableUnits();
                for (IInstallableUnit iu : installableUnits) {
                    for (IArtifactKey key : iu.getArtifacts()) {
                        ArtifactKey artifactKey = ArtifactTypeHelper.toTychoArtifactKey(iu, key);
                        String classifier = ArtifactTypeHelper.toMavenClassifier(iu);
                        artifacts.addArtifactFile(artifactKey, classifier, () -> targetPlatform.getArtifactLocation(artifactKey), List.of(iu));
                    }
                }
            }
            return artifacts;
        });
    }
}

