/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCollisionHook;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.internal.framework.AliasMapper;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironment;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.DependenciesInfo;
import org.eclipse.tycho.core.osgitools.DependenciesResolver;
import org.eclipse.tycho.core.osgitools.DependencyComputer;
import org.eclipse.tycho.core.osgitools.EquinoxResolverConfiguration;
import org.eclipse.tycho.core.osgitools.ModuleArtifactDescriptor;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

@Component(role=DependenciesResolver.class, hint="equinox")
public class EquinoxResolver
implements DependenciesResolver {
    public static final String HINT = "equinox";
    private static final String FORCE_KEEP_USES = "First attempt at resolving bundle failed. Trying harder by keeping `uses` information... This may drastically slow down your build!";
    @Requirement
    private BundleReader manifestReader;
    @Requirement
    private Logger logger;
    @Requirement
    private ToolchainManager toolchainManager;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    TychoProjectManager projectManager;
    @Requirement
    private DependencyComputer dependencyComputer;
    private static final AliasMapper ALIAS_MAPPER = new AliasMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContainer newResolvedState(ReactorProject project, MavenSession mavenSession, ExecutionEnvironment ee, DependencyArtifacts artifacts, Map<Module, ArtifactDescriptor> descriptorLookup) throws BundleException {
        Objects.requireNonNull(artifacts, "DependencyArtifacts can't be null!");
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(EquinoxResolverConfiguration.THREAD_COUNT);
        try {
            ModuleContainer moduleContainer = this.newResolvedState(project, mavenSession, ee, artifacts, executorService, new EquinoxResolverConfiguration(), descriptorLookup);
            return moduleContainer;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private ModuleContainer newResolvedState(ReactorProject project, MavenSession mavenSession, ExecutionEnvironment ee, DependencyArtifacts artifacts, ScheduledExecutorService executorService, EquinoxResolverConfiguration config, Map<Module, ArtifactDescriptor> descriptorLookup) throws BundleException {
        Set unresolvedModules;
        Properties properties = this.getPlatformProperties(project, mavenSession, ee);
        ModuleContainer container = this.newState(artifacts, properties, mavenSession, executorService, config, descriptorLookup);
        ResolutionReport report = container.resolve(null, false);
        Module module = container.getModule(EquinoxResolver.getNormalizedPath(project.getBasedir()));
        if (module == null) {
            Module systemModule = container.getModule("System Bundle");
            if (project.getBasedir().equals(systemModule.getCurrentRevision().getRevisionInfo())) {
                module = systemModule;
            }
        }
        ModuleRevision moduleRevision = module.getCurrentRevision();
        if (report.getEntries().isEmpty()) {
            Collection toUninstall = null;
            toUninstall = (moduleRevision.getTypes() & 1) != 0 ? (Collection)moduleRevision.getWiring().getRequiredModuleWires("osgi.wiring.host").stream().map(ModuleWire::getProvider).flatMap(host -> host.getWiring().getProvidedModuleWires("osgi.wiring.host").stream()).map(ModuleWire::getRequirer).filter(Predicate.not(moduleRevision::equals)).filter(fragment -> (fragment.getTypes() & 1) != 0).map(revision -> revision.getRevisions().getModule()).collect(Collectors.toSet()) : (Collection)moduleRevision.getWiring().getProvidedModuleWires("osgi.wiring.host").stream().map(ModuleWire::getRequirer).filter(fragment -> (fragment.getTypes() & 1) != 0).map(revision -> revision.getRevisions().getModule()).collect(Collectors.toSet());
            if (!toUninstall.isEmpty()) {
                for (Module uninstall : toUninstall) {
                    try {
                        container.uninstall(uninstall);
                    }
                    catch (BundleException bundleException) {}
                }
                report = container.refresh(null);
            }
        }
        if (this.logger.isDebugEnabled() && !(unresolvedModules = container.getModules().stream().filter(m -> m.getState() != Module.State.RESOLVED).collect(Collectors.toSet())).isEmpty()) {
            this.logger.warn("OSGi state has " + unresolvedModules.size() + " unresolved module(s):");
            this.logger.debug("The following modules are used to build the current state:");
            for (Module m2 : container.getModules()) {
                Module.State state = m2.getState();
                ModuleRevision revision2 = m2.getCurrentRevision();
                boolean unresolved = unresolvedModules.contains(m2);
                String message = "| " + String.valueOf(state) + " | " + revision2.getSymbolicName() + " (" + String.valueOf(revision2.getVersion()) + ") @ " + m2.getLocation();
                if (unresolved) {
                    this.logger.warn(message);
                    String reportMessage = report.getResolutionReportMessage((Resource)revision2);
                    String[] lines = reportMessage.split("\r?\n");
                    for (int i = 1; i < lines.length; ++i) {
                        this.logger.warn("            " + lines[i]);
                    }
                    continue;
                }
                this.logger.debug("   " + message);
            }
        }
        if (moduleRevision.getRevisions().getModule().getState() == Module.State.RESOLVED || report == null || report.getEntries() == null || report.getEntries().isEmpty()) {
            return container;
        }
        List errors = (List)report.getEntries().get(moduleRevision);
        if (errors == null || errors.isEmpty()) {
            return container;
        }
        if (!config.keepUses) {
            this.logger.info(FORCE_KEEP_USES);
            return this.newResolvedState(project, mavenSession, ee, artifacts, executorService, new EquinoxResolverConfiguration(config, true), descriptorLookup);
        }
        throw new BundleException("Bundle " + moduleRevision.getSymbolicName() + " cannot be resolved:" + report.getResolutionReportMessage((Resource)moduleRevision));
    }

    protected Properties getPlatformProperties(ReactorProject project, MavenSession mavenSession, ExecutionEnvironment ee) {
        TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(project);
        TargetEnvironment environment = configuration.getEnvironments().get(0);
        this.logger.debug("Using TargetEnvironment " + environment.toFilterExpression() + " to create resolver properties");
        Properties properties = EquinoxResolver.computeMergedProperties((MavenProject)project.adapt(MavenProject.class), mavenSession);
        return this.getPlatformProperties(properties, mavenSession, environment, ee);
    }

    protected Properties getPlatformProperties(Properties properties, MavenSession mavenSession, TargetEnvironment environment, ExecutionEnvironment ee) {
        if (environment != null) {
            properties.put("osgi.os", environment.getOs());
            properties.put("osgi.ws", environment.getWs());
            properties.put("osgi.arch", environment.getArch());
        }
        if (ee != null) {
            ExecutionEnvironmentUtils.applyProfileProperties(properties, ee);
        } else {
            StringJoiner allSystemPackages = new StringJoiner(",");
            StringJoiner allSystemCapabilities = new StringJoiner(",");
            for (String profile : ExecutionEnvironmentUtils.getProfileNames(this.toolchainManager, mavenSession, this.logger)) {
                String currentSystemCapabilities;
                StandardExecutionEnvironment executionEnvironment = ExecutionEnvironmentUtils.getExecutionEnvironment(profile, this.toolchainManager, mavenSession, this.logger);
                String currentSystemPackages = (String)executionEnvironment.getProfileProperties().get("org.osgi.framework.system.packages");
                if (currentSystemPackages != null && !currentSystemPackages.isEmpty()) {
                    allSystemPackages.add(currentSystemPackages);
                }
                if ((currentSystemCapabilities = (String)executionEnvironment.getProfileProperties().get("org.osgi.framework.system.capabilities")) == null || currentSystemCapabilities.isEmpty()) continue;
                allSystemCapabilities.add(currentSystemCapabilities);
            }
            properties.put("org.osgi.framework.system.packages", allSystemPackages.toString());
            properties.put("org.osgi.framework.system.capabilities", allSystemCapabilities.toString());
        }
        return properties;
    }

    protected ModuleContainer newState(DependencyArtifacts artifacts, Properties properties, MavenSession mavenSession, final ScheduledExecutorService executorService, final EquinoxResolverConfiguration config, Map<Module, ArtifactDescriptor> descriptorLookup) throws BundleException {
        File systemBundleInfo;
        Map<String, String> systemBundleManifest;
        ModuleContainer moduleContainer;
        final ModuleContainer[] moduleContainerAccessor = new ModuleContainer[1];
        ModuleContainerAdaptor moduleContainerAdaptor = new ModuleContainerAdaptor(this){

            public String getProperty(String key) {
                return switch (key) {
                    case "equinox.resolver.revision.batch.size" -> config.batchSize;
                    case "equinox.resolver.batch.timeout" -> EquinoxResolverConfiguration.BATCH_TIMEOUT;
                    default -> super.getProperty(key);
                };
            }

            public void publishModuleEvent(ModuleContainerAdaptor.ModuleEvent type, Module module, Module origin) {
            }

            public void publishContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
            }

            public ResolverHookFactory getResolverHookFactory() {
                return triggers -> new ResolverHook(this){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }

            public ModuleCollisionHook getModuleCollisionHook() {
                return (operationType, target, collisionCandidates) -> {};
            }

            public SystemModule createSystemModule() {
                return new SystemModule(this, moduleContainerAccessor[0]){

                    public Bundle getBundle() {
                        return null;
                    }

                    protected void cleanup(ModuleRevision revision) {
                    }
                };
            }

            public Module createModule(String location, long id, EnumSet<Module.Settings> settings, int startlevel) {
                return new Module(this, id, location, moduleContainerAccessor[0], settings, startlevel){

                    public Bundle getBundle() {
                        return null;
                    }

                    protected void cleanup(ModuleRevision revision) {
                    }
                };
            }

            public ScheduledExecutorService getScheduledExecutor() {
                return executorService;
            }
        };
        ModuleDatabase moduleDatabase = new ModuleDatabase(moduleContainerAdaptor);
        moduleContainerAccessor[0] = moduleContainer = new ModuleContainer(moduleContainerAdaptor, moduleDatabase);
        LinkedHashMap<File, OsgiManifest> systemBundles = new LinkedHashMap<File, OsgiManifest>();
        LinkedHashMap<File, OsgiManifest> externalBundles = new LinkedHashMap<File, OsgiManifest>();
        LinkedHashMap<File, OsgiManifest> projects = new LinkedHashMap<File, OsgiManifest>();
        LinkedHashMap<File, ArtifactDescriptor> descriptors = new LinkedHashMap<File, ArtifactDescriptor>();
        List list = artifacts.getArtifacts("eclipse-plugin");
        for (ArtifactDescriptor artifact : list) {
            File location = artifact.getLocation(true);
            OsgiManifest mf = this.loadManifest(location, artifact);
            descriptors.put(location, artifact);
            if (this.isFrameworkImplementation(mf)) {
                systemBundles.put(location, mf);
                continue;
            }
            ReactorProject mavenProject = artifact.getMavenProject();
            if (mavenProject != null) {
                Collection additionalBundles = this.buildPropertiesParser.parse(mavenProject).getAdditionalBundles();
                if (!additionalBundles.isEmpty()) {
                    ArrayList<String> reqb = new ArrayList<String>();
                    String value = mf.getValue("Require-Bundle");
                    if (value != null) {
                        reqb.add(value);
                    }
                    reqb.addAll(additionalBundles.stream().map(b -> b + ";resolution:=optional").toList());
                    mf.getHeaders().put("Require-Bundle", String.join((CharSequence)",", reqb));
                }
                projects.put(location, mf);
                continue;
            }
            externalBundles.put(location, mf);
        }
        String systemExtraCapabilities = EquinoxResolver.getSystemExtraCapabilities(properties);
        if (!systemBundles.isEmpty()) {
            Map.Entry systemBundle = systemBundles.entrySet().iterator().next();
            systemBundleManifest = ((OsgiManifest)systemBundle.getValue()).getHeaders();
            systemBundleInfo = (File)systemBundle.getKey();
        } else {
            systemBundleManifest = Map.of("Bundle-SymbolicName", "system.bundle");
            systemBundleInfo = null;
        }
        ModuleRevisionBuilder systemBundleRevisionBuilder = OSGiManifestBuilderFactory.createBuilder(systemBundleManifest, (String)"system.bundle", (String)properties.getProperty("org.osgi.framework.system.packages"), (String)systemExtraCapabilities);
        EquinoxResolver.install(moduleContainer, null, "System Bundle", systemBundleRevisionBuilder, systemBundleInfo, config, descriptorLookup, descriptors);
        for (Map.Entry external : externalBundles.entrySet()) {
            EquinoxResolver.install(moduleContainer, null, ((File)external.getKey()).getAbsolutePath(), OSGiManifestBuilderFactory.createBuilder(((OsgiManifest)external.getValue()).getHeaders()), (File)external.getKey(), config, descriptorLookup, descriptors);
        }
        for (Map.Entry entry : projects.entrySet()) {
            Map<String, String> headers = ((OsgiManifest)entry.getValue()).getHeaders();
            ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(headers);
            EquinoxResolver.install(moduleContainer, null, ((File)entry.getKey()).getAbsolutePath(), builder, (File)entry.getKey(), config, descriptorLookup, descriptors);
        }
        return moduleContainer;
    }

    private static Module install(ModuleContainer moduleContainer, Module origin, String location, ModuleRevisionBuilder builder, File revisionInfo, EquinoxResolverConfiguration configuration, Map<Module, ArtifactDescriptor> descriptorLookup, Map<File, ArtifactDescriptor> descriptors) throws BundleException {
        if (!configuration.keepUses) {
            List capabilities = builder.getCapabilities();
            for (ModuleRevisionBuilder.GenericInfo genericInfo : capabilities) {
                genericInfo.getDirectives().remove("uses");
            }
        }
        Module module = moduleContainer.install(origin, location, builder, (Object)revisionInfo);
        ArtifactDescriptor descriptor = descriptors.get(revisionInfo);
        if (descriptor != null) {
            descriptorLookup.put(module, descriptor);
        }
        return module;
    }

    private boolean isFrameworkImplementation(OsgiManifest mf) {
        String value = mf.getHeaders().get("Export-Package");
        if (value != null) {
            try {
                ManifestElement[] exports;
                for (ManifestElement export : exports = ManifestElement.parseHeader((String)"Export-Package", (String)value)) {
                    if (!"org.osgi.framework".equals(export.getValue())) continue;
                    return true;
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getNormalizedPath(File file) {
        return file.getAbsolutePath();
    }

    private static String getSystemExtraCapabilities(Properties equinoxConfig) {
        StringBuilder result = new StringBuilder();
        String systemCapabilities = equinoxConfig.getProperty("org.osgi.framework.system.capabilities");
        if (systemCapabilities != null && systemCapabilities.trim().length() > 0) {
            result.append(systemCapabilities).append(", ");
        }
        String os = equinoxConfig.getProperty("osgi.os");
        String ws = equinoxConfig.getProperty("osgi.ws");
        String osArch = equinoxConfig.getProperty("osgi.arch");
        String nl = equinoxConfig.getProperty("osgi.nl");
        result.append("eclipse.platform").append("; ");
        result.append("osgi.os").append("=").append(os).append("; ");
        result.append("osgi.ws").append("=").append(ws).append("; ");
        result.append("osgi.arch").append("=").append(osArch).append("; ");
        result.append("osgi.nl").append("=").append(nl);
        String osName = os == null ? null : ALIAS_MAPPER.getCanonicalOSName(os);
        String processor = osArch == null ? null : ALIAS_MAPPER.getCanonicalProcessor(osArch);
        result.append(", ").append("osgi.native");
        if (osName != null) {
            String osNames = EquinoxResolver.getStringList(ALIAS_MAPPER.getOSNameAliases(osName));
            result.append("; ").append("osgi.native.osname").append(osNames);
        }
        if (processor != null) {
            String processors = EquinoxResolver.getStringList(ALIAS_MAPPER.getProcessorAliases(processor));
            result.append("; ").append("osgi.native.processor").append(processors);
        }
        return result.toString();
    }

    private static String getStringList(Collection<String> elements) {
        return ":List<String>=\"" + String.join((CharSequence)",", elements) + "\"";
    }

    private OsgiManifest loadManifest(File bundleLocation, ArtifactDescriptor artifact) {
        if (bundleLocation == null) {
            throw new IllegalArgumentException("bundleLocation can't be null for artifact " + String.valueOf(artifact));
        }
        if (!this.checkExits(bundleLocation)) {
            throw new IllegalArgumentException("bundleLocation not found: " + String.valueOf(bundleLocation) + " for artifact " + String.valueOf(artifact));
        }
        return this.manifestReader.loadManifest(bundleLocation);
    }

    private boolean checkExits(File bundleLocation) {
        if (bundleLocation.exists()) {
            return true;
        }
        long deadLine = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        while (System.currentTimeMillis() < deadLine) {
            if (bundleLocation.exists()) {
                return true;
            }
            Thread.onSpinWait();
        }
        return bundleLocation.exists();
    }

    private ModuleContainer getResolverState(ReactorProject project, MavenProject mavenProject, DependencyArtifacts artifacts, MavenSession session, Map<Module, ArtifactDescriptor> descriptorLookup) {
        try {
            ExecutionEnvironmentConfiguration eeConfiguration = this.projectManager.getExecutionEnvironmentConfiguration(mavenProject);
            ExecutionEnvironment executionEnvironment = eeConfiguration.getFullSpecification();
            return this.newResolvedState(project, session, eeConfiguration.isIgnoredByResolver() ? null : executionEnvironment, artifacts, descriptorLookup);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DependenciesInfo computeDependencies(MavenProject project, DependencyArtifacts artifacts, MavenSession session) {
        HashMap<Module, ArtifactDescriptor> descriptorLookup = new HashMap<Module, ArtifactDescriptor>();
        final ModuleContainer state = this.getResolverState(DefaultReactorProject.adapt(project), project, artifacts, session, descriptorLookup);
        Module module = state.getModule(project.getBasedir().getAbsolutePath());
        if (module == null) {
            Module systemModule = state.getModule("System Bundle");
            if (project.getBasedir().equals(systemModule.getCurrentRevision().getRevisionInfo())) {
                module = systemModule;
            }
        }
        final ModuleRevision bundleDescription = module.getCurrentRevision();
        final List<DependencyComputer.DependencyEntry> dependencies = this.dependencyComputer.computeDependencies(bundleDescription, revision -> {
            if (revision instanceof ModuleRevision) {
                ModuleRevision mr = (ModuleRevision)revision;
                Module key = mr.getRevisions().getModule();
                ArtifactDescriptor descriptor = (ArtifactDescriptor)descriptorLookup.get(key);
                if (descriptor == null) {
                    return new ModuleArtifactDescriptor(key);
                }
                return descriptor;
            }
            throw new IllegalArgumentException("Not a valid bundle revision: " + String.valueOf(revision));
        });
        return new DependenciesInfo(){

            @Override
            public BundleRevision getRevision() {
                return bundleDescription;
            }

            @Override
            public List<DependencyComputer.DependencyEntry> getDependencyEntries() {
                return dependencies;
            }

            @Override
            public List<ClasspathEntry.AccessRule> getBootClasspathExtraAccessRules() {
                return EquinoxResolver.this.dependencyComputer.computeBootClasspathExtraAccessRules(state);
            }
        };
    }

    public static Properties computeMergedProperties(MavenProject mavenProject, MavenSession mavenSession) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        if (mavenSession != null) {
            properties.putAll((Map<?, ?>)mavenSession.getSystemProperties());
            properties.putAll((Map<?, ?>)mavenSession.getUserProperties());
        } else {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        return properties;
    }
}

