/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;

public class DefaultClasspathEntry
implements ClasspathEntry {
    private final ReactorProject project;
    private final ArtifactKey key;
    private final List<File> locations;
    private final Collection<ClasspathEntry.AccessRule> rules;

    public DefaultClasspathEntry(ResolvedArtifactKey key, Collection<ClasspathEntry.AccessRule> rules) {
        this(null, (ArtifactKey)key, List.of(key.getLocation()), rules);
    }

    public DefaultClasspathEntry(ReactorProject project, ArtifactKey key, List<File> locations, Collection<ClasspathEntry.AccessRule> rules) {
        this.key = Objects.requireNonNull(key);
        this.project = project;
        this.locations = locations;
        this.rules = rules;
    }

    public List<File> getLocations() {
        return this.locations;
    }

    public Collection<ClasspathEntry.AccessRule> getAccessRules() {
        return this.rules;
    }

    public ArtifactKey getArtifactKey() {
        return this.key;
    }

    public ReactorProject getMavenProject() {
        return this.project;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultClasspathEntry [key=");
        builder.append(this.key);
        builder.append("[" + this.key.getClass().getSimpleName() + "], ");
        if (this.project != null) {
            builder.append("project=");
            builder.append(this.project.getId());
            builder.append(", ");
        }
        if (this.locations != null) {
            builder.append("locations=");
            builder.append(this.locations);
            builder.append(", ");
        }
        if (this.rules != null) {
            builder.append("rules=");
            builder.append(this.rules);
        }
        builder.append("]");
        return builder.toString();
    }

    public static class DefaultAccessRule
    implements ClasspathEntry.AccessRule {
        private final String pattern;
        private final boolean discouraged;

        public DefaultAccessRule(String path, boolean discouraged) {
            Objects.requireNonNull(path);
            this.pattern = path;
            this.discouraged = discouraged;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ClasspathEntry.AccessRule)) return false;
            ClasspathEntry.AccessRule other = (ClasspathEntry.AccessRule)obj;
            if (this.isDiscouraged() != other.isDiscouraged()) return false;
            if (!this.getPattern().equals(other.getPattern())) return false;
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.discouraged ? 1231 : 1237);
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            return result;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String toString() {
            if (this.isDiscouraged()) {
                return this.getPattern() + " (discouraged)";
            }
            return this.getPattern();
        }

        public boolean isDiscouraged() {
            return this.discouraged;
        }
    }
}

