/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.BuildPropertiesImpl;
import org.eclipse.tycho.core.maven.TychoInterpolator;

@Component(role=BuildPropertiesParser.class)
public class BuildPropertiesParserImpl
implements BuildPropertiesParser,
Disposable {
    private final Map<String, BuildPropertiesImpl> cache = new HashMap<String, BuildPropertiesImpl>();
    @Requirement
    LegacySupport legacySupport;

    public BuildProperties parse(ReactorProject project) {
        MavenProject mavenProject = (MavenProject)project.adapt(MavenProject.class);
        return this.get(project.getBasedir(), () -> {
            MavenSession session;
            if (mavenProject != null && (session = this.legacySupport.getSession()) != null) {
                return new TychoInterpolator(session, mavenProject);
            }
            return null;
        }, mavenProject);
    }

    public BuildProperties parse(File baseDir, Interpolator interpolator) {
        if (interpolator == null) {
            return this.get(baseDir, () -> {
                MavenProject currentProject;
                MavenSession session = this.legacySupport.getSession();
                if (session != null && (currentProject = session.getCurrentProject()) != null) {
                    return new TychoInterpolator(session, currentProject);
                }
                return null;
            }, null);
        }
        return this.get(baseDir, () -> interpolator, null);
    }

    private synchronized BuildProperties get(File baseDir, Supplier<Interpolator> interpolatorSupplier, MavenProject mavenProject) {
        File propsFile = new File(baseDir, "build.properties");
        long lastModified = propsFile.lastModified();
        String filePath = propsFile.getAbsolutePath();
        BuildPropertiesImpl buildProperties = this.cache.get(filePath);
        if (buildProperties == null || lastModified > buildProperties.getTimestamp()) {
            Properties properties = BuildPropertiesParserImpl.readProperties(propsFile, mavenProject);
            this.interpolate(properties, interpolatorSupplier.get());
            buildProperties = new BuildPropertiesImpl(properties, lastModified);
            this.cache.put(filePath, buildProperties);
        }
        return buildProperties;
    }

    public void dispose() {
        this.cache.clear();
    }

    protected static Properties readProperties(File propsFile, MavenProject mavenProject) {
        Properties properties = new Properties();
        if (propsFile.isFile()) {
            try (FileInputStream is2 = new FileInputStream(propsFile);){
                properties.load(is2);
            }
            catch (IOException is2) {}
        } else if (mavenProject != null) {
            File basedir = mavenProject.getBasedir();
            properties.put("source..", mavenProject.getCompileSourceRoots().stream().map(p -> BuildPropertiesParserImpl.relative(basedir, p)).collect(Collectors.joining(",")));
            properties.setProperty("output..", BuildPropertiesParserImpl.relative(basedir, mavenProject.getBuild().getOutputDirectory()));
            properties.setProperty("bin.includes", ".");
        }
        return properties;
    }

    private static String relative(File basedir, String p) {
        String base = basedir.getAbsolutePath();
        if (p.startsWith(base)) {
            p = p.substring(base.length());
        }
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        return p;
    }

    protected void interpolate(Properties properties, Interpolator interpolator) {
        if (properties.isEmpty() || interpolator == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            entry.setValue(interpolator.interpolate((String)entry.getValue()));
        }
    }
}

