/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.core.osgitools.BaselineService;
import org.eclipse.tycho.helper.StatusTool;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.publisher.P2Artifact;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;

@Component(role=BaselineService.class)
public class BaselineServiceImpl
implements BaselineService {
    private IProgressMonitor monitor = new NullProgressMonitor();
    @Requirement
    private P2RepositoryManager repositoryManager;
    @Requirement
    private IProvisioningAgent agent;
    @Requirement
    private Logger logger;

    @Override
    public Map<String, IP2Artifact> getProjectBaseline(Collection<Repository> baselineRepositories, Map<String, IP2Artifact> reactor, File target) {
        baselineRepositories = this.repositoryManager.normalizeRepositoryLocations(baselineRepositories);
        ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
        ArrayList<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
        for (Repository location : baselineRepositories) {
            try {
                metadataRepositories.add(this.repositoryManager.getMetadataRepository(location));
                artifactRepositories.add(this.repositoryManager.getArtifactRepository(location));
            }
            catch (URISyntaxException | ProvisionException e) {
                this.logger.warn(e.getMessage(), e);
            }
        }
        CompoundQueryable baselineUnits = metadataRepositories.size() == 1 ? (IQueryable)metadataRepositories.getFirst() : new CompoundQueryable(metadataRepositories);
        ListCompositeArtifactRepository baselineArtifacts = artifactRepositories.size() == 1 ? (IArtifactRepository)artifactRepositories.getFirst() : new ListCompositeArtifactRepository(artifactRepositories, this.agent);
        LinkedHashMap<String, IP2Artifact> result = new LinkedHashMap<String, IP2Artifact>();
        for (Map.Entry<String, IP2Artifact> reactorArtifact : reactor.entrySet()) {
            IP2Artifact value = reactorArtifact.getValue();
            IArtifactDescriptor descriptor = value.getArtifactDescriptor();
            IArtifactDescriptor baselineDescriptor = this.getBaselineDescriptor((IArtifactRepository)baselineArtifacts, descriptor);
            if (baselineDescriptor == null) continue;
            IArtifactKey baselineKey = baselineDescriptor.getArtifactKey();
            String format = baselineDescriptor.getProperty("format");
            File baselineArtifact = new File(target, baselineKey.getClassifier() + "/" + baselineKey.getId() + "-" + String.valueOf(baselineKey.getVersion()) + (String)(format != null ? "." + format : "") + this.getExtension(value));
            baselineArtifact.getParentFile().mkdirs();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(baselineArtifact));){
                IStatus status = baselineArtifacts.getRawArtifact(baselineDescriptor, (OutputStream)os, this.monitor);
                if (status.matches(12)) {
                    String repository = baselineDescriptor.getRepository().getLocation().toString();
                    String artifactId = baselineDescriptor.getArtifactKey().getId();
                    String artifactVersion = baselineDescriptor.getArtifactKey().getVersion().toString();
                    String statusMessage = StatusTool.toLogMessage((IStatus)status);
                    throw new RuntimeException(String.format("Error trying to download %s version %s from %s:\n%s", artifactId, artifactVersion, repository, statusMessage), StatusTool.findException((IStatus)status));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit unit : value.getInstallableUnits()) {
                IInstallableUnit baselineUnit = this.getBaselineUnit((IQueryable<IInstallableUnit>)baselineUnits, unit.getId(), unit.getVersion());
                if (baselineUnit == null) continue;
                units.add(baselineUnit);
            }
            result.put(reactorArtifact.getKey(), new P2Artifact(baselineArtifact, units, descriptor));
        }
        return !result.isEmpty() ? result : null;
    }

    private String getExtension(IP2Artifact value) {
        String extension;
        File location = value.getLocation();
        if (location != null && !(extension = FilenameUtils.getExtension((String)location.getName())).isBlank()) {
            return "." + extension;
        }
        return "";
    }

    private IArtifactDescriptor getBaselineDescriptor(IArtifactRepository baseline, IArtifactDescriptor descriptor) {
        String format = descriptor.getProperty("format");
        IProcessingStepDescriptor[] processingSteps = descriptor.getProcessingSteps();
        return Arrays.stream(baseline.getArtifactDescriptors(descriptor.getArtifactKey())).filter(d -> Objects.equals(format, d.getProperty("format"))).filter(d -> Arrays.equals(processingSteps, d.getProcessingSteps())).findFirst().orElse(null);
    }

    private IInstallableUnit getBaselineUnit(IQueryable<IInstallableUnit> units, String id, Version version) {
        IQueryResult result = units.query(QueryUtil.createIUQuery((String)id, (Version)version), this.monitor);
        if (result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        IInstallableUnit unit = (IInstallableUnit)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Unit not unique in the baseline: " + id + " - " + String.valueOf(version));
        }
        return unit;
    }

    @Override
    public boolean isMetadataEqual(IP2Artifact baseline, IP2Artifact reactor) {
        return true;
    }
}

