/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.tycho.PackagingType;

@SessionScoped
@Component(role=WorkspaceReader.class, hint="tycho-reactor")
public class TychoReactorReader
implements MavenWorkspaceReader {
    static final String HINT = "tycho-reactor";
    private final Map<String, MavenProject> projectsByGAV;
    private final WorkspaceRepository repository;

    @Inject
    public TychoReactorReader(MavenSession session) {
        this.projectsByGAV = session.getProjects().stream().collect(Collectors.toMap(s -> ArtifactUtils.key((String)s.getGroupId(), (String)s.getArtifactId(), (String)s.getVersion()), Function.identity()));
        this.repository = new WorkspaceRepository(HINT, null);
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        return this.getTychoReactorProject(artifact).map(project -> {
            org.apache.maven.artifact.Artifact mainArtifact = project.getArtifact();
            if (mainArtifact != null && mainArtifact.getFile() != null && mainArtifact.getFile().exists()) {
                return mainArtifact.getFile();
            }
            return project.getBasedir();
        }).orElse(null);
    }

    public Optional<MavenProject> getTychoReactorProject(Artifact artifact) {
        String projectKey;
        MavenProject project;
        if (this.isTychoReactorArtifact(artifact) && (project = this.projectsByGAV.get(projectKey = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion()))) != null && PackagingType.TYCHO_PACKAGING_TYPES.contains(project.getPackaging())) {
            return Optional.of(project);
        }
        return Optional.empty();
    }

    public boolean isTychoReactorArtifact(Artifact artifact) {
        if (artifact.getClassifier() == null || artifact.getClassifier().isBlank()) {
            return PackagingType.TYCHO_PACKAGING_TYPES.contains(this.getPackagingType(artifact));
        }
        return false;
    }

    public String getPackagingType(Artifact artifact) {
        if (artifact != null) {
            return artifact.getProperty("type", "");
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        return this.getTychoReactorProject(artifact).map(project -> List.of(artifact.getVersion())).orElse(List.of());
    }

    public Model findModel(Artifact artifact) {
        MavenProject project = this.projectsByGAV.get(ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion()));
        return project == null ? null : project.getModel();
    }
}

