/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.RepositorySessionDecorator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Component(role=MavenDependenciesResolver.class)
public class MavenDependenciesResolver {
    @Requirement
    RepositorySystem repoSystem;
    @Requirement
    List<RepositorySessionDecorator> decorators;
    @Requirement
    Logger logger;

    public Collection<org.apache.maven.artifact.Artifact> resolve(MavenProject project, Collection<Dependency> dependencies, Collection<String> scopesToResolve, MavenSession session) throws DependencyCollectionException, DependencyResolutionException {
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<org.apache.maven.artifact.Artifact> resultSet = new HashSet<org.apache.maven.artifact.Artifact>();
        CollectRequest collect = new CollectRequest();
        RepositorySystemSession repositorySession = this.getRepositorySession(project, session);
        ArtifactTypeRegistry stereotypes = repositorySession.getArtifactTypeRegistry();
        for (Dependency dependency : dependencies) {
            collect.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
        }
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
        }
        collect.setRepositories(project.getRemoteProjectRepositories());
        CollectResult collectResult = this.repoSystem.collectDependencies(repositorySession, collect);
        DependencyNode rootNode = collectResult.getRoot();
        CumulativeScopeArtifactFilter scopeArtifactFilter = new CumulativeScopeArtifactFilter(scopesToResolve);
        DependencyRequest dependencyRequest = new DependencyRequest(collect, (node, parents) -> {
            org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)node.getArtifact());
            return artifact != null && scopeArtifactFilter.include(artifact);
        });
        dependencyRequest.setRoot(rootNode);
        DependencyResult dependencyResult = this.repoSystem.resolveDependencies(repositorySession, dependencyRequest);
        List artifactResults = dependencyResult.getArtifactResults();
        for (ArtifactResult ar : artifactResults) {
            DependencyNode node2 = ar.getRequest().getDependencyNode();
            org.eclipse.aether.graph.Dependency dependency = node2.getDependency();
            if (ar.isResolved()) {
                org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
                if (!scopeArtifactFilter.include(artifact)) continue;
                resultSet.add(artifact);
                continue;
            }
            this.logger.error("Cannot resolve " + String.valueOf(dependency));
            for (Exception e : ar.getExceptions()) {
                this.logger.error("", (Throwable)e);
            }
        }
        return resultSet;
    }

    private RepositorySystemSession getRepositorySession(MavenProject project, MavenSession session) {
        RepositorySystemSession repositorySession = session.getRepositorySession();
        for (RepositorySessionDecorator decorator : this.decorators) {
            RepositorySystemSession decorated = decorator.decorate(project, repositorySession);
            if (decorated == null) continue;
            repositorySession = decorated;
        }
        return repositorySession;
    }

    public org.apache.maven.artifact.Artifact resolveHighestVersion(MavenProject project, MavenSession session, Dependency dependency) throws VersionRangeResolutionException, ArtifactResolutionException {
        RepositorySystemSession repositorySession = this.getRepositorySession(project, session);
        ArtifactTypeRegistry stereotypes = repositorySession.getArtifactTypeRegistry();
        Object version = dependency.getVersion();
        if (!((String)version).startsWith("[") && !((String)version).startsWith("(")) {
            version = "[" + (String)version + ",)";
        }
        if (((String)version).endsWith(".0)")) {
            version = ((String)version).substring(0, ((String)version).length() - 3) + ")";
        }
        String typeId = Objects.requireNonNullElse(dependency.getType(), "jar");
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), stereotypes.get(typeId).getExtension(), (String)version);
        VersionRangeRequest request = new VersionRangeRequest((Artifact)artifact, project.getRemoteProjectRepositories(), null);
        VersionRangeResult versionResult = this.repoSystem.resolveVersionRange(repositorySession, request);
        Iterator iterator = versionResult.getVersions().iterator();
        while (iterator.hasNext()) {
            if (!((Version)iterator.next()).toString().contains("-")) continue;
            iterator.remove();
        }
        Version highestVersion = versionResult.getHighestVersion();
        if (highestVersion != null) {
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact.setVersion(highestVersion.toString()), project.getRemoteProjectRepositories(), null);
            ArtifactResult result = this.repoSystem.resolveArtifact(repositorySession, artifactRequest);
            return RepositoryUtils.toArtifact((Artifact)result.getArtifact());
        }
        return null;
    }

    public org.apache.maven.artifact.Artifact resolveArtifact(MavenProject project, MavenSession session, String groupId, String artifactId, String version) throws ArtifactResolutionException {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return this.resolveArtifact(project, session, dependency);
    }

    public org.apache.maven.artifact.Artifact resolveArtifact(MavenProject project, MavenSession session, Dependency dependency) throws ArtifactResolutionException {
        RepositorySystemSession repositorySession = this.getRepositorySession(project, session);
        ArtifactTypeRegistry stereotypes = repositorySession.getArtifactTypeRegistry();
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), stereotypes.get(dependency.getType()).getExtension(), dependency.getVersion());
        ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifact, project.getRemoteProjectRepositories(), null);
        ArtifactResult result = this.repoSystem.resolveArtifact(repositorySession, artifactRequest);
        return RepositoryUtils.toArtifact((Artifact)result.getArtifact());
    }
}

