/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.locking;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.tycho.LockTimeoutException;

public class FileLockerImpl {
    private static final String LOCKFILE_SUFFIX = ".tycholock";
    final Path lockMarkerFile;
    private FileLock lock;
    private Path file;

    FileLockerImpl(Path file) {
        this.file = file.toAbsolutePath().normalize();
        this.lockMarkerFile = Files.isDirectory(this.file, new LinkOption[0]) ? this.file.resolve(LOCKFILE_SUFFIX) : this.file.getParent().resolve(String.valueOf(this.file.getFileName()) + LOCKFILE_SUFFIX);
        try {
            if (Files.isDirectory(this.lockMarkerFile, new LinkOption[0])) {
                throw new IllegalStateException("Lock marker file " + String.valueOf(this.lockMarkerFile) + " already exists and is a directory");
            }
            Files.createDirectories(this.lockMarkerFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void lock(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        if (this.lock != null) {
            throw new LockTimeoutException("already locked file " + String.valueOf(this.file));
        }
        this.lock = this.aquireLock(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock aquireLock(long timeout) {
        long waitInterval = 50L;
        long maxTries = timeout / 50L + 1L;
        FileChannel channel = null;
        for (long i = 0L; i < maxTries; ++i) {
            try {
                FileLock fileLock;
                if (channel == null) {
                    channel = FileChannel.open(this.lockMarkerFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                }
                if ((fileLock = channel.tryLock()) != null) {
                    return fileLock;
                }
            }
            catch (IOException fileLock) {
                // empty catch block
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LockTimeoutException("Interrupted", (Throwable)e);
            }
        }
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                channel = null;
            }
        }
        throw new LockTimeoutException("lock timeout: Could not acquire lock on file " + String.valueOf(this.lockMarkerFile) + " for " + timeout + " msec");
    }

    synchronized void release() {
        if (this.lock != null) {
            try {
                this.lock.acquiredBy().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lock = null;
            File lockFile = this.lockMarkerFile.toFile();
            if (!lockFile.delete()) {
                lockFile.deleteOnExit();
            }
        }
    }
}

