/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.locking;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.LockTimeoutException;
import org.eclipse.tycho.core.locking.FileLockerImpl;

@Component(role=FileLockService.class)
public class FileLockServiceImpl
implements FileLockService {
    private final Map<Path, FileLocks> lockers = new ConcurrentHashMap<Path, FileLocks>();

    public Closeable lock(File file, long timeout) {
        FileLocks locks = this.getFileLocker(file.toPath());
        FileLockerImpl locker = locks.fileLocker();
        try {
            if (!locks.vmLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
                throw new LockTimeoutException("lock timeout: Could not acquire lock on file " + String.valueOf(locker.lockMarkerFile) + " for " + timeout + " msec");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LockTimeoutException("Interrupted", (Throwable)e);
        }
        locker.lock(timeout);
        return () -> {
            locks.fileLocker().release();
            locks.vmLock().unlock();
        };
    }

    public Closeable lockVirtually(File file) {
        FileLocks locks = this.getFileLocker(file.toPath());
        locks.vmLock().lock();
        return locks.vmLock()::unlock;
    }

    FileLocks getFileLocker(Path file) {
        Path key;
        try {
            key = file.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            key = file.toAbsolutePath().normalize();
        }
        return this.lockers.computeIfAbsent(key, f -> new FileLocks(new FileLockerImpl((Path)f), new ReentrantLock()));
    }

    record FileLocks(FileLockerImpl fileLocker, Lock vmLock) {
    }
}

