/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ExecutionEnvironment;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.ee.ListSystemPackages;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.UnknownEnvironmentException;
import org.osgi.framework.BundleActivator;

public class ExecutionEnvironmentUtils {
    private static Map<String, StandardExecutionEnvironment> executionEnvironmentsMap;
    private static final Map<String, StandardExecutionEnvironment> surrogateExecutionEnvironmentsMap;

    private static Properties readProperties(URL url) {
        Properties listProps = new Properties();
        try (InputStream stream = url.openStream();){
            listProps.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return listProps;
    }

    public static StandardExecutionEnvironment getExecutionEnvironment(String profileName, ToolchainManager manager, MavenSession session, Logger logger) throws UnknownEnvironmentException {
        Map<String, StandardExecutionEnvironment> map = ExecutionEnvironmentUtils.getExecutionEnvironmentsMap(manager, session, logger);
        StandardExecutionEnvironment ee = map.get(profileName);
        if (ee != null) {
            return ee;
        }
        int version = ExecutionEnvironmentUtils.getVersion(profileName);
        if (version > 8) {
            StandardExecutionEnvironment higherEE = map.keySet().stream().mapToInt(ExecutionEnvironmentUtils::getVersion).filter(v -> v > version).min().stream().mapToObj(v -> {
                String[] split = profileName.split("-");
                return split[0] + "-" + v;
            }).map(map::get).filter(Objects::nonNull).findFirst().orElse(null);
            if (higherEE != null) {
                logger.debug("Using " + higherEE.getProfileName() + " to fulfill requested profile of " + profileName + ". This might lead to faulty dependency resolution, consider defining a suitable JDK in the toolchains.xml.");
                return ExecutionEnvironmentUtils.getSurrogate(profileName, higherEE);
            }
        }
        logger.debug("Unknown OSGi execution environment. Execution environment currently known to the build:");
        for (StandardExecutionEnvironment knownEE : map.values()) {
            logger.debug(knownEE.getProfileName());
        }
        throw new UnknownEnvironmentException(profileName);
    }

    private static StandardExecutionEnvironment getSurrogate(String profileName, StandardExecutionEnvironment surrogateEE) {
        return surrogateExecutionEnvironmentsMap.computeIfAbsent(surrogateEE.getProfileName() + " as " + profileName, nil -> {
            List<String> packages = Arrays.stream(surrogateEE.getProfileProperties().getProperty("org.osgi.framework.system.packages", "").split(",")).map(String::trim).toList();
            Properties profileProperties = ExecutionEnvironmentUtils.createProfileJvm(ExecutionEnvironmentUtils.getVersion(profileName), packages);
            return new StandardExecutionEnvironment(profileProperties, surrogateEE.getToolchain(), surrogateEE.getLogger());
        });
    }

    public static Collection<String> getProfileNames(ToolchainManager manager, MavenSession session, Logger logger) {
        return new ArrayList<String>(ExecutionEnvironmentUtils.getExecutionEnvironmentsMap(manager, session, logger).keySet());
    }

    private static synchronized Map<String, StandardExecutionEnvironment> getExecutionEnvironmentsMap(ToolchainManager manager, MavenSession session, Logger logger) {
        if (executionEnvironmentsMap == null) {
            int javaVersion;
            String name;
            executionEnvironmentsMap = new LinkedHashMap<String, StandardExecutionEnvironment>();
            Properties listProps = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle("profile.list"));
            for (String profileFile : listProps.getProperty("java.profiles").split(",")) {
                Properties props = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle(profileFile.trim()));
                if (props == null) {
                    logger.warn("Cannot read profile " + profileFile + " from the system path");
                    continue;
                }
                name = props.getProperty("osgi.java.profile.name").trim();
                executionEnvironmentsMap.put(name, new StandardExecutionEnvironment(props, ExecutionEnvironmentUtils.getToolchainFor(name, null, manager, session, logger), logger));
            }
            if (manager != null) {
                List jdks = manager.getToolchains(session, "jdk", null);
                for (Toolchain jdk : jdks) {
                    StandardExecutionEnvironment.JavaInfo javaInfo = StandardExecutionEnvironment.readFromToolchains(jdk, logger);
                    if (javaInfo.version <= 8) continue;
                    Properties toolchainJvm = ExecutionEnvironmentUtils.createProfileJvm(javaInfo.version, javaInfo.packages);
                    name = toolchainJvm.getProperty("osgi.java.profile.name").trim();
                    executionEnvironmentsMap.put(name, new StandardExecutionEnvironment(toolchainJvm, jdk, logger));
                }
            }
            if (!executionEnvironmentsMap.containsKey("JavaSE-" + (javaVersion = Runtime.version().feature()))) {
                Properties runningVm = ExecutionEnvironmentUtils.createProfileJvm(javaVersion, ListSystemPackages.getCurrentJREPackages());
                String name2 = runningVm.getProperty("osgi.java.profile.name").trim();
                executionEnvironmentsMap.put(name2, new StandardExecutionEnvironment(runningVm, ExecutionEnvironmentUtils.getToolchainFor(name2, null, manager, session, logger), logger));
            }
        }
        return executionEnvironmentsMap;
    }

    public static Toolchain getToolchainFor(String profileName, TargetEnvironment environment, ToolchainManager manager, MavenSession session, Logger logger) {
        if (manager != null) {
            logger.debug("Searching profile " + profileName + " in ToolchainManager");
            Iterator iterator = manager.getToolchains(session, "jdk", Map.of("id", profileName)).iterator();
            if (iterator.hasNext()) {
                Toolchain toolchain = (Toolchain)iterator.next();
                return toolchain;
            }
            int version = ExecutionEnvironmentUtils.getVersion(profileName);
            Iterator toolchain = manager.getToolchains(session, "jdk", Map.of("version", String.valueOf(version))).iterator();
            if (toolchain.hasNext()) {
                Toolchain toolchain2 = (Toolchain)toolchain.next();
                return toolchain2;
            }
            if (version < 9 && (toolchain = manager.getToolchains(session, "jdk", Map.of("version", "1." + version)).iterator()).hasNext()) {
                Toolchain toolchain3 = (Toolchain)toolchain.next();
                return toolchain3;
            }
            if (environment != null) {
                String os = environment.getOs();
                String arch = environment.getArch();
                Iterator iterator2 = manager.getToolchains(session, "jdk", Map.of("version", String.valueOf(version), "os", os, "arch", arch)).iterator();
                if (iterator2.hasNext()) {
                    Toolchain toolchain4 = (Toolchain)iterator2.next();
                    return toolchain4;
                }
            }
        }
        return null;
    }

    public static int getVersion(String profileName) {
        String[] split = profileName.split("-");
        if (split.length == 2) {
            try {
                String version = split[1];
                return Integer.parseInt(version.startsWith("1.") ? version.substring(2) : version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static void applyProfileProperties(Properties properties, ExecutionEnvironment executionEnvironment) {
        String systemCapabilities;
        String ee;
        String systemExports = properties.getProperty("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = executionEnvironment.getSystemPackages().stream().map(ExecutionEnvironment.SystemPackageEntry::toPackageSpecifier).collect(Collectors.joining(","))) != null && !systemExports.isEmpty()) {
            properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = properties.getProperty("osgi.java.profile.bootdelegation");
        Properties profileProps = executionEnvironment.getProfileProperties();
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                properties.remove("org.osgi.framework.bootdelegation");
            } else {
                properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            properties.remove("org.osgi.framework.bootdelegation");
        }
        if (properties.getProperty("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            properties.put("org.osgi.framework.executionenvironment", ee);
        }
        if (properties.getProperty("org.osgi.framework.system.capabilities") == null && (systemCapabilities = profileProps.getProperty("org.osgi.framework.system.capabilities")) != null) {
            properties.put("org.osgi.framework.system.capabilities", systemCapabilities);
        }
    }

    private static URL findInSystemBundle(String entry) {
        ClassLoader loader = BundleActivator.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }

    private static Properties createProfileJvm(int javaVersion, Collection<String> packages) {
        String profileName = "JavaSE-" + javaVersion;
        Properties props = new Properties();
        props.setProperty("org.osgi.framework.system.packages", packages.stream().collect(Collectors.joining(",")));
        StringBuilder ee = new StringBuilder("OSGi/Minimum-1.0,OSGi/Minimum-1.1,OSGi/Minimum-1.2,JavaSE/compact1-1.8,JavaSE/compact2-1.8,JavaSE/compact3-1.8,JRE-1.1,J2SE-1.2,J2SE-1.3,J2SE-1.4,J2SE-1.5,JavaSE-1.6,JavaSE-1.7,JavaSE-1.8,");
        for (int i = 9; i < javaVersion; ++i) {
            ee.append("JavaSE-" + String.valueOf(i) + ",");
        }
        ee.append(profileName);
        props.setProperty("org.osgi.framework.executionenvironment", ee.toString());
        StringBuilder versionList = new StringBuilder();
        versionList.append("1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8");
        for (int i = 9; i <= javaVersion; ++i) {
            versionList.append(", " + String.valueOf(i) + ".0");
        }
        props.setProperty("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\",osgi.ee; osgi.ee=\"JRE\"; version:List<Version>=\"1.0, 1.1\",osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"" + versionList.toString() + "\",osgi.ee; osgi.ee=\"JavaSE/compact1\"; version:List<Version>=\"1.8," + String.valueOf(javaVersion) + ".0\",osgi.ee; osgi.ee=\"JavaSE/compact2\"; version:List<Version>=\"1.8," + String.valueOf(javaVersion) + ".0\",osgi.ee; osgi.ee=\"JavaSE/compact3\"; version:List<Version>=\"1.8," + String.valueOf(javaVersion) + ".0\"");
        props.setProperty("osgi.java.profile.name", profileName);
        props.setProperty("org.eclipse.jdt.core.compiler.compliance", String.valueOf(javaVersion));
        props.setProperty("org.eclipse.jdt.core.compiler.source", String.valueOf(javaVersion));
        props.setProperty("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
        props.setProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", String.valueOf(javaVersion));
        props.setProperty("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
        props.setProperty("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        return props;
    }

    static {
        surrogateExecutionEnvironmentsMap = new ConcurrentHashMap<String, StandardExecutionEnvironment>();
    }
}

