/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.bnd;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.manifest.ManifestUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.bndlib.SourceCodeAnalyzerPlugin;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="pde.bnd")
public class PdeInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private InstallableUnitGenerator installableUnitGenerator;
    @Requirement
    private MavenDependenciesResolver mavenDependenciesResolver;
    private Map<MavenProject, Collection<IInstallableUnit>> cache = new ConcurrentHashMap<MavenProject, Collection<IInstallableUnit>>();

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        return this.cache.computeIfAbsent(project, p -> {
            Optional<Processor> bndTychoProject = this.projectManager.getBndTychoProject(project);
            if (bndTychoProject.isPresent()) {
                Collection<IInstallableUnit> collection;
                block21: {
                    Processor pr = bndTychoProject.get();
                    try {
                        collection = this.generateWithProcessor(project, pr, project.getArtifacts());
                        if (pr == null) break block21;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (pr != null) {
                                try {
                                    pr.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.logger.warn("Can't determine additional units for " + project.getId(), (Throwable)e);
                        }
                    }
                    pr.close();
                }
                return collection;
            } else {
                Optional<Processor> bndPluginProcessor = this.getProcessor(project);
                if (bndPluginProcessor.isPresent()) {
                    Collection<IInstallableUnit> collection;
                    block22: {
                        Processor pr = bndPluginProcessor.get();
                        try {
                            if (pr.getProperty("Bundle-SymbolicName") == null) {
                                pr.setProperty("Bundle-SymbolicName", project.getArtifactId());
                            }
                            if (pr.getProperty("Bundle-Version") == null) {
                                Version version = new MavenVersion(project.getVersion()).getOSGiVersion();
                                pr.setProperty("Bundle-Version", version.toString());
                            }
                            Collection<Dependency> dependencies = PdeInstallableUnitProvider.collectInitial(project, new HashMap<String, Dependency>()).values();
                            collection = this.generateWithProcessor(project, pr, this.mavenDependenciesResolver.resolve(project, dependencies, Set.of("compile", "test"), session));
                            if (pr == null) break block22;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (pr != null) {
                                    try {
                                        pr.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                this.logger.warn("Can't determine additional units for " + project.getId(), (Throwable)e);
                            }
                        }
                        pr.close();
                    }
                    return collection;
                }
            }
            return Collections.emptyList();
        });
    }

    private Optional<Processor> getProcessor(MavenProject project) {
        Plugin plugin;
        if ("jar".equals(project.getPackaging()) && (plugin = project.getPlugin(Plugin.constructKey((String)"biz.aQute.bnd", (String)"bnd-maven-plugin"))) != null) {
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom configuration;
                if (!execution.getGoals().contains("bnd-process") || (configuration = PdeInstallableUnitProvider.getConfig(execution.getConfiguration())) == null) continue;
                Properties props = new Properties();
                Properties pp = project.getProperties();
                for (String k : pp.stringPropertyNames()) {
                    props.setProperty(k, pp.getProperty(k));
                }
                File bndFile = this.getBndFile(configuration, project);
                if (bndFile.exists()) {
                    try (FileInputStream stream2 = new FileInputStream(bndFile);){
                        props.load(stream2);
                    }
                    catch (IOException stream2) {}
                } else {
                    Xpp3Dom bnd = configuration.getChild("bnd");
                    if (bnd != null) {
                        try {
                            props.load(new StringReader(bnd.getValue()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                Processor processor = new Processor(props, false);
                processor.setBase(project.getBasedir());
                return Optional.of(processor);
            }
        }
        return Optional.empty();
    }

    private File getBndFile(Xpp3Dom configuration, MavenProject project) {
        Xpp3Dom bndfile = configuration.getChild("bndfile");
        if (bndfile != null) {
            return new File(bndfile.getValue());
        }
        return new File(project.getBasedir(), "bnd.bnd");
    }

    private static Xpp3Dom getConfig(Object configuration) {
        if (configuration == null) {
            return null;
        }
        if (configuration instanceof Xpp3Dom) {
            return (Xpp3Dom)configuration;
        }
        try {
            return Xpp3DomBuilder.build((Reader)new StringReader(configuration.toString()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, Dependency> collectInitial(MavenProject project, Map<String, Dependency> map) {
        for (Dependency dependency : project.getDependencies()) {
            map.putIfAbsent(dependency.getManagementKey(), dependency);
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            return PdeInstallableUnitProvider.collectInitial(parent, map);
        }
        return map;
    }

    private Collection<IInstallableUnit> generateWithProcessor(MavenProject project, Processor processor, Collection<Artifact> artifacts) throws Exception {
        final SourceCodeAnalyzerPlugin plugin = new SourceCodeAnalyzerPlugin(project.getCompileSourceRoots().stream().map(x$0 -> Path.of(x$0, new String[0])).toList());
        try (Builder analyzer = new Builder(this, processor){

            public Clazz getPackageInfo(Descriptors.PackageRef packageRef) {
                Clazz info = super.getPackageInfo(packageRef);
                if (info == null) {
                    return plugin.getPackageInfoClass(packageRef);
                }
                return info;
            }

            public Clazz findClass(Descriptors.TypeRef typeRef) throws Exception {
                return super.findClass(typeRef);
            }
        };){
            analyzer.setBase(project.getBasedir());
            Jar jar = new Jar(project.getArtifactId());
            analyzer.setJar(jar);
            for (Object artifact : artifacts) {
                File file = artifact.getFile();
                if (file == null) continue;
                try {
                    analyzer.addClasspath(file);
                }
                catch (Exception e) {}
            }
            analyzer.addBasicPlugin((Object)plugin);
            analyzer.setProperty("-noextraheaders", "true");
            analyzer.build();
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                Object artifact;
                artifact = Collections.emptyList();
                return artifact;
            }
            if (this.logger.isDebugEnabled()) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ManifestUtil.write((Manifest)manifest, (OutputStream)outputStream);
                String str = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                this.logger.debug("Generated preliminary manifest for " + project.getId() + ":\r\n" + str);
                for (String error : analyzer.getErrors()) {
                    this.logger.debug("ERROR: " + error);
                }
                for (String warn : analyzer.getWarnings()) {
                    this.logger.debug("WARN:  " + warn);
                }
            }
            Collection collection = this.installableUnitGenerator.getInstallableUnits(manifest);
            return collection;
        }
    }
}

