/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

public class VersioningHelper {
    public static final String QUALIFIER = "qualifier";

    public static String expandQualifier(String version, String buildQualifier) {
        String unqualifiedVersion = VersioningHelper.stripQualifier(version);
        if (unqualifiedVersion == null) {
            return version;
        }
        return VersioningHelper.appendSegment(unqualifiedVersion, buildQualifier);
    }

    private static String stripQualifier(String version) {
        if (version.endsWith(".qualifier")) {
            int qualifierIndex = version.length() - QUALIFIER.length();
            return version.substring(0, qualifierIndex - 1);
        }
        return null;
    }

    private static String appendSegment(String version, String newSegment) {
        if (newSegment == null || "".equals(newSegment)) {
            return version;
        }
        return version + "." + newSegment;
    }
}

