/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.targetplatform.TargetDefinitionFile;
import org.eclipse.tycho.targetplatform.TargetPlatformFilter;

public class TargetPlatformConfiguration
implements DependencyResolverConfiguration {
    private String resolver;
    private Set<TargetEnvironment> environments = new LinkedHashSet<TargetEnvironment>();
    private List<TargetEnvironment> filteredEnvironments = new ArrayList<TargetEnvironment>();
    private boolean implicitTargetEnvironment = true;
    private final List<URI> targets = new ArrayList<URI>();
    private IncludeSourceMode targetDefinitionIncludeSourceMode = IncludeSourceMode.honor;
    private PomDependencies pomDependencies;
    private String executionEnvironment;
    private String executionEnvironmentDefault;
    private BREEHeaderSelectionPolicy breeHeaderSelectionPolicy = BREEHeaderSelectionPolicy.first;
    private boolean resolveWithEEConstraints = true;
    private List<TargetPlatformFilter> filters;
    private OptionalResolutionAction optionalAction = OptionalResolutionAction.REQUIRE;
    private final List<ArtifactKey> extraRequirements = new ArrayList<ArtifactKey>();
    private final Set<String> exclusions = new HashSet<String>();
    private Map<String, String> resolverProfileProperties = new HashMap<String, String>();
    private final List<Supplier<File>> lazyTargetFiles = new ArrayList<Supplier<File>>();
    private LocalArtifactHandling localArtifactHandling;
    private boolean requireEagerResolve;
    private InjectP2MavenMetadataHandling p2MavenMetadataHandling;
    private ReferencedRepositoryMode referencedRepositoryMode = ReferencedRepositoryMode.include;
    private List<Xpp3Dom> xmlFragments = new ArrayList<Xpp3Dom>();

    public List<TargetEnvironment> getEnvironments() {
        return List.copyOf(this.environments);
    }

    public String getTargetPlatformResolver() {
        return this.resolver;
    }

    public synchronized List<TargetDefinitionFile> getTargets() {
        Iterator<Supplier<File>> iterator = this.lazyTargetFiles.iterator();
        while (iterator.hasNext()) {
            Supplier<File> supplier = iterator.next();
            this.targets.add(supplier.get().toURI());
            iterator.remove();
        }
        if (!this.xmlFragments.isEmpty()) {
            Xpp3Dom target = new Xpp3Dom("target");
            Xpp3Dom locations = new Xpp3Dom("locations");
            target.addChild(locations);
            for (Xpp3Dom location : this.xmlFragments) {
                locations.addChild(new Xpp3Dom(location));
            }
            String collect = target.toString();
            this.targets.add(URI.create("data:application/target;base64," + Base64.getEncoder().encodeToString(collect.getBytes(StandardCharsets.UTF_8))));
            this.xmlFragments.clear();
        }
        return this.targets.stream().map(TargetDefinitionFile::read).toList();
    }

    public void addEnvironment(TargetEnvironment environment) {
        this.environments.add(environment);
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public void addTarget(File target) {
        this.addTarget(target.toURI());
    }

    public void addTarget(URI target) {
        this.targets.add(target);
    }

    public synchronized void addLazyTargetFile(Supplier<File> targetFileSupplier) {
        this.lazyTargetFiles.add(targetFileSupplier);
    }

    public IncludeSourceMode getTargetDefinitionIncludeSourceMode() {
        return this.targetDefinitionIncludeSourceMode;
    }

    public void setTargetDefinitionIncludeSourceMode(IncludeSourceMode includeSourcesMode) {
        this.targetDefinitionIncludeSourceMode = includeSourcesMode;
    }

    public void setPomDependencies(PomDependencies pomDependencies) {
        this.pomDependencies = pomDependencies;
    }

    public PomDependencies getPomDependencies() {
        if (this.pomDependencies == null) {
            if (this.isRequireEagerResolve()) {
                return PomDependencies.ignore;
            }
            return PomDependencies.consider;
        }
        return this.pomDependencies;
    }

    public boolean isImplicitTargetEnvironment() {
        return this.implicitTargetEnvironment;
    }

    public void setImplicitTargetEnvironment(boolean implicitTargetEnvironment) {
        this.implicitTargetEnvironment = implicitTargetEnvironment;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getExecutionEnvironmentDefault() {
        return this.executionEnvironmentDefault;
    }

    public void setExecutionEnvironmentDefault(String executionEnvironment) {
        this.executionEnvironmentDefault = executionEnvironment;
    }

    public BREEHeaderSelectionPolicy getBREEHeaderSelectionPolicy() {
        return this.breeHeaderSelectionPolicy;
    }

    public void setBREEHeaderSelectionPolicy(BREEHeaderSelectionPolicy breeHeaderSelectionPolicy) {
        this.breeHeaderSelectionPolicy = breeHeaderSelectionPolicy;
    }

    public boolean isResolveWithEEConstraints() {
        return this.resolveWithEEConstraints;
    }

    public void setResolveWithEEContraints(boolean value) {
        this.resolveWithEEConstraints = value;
    }

    public boolean isRequireEagerResolve() {
        return this.requireEagerResolve;
    }

    public void setRequireEagerResolve(boolean value) {
        this.requireEagerResolve = value;
    }

    public void setFilters(List<TargetPlatformFilter> filters) {
        this.filters = filters;
    }

    public List<TargetPlatformFilter> getFilters() {
        return this.filters == null ? Collections.emptyList() : this.filters;
    }

    public DependencyResolverConfiguration getDependencyResolverConfiguration() {
        return this;
    }

    @Override
    public List<ArtifactKey> getAdditionalArtifacts() {
        Stream<DefaultArtifactKey> targetFiles = this.getTargets().stream().flatMap(tdf -> tdf.implicitDependencies()).map(id -> new DefaultArtifactKey("eclipse-plugin", id.getId()));
        return Stream.concat(this.extraRequirements.stream(), targetFiles).distinct().toList();
    }

    @Override
    public OptionalResolutionAction getOptionalResolutionAction() {
        return this.optionalAction;
    }

    public void addExtraRequirement(ArtifactKey requirement) {
        this.extraRequirements.add(requirement);
    }

    public void setOptionalResolutionAction(OptionalResolutionAction optionalAction) {
        this.optionalAction = optionalAction;
    }

    public Map<String, String> getProfileProperties() {
        return this.resolverProfileProperties;
    }

    public void addProfileProperty(String key, String value) {
        this.resolverProfileProperties.put(key, value);
    }

    public void addExclusion(String groupId, String artifactId) {
        this.exclusions.add(groupId + ":" + artifactId);
    }

    public boolean isExcluded(String groupId, String artifactId) {
        return this.exclusions.contains(groupId + ":" + artifactId);
    }

    @Override
    public Collection<IRequirement> getAdditionalRequirements() {
        return List.of();
    }

    public LocalArtifactHandling getIgnoreLocalArtifacts() {
        if (this.localArtifactHandling == null) {
            return LocalArtifactHandling.include;
        }
        return this.localArtifactHandling;
    }

    public InjectP2MavenMetadataHandling getP2MetadataHandling() {
        if (this.p2MavenMetadataHandling == null) {
            return InjectP2MavenMetadataHandling.validate;
        }
        return this.p2MavenMetadataHandling;
    }

    public void setP2MavenMetadataHandling(InjectP2MavenMetadataHandling p2MavenMetadataHandling) {
        this.p2MavenMetadataHandling = p2MavenMetadataHandling;
    }

    public void setLocalArtifactHandling(LocalArtifactHandling localArtifactHandling) {
        this.localArtifactHandling = localArtifactHandling;
    }

    public ReferencedRepositoryMode getReferencedRepositoryMode() {
        return this.referencedRepositoryMode;
    }

    public void setReferencedRepositoryMode(ReferencedRepositoryMode referencedRepositoryMode) {
        this.referencedRepositoryMode = referencedRepositoryMode;
    }

    public void addTargetLocation(Xpp3Dom locationDom) {
        this.xmlFragments.add(locationDom);
    }

    public void addFilteredEnvironment(TargetEnvironment environment) {
        this.filteredEnvironments.add(environment);
    }

    public List<TargetEnvironment> getFilteredEnvironments() {
        return this.filteredEnvironments;
    }

    public static enum BREEHeaderSelectionPolicy {
        first,
        minimal;

    }

    public static enum LocalArtifactHandling {
        include,
        equivalent,
        compatible,
        perfect,
        ignore;

    }

    public static enum InjectP2MavenMetadataHandling {
        ignore,
        inject,
        validate;

    }
}

