/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.m2e.pde.target.shared.AdditionalRepository;
import org.eclipse.m2e.pde.target.shared.ArtifactDescriptor;
import org.eclipse.m2e.pde.target.shared.DependencyDepth;
import org.eclipse.m2e.pde.target.shared.DependencyResult;
import org.eclipse.m2e.pde.target.shared.MavenRootDependency;
import org.eclipse.m2e.pde.target.shared.RepositoryArtifact;

public class MavenDependencyCollector {
    private static final String TYPE_POM = "pom";
    private static final Set<String> VALID_EXTENSIONS = Set.of("jar", "pom");
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repositorySession;
    private final List<RemoteRepository> repositories;
    private final Collection<String> dependencyScopes;
    private DependencyDepth dependencyDepth;

    public MavenDependencyCollector(RepositorySystem repoSystem, RepositorySystemSession repositorySession, List<RemoteRepository> defaultRepositories, Collection<AdditionalRepository> additionalRepositories, DependencyDepth depth, Collection<String> dependencyScopes) {
        this.repoSystem = repoSystem;
        this.repositorySession = repositorySession;
        if (additionalRepositories == null || additionalRepositories.isEmpty()) {
            this.repositories = repoSystem.newResolutionRepositories(repositorySession, defaultRepositories);
        } else {
            List<RemoteRepository> combined = Stream.concat(defaultRepositories.stream(), additionalRepositories.stream().map(additional -> new RemoteRepository.Builder(additional.id(), "default", additional.url()).setReleasePolicy(new RepositoryPolicy(true, "always", "warn")).setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn")).build())).distinct().toList();
            this.repositories = repoSystem.newResolutionRepositories(repositorySession, combined);
        }
        this.dependencyDepth = depth;
        this.dependencyScopes = dependencyScopes;
    }

    public List<RemoteRepository> getEffectiveRepositories() {
        return this.repositories;
    }

    public DependencyResult collect(MavenRootDependency root) throws RepositoryException {
        if (!VALID_EXTENSIONS.contains(root.getType())) {
            throw new RepositoryException("Invalid root dependency: " + String.valueOf(root) + " allowed types are " + String.valueOf(VALID_EXTENSIONS));
        }
        DependencyDepth depth = MavenDependencyCollector.getEffectiveDepth(root, this.dependencyDepth);
        ArrayList<RepositoryArtifact> artifacts = new ArrayList<RepositoryArtifact>();
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>();
        ArtifactDescriptor rootDescriptor = this.readArtifactDescriptor(new Dependency((Artifact)new DefaultArtifact(root.groupId(), root.artifactId(), root.classifier(), root.type(), root.version()), null), null, artifacts, nodes);
        if (depth == DependencyDepth.NONE) {
            return new DependencyResult(depth, artifacts, rootDescriptor.node(), nodes);
        }
        if (depth == DependencyDepth.DIRECT) {
            for (Dependency dependency : rootDescriptor.dependencies()) {
                this.readArtifactDescriptor(dependency, rootDescriptor.node(), artifacts, nodes);
            }
            return new DependencyResult(depth, artifacts, rootDescriptor.node(), nodes);
        }
        HashSet<String> collected = new HashSet<String>();
        collected.add(MavenDependencyCollector.getId(rootDescriptor.node().getDependency()));
        LinkedList<ArtifactDescriptor> queue = new LinkedList<ArtifactDescriptor>();
        queue.add(rootDescriptor);
        while (!queue.isEmpty()) {
            ArtifactDescriptor current = (ArtifactDescriptor)queue.poll();
            for (Dependency dependency : current.dependencies()) {
                ArtifactDescriptor dependencyDescriptor;
                if (!this.isValidDependency(dependency) || !this.isValidScope(dependency)) continue;
                if (this.isVersionRanged(dependency)) {
                    dependencyDescriptor = this.resolveHighestVersion(dependency, current.node(), artifacts, nodes);
                    if (dependencyDescriptor == null || !collected.add(MavenDependencyCollector.getId(dependencyDescriptor.node().getDependency()))) continue;
                    queue.add(dependencyDescriptor);
                    continue;
                }
                if (!collected.add(MavenDependencyCollector.getId(dependency)) || (dependencyDescriptor = this.readArtifactDescriptor(dependency, current.node(), artifacts, nodes)) == null) continue;
                queue.add(dependencyDescriptor);
            }
        }
        return new DependencyResult(depth, artifacts, rootDescriptor.node(), nodes);
    }

    private ArtifactDescriptor resolveHighestVersion(Dependency dependency, DependencyNode parent, Collection<RepositoryArtifact> artifacts, List<DependencyNode> nodes) throws VersionRangeResolutionException {
        Artifact artifact = dependency.getArtifact();
        VersionRangeRequest request = new VersionRangeRequest(artifact, this.repositories, "");
        VersionRangeResult result = this.repoSystem.resolveVersionRange(this.repositorySession, request);
        List list = result.getVersions().stream().sorted(Comparator.reverseOrder()).toList();
        for (Version version : list) {
            Artifact setVersion = artifact.setVersion(version.toString());
            dependency = dependency.setArtifact(setVersion);
            try {
                return this.readArtifactDescriptor(dependency, parent, artifacts, nodes);
            }
            catch (RepositoryException repositoryException) {
            }
        }
        return null;
    }

    private boolean isVersionRanged(Dependency dependency) {
        String version = dependency.getArtifact().getVersion();
        return version != null && version.startsWith("(") || version.startsWith("[");
    }

    private ArtifactDescriptor readArtifactDescriptor(Dependency dependency, DependencyNode parent, Collection<RepositoryArtifact> artifacts, List<DependencyNode> nodes) throws RepositoryException {
        if (this.isValidScope(dependency) && this.isValidDependency(dependency)) {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
            descriptorRequest.setArtifact(dependency.getArtifact());
            descriptorRequest.setRepositories(this.repositories);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(this.repositorySession, descriptorRequest);
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(result.getArtifact());
            artifactRequest.setRepositories(this.repositories);
            ArtifactResult artifactResult = this.repoSystem.resolveArtifact(this.repositorySession, artifactRequest);
            Artifact resolved = artifactResult.getArtifact();
            artifacts.add(new RepositoryArtifact(resolved, artifactResult.getRepository()));
            DefaultDependencyNode dependencyNode = new DefaultDependencyNode(new Dependency(resolved, dependency.getScope()));
            nodes.add((DependencyNode)dependencyNode);
            if (parent != null) {
                parent.getChildren().add(dependencyNode);
            }
            return new ArtifactDescriptor((DependencyNode)dependencyNode, result.getDependencies(), result.getManagedDependencies());
        }
        return null;
    }

    private boolean isValidDependency(Dependency dependency) {
        if (dependency.isOptional()) {
            return false;
        }
        return VALID_EXTENSIONS.contains(dependency.getArtifact().getExtension());
    }

    private boolean isValidScope(Dependency dependency) {
        String scope = dependency.getScope();
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        return this.dependencyScopes.contains(scope);
    }

    public static DependencyDepth getEffectiveDepth(MavenRootDependency root, DependencyDepth dependencyDepth) {
        DependencyDepth depth = MavenDependencyCollector.isClassified(root) ? DependencyDepth.NONE : (dependencyDepth == DependencyDepth.NONE && TYPE_POM.equalsIgnoreCase(root.type()) ? DependencyDepth.DIRECT : dependencyDepth);
        return depth;
    }

    private static String getId(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier();
    }

    private static boolean isClassified(MavenRootDependency root) {
        String classifier = root.classifier();
        return classifier != null && !classifier.isBlank();
    }
}

