/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target.shared;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.model.Model;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;
import org.eclipse.m2e.pde.target.shared.WrappedBundle;

public class MavenBundleWrapper {
    private static final String ECLIPSE_SOURCE_BUNDLE_HEADER = "Eclipse-SourceBundle";
    private static final Pattern DASH = Pattern.compile("-");

    private MavenBundleWrapper() {
    }

    public static WrappedBundle getWrappedArtifact(Artifact artifact, Function<DependencyNode, Properties> instructionsLookup, List<RemoteRepository> repositories, RepositorySystem repoSystem, RepositorySystemSession repositorySession, SyncContextFactory syncContextFactory) throws Exception {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, null));
        collectRequest.setRepositories(repositories);
        DependencyNode node = repoSystem.collectDependencies(repositorySession, collectRequest).getRoot();
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setRoot(node);
        dependencyRequest.setFilter((node1, parents) -> {
            ArtifactRequest request = new ArtifactRequest();
            request.setRepositories(repositories);
            Artifact nodeArtifact = node1.getArtifact();
            request.setArtifact(nodeArtifact);
            try {
                repoSystem.resolveArtifact(repositorySession, request);
            }
            catch (ArtifactResolutionException e) {
                return false;
            }
            return true;
        });
        repoSystem.resolveDependencies(repositorySession, dependencyRequest);
        try (SyncContext syncContext = syncContextFactory.newInstance(repositorySession, false);){
            final HashSet lockList = new HashSet();
            node.accept(new DependencyVisitor(){

                public boolean visitLeave(DependencyNode n) {
                    return true;
                }

                public boolean visitEnter(DependencyNode n) {
                    lockList.add(n.getArtifact());
                    return true;
                }
            });
            syncContext.acquire(lockList, null);
            HashMap<DependencyNode, WrappedBundle> visited = new HashMap<DependencyNode, WrappedBundle>();
            WrappedBundle wrappedNode = MavenBundleWrapper.getWrappedNode(node, instructionsLookup, visited);
            for (WrappedBundle wrap : visited.values()) {
                wrap.getJar().ifPresent(jar -> jar.close());
            }
            WrappedBundle wrappedBundle = wrappedNode;
            return wrappedBundle;
        }
    }

    private static WrappedBundle getWrappedNode(DependencyNode node, Function<DependencyNode, Properties> instructionsLookup, Map<DependencyNode, WrappedBundle> visited) throws Exception {
        Jar jar;
        WrappedBundle wrappedNode = visited.get(node);
        if (wrappedNode != null) {
            return wrappedNode;
        }
        Artifact artifact = node.getArtifact();
        if (!"jar".equals(artifact.getExtension())) {
            wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.INFO, "Skip " + String.valueOf(node.getArtifact()) + " it is not a jar")));
            visited.put(node, wrappedNode);
            return wrappedNode;
        }
        File originalFile = artifact.getFile();
        if (originalFile == null) {
            if (node.getDependency().isOptional()) {
                wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, "Optional artifact " + String.valueOf(node.getArtifact()) + " was not found")));
                visited.put(node, wrappedNode);
            } else {
                wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.ERROR, "Artifact " + String.valueOf(node.getArtifact()) + " not found")));
                visited.put(node, wrappedNode);
            }
            return wrappedNode;
        }
        try {
            jar = new Jar(originalFile);
            if (jar.getDirectories().getOrDefault("META-INF/services", Collections.emptyMap()) == null) {
                jar.getDirectories().put("META-INF/services", new TreeMap());
            }
        }
        catch (IOException e) {
            wrappedNode = new WrappedBundle(node, List.of(), null, null, null, List.of(new ProcessingMessage(artifact, ProcessingMessage.Type.ERROR, "Artifact " + String.valueOf(node.getArtifact()) + " can not be read as a jar file")));
            visited.put(node, wrappedNode);
            return wrappedNode;
        }
        if (MavenBundleWrapper.isValidOSGi(jar.getManifest())) {
            wrappedNode = new WrappedBundle(node, List.of(), null, originalFile.toPath(), jar, List.of());
            visited.put(node, wrappedNode);
            return wrappedNode;
        }
        List children = node.getChildren();
        ArrayList<WrappedBundle> depends = new ArrayList<WrappedBundle>();
        for (DependencyNode child : children) {
            depends.add(MavenBundleWrapper.getWrappedNode(child, instructionsLookup, visited));
        }
        WrappedBundle wrappedNodeAfterVisit = visited.get(node);
        if (wrappedNodeAfterVisit != null) {
            return wrappedNodeAfterVisit;
        }
        Properties instructions = instructionsLookup.apply(node);
        String key = MavenBundleWrapper.getInstructionsKey(instructions, depends);
        try (Jar analyzerJar = jar;){
            File parent = new File(originalFile.getParent(), "bnd-" + key);
            File wrapArtifactFile = new File(parent, originalFile.getName());
            Jar cached = MavenBundleWrapper.getCachedJar(wrapArtifactFile.toPath(), originalFile.toPath());
            if (cached == null) {
                ArrayList<ProcessingMessage> messages = new ArrayList<ProcessingMessage>();
                wrapArtifactFile.getParentFile().mkdirs();
                boolean hasErrors = false;
                try (Builder analyzer = new Builder(new Processor()){};){
                    analyzer.setJar(analyzerJar);
                    analyzer.setProperty("mvnGroupId", artifact.getGroupId());
                    analyzer.setProperty("mvnArtifactId", artifact.getArtifactId());
                    analyzer.setProperty("mvnVersion", artifact.getBaseVersion());
                    analyzer.setProperty("mvnClassifier", artifact.getClassifier());
                    String versionString = MavenBundleWrapper.createOSGiVersion(artifact).toString();
                    analyzer.setProperty("generatedOSGiVersion", versionString);
                    for (String property : instructions.stringPropertyNames()) {
                        String trimValue = instructions.getProperty(property).trim();
                        analyzer.setProperty(property, trimValue);
                    }
                    for (WrappedBundle dep : depends) {
                        Jar depJar = dep.getJar().orElse(null);
                        if (depJar == null) {
                            messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, "Dependency " + String.valueOf(dep.getNode().getDependency()) + " was ignored!"));
                            continue;
                        }
                        analyzer.addClasspath(depJar);
                        analyzer.removeClose((AutoCloseable)depJar);
                    }
                    Manifest manifest = analyzer.calcManifest();
                    Map<String, Attributes> entries = manifest.getEntries();
                    if (entries != null) {
                        entries.clear();
                    }
                    analyzerJar.setManifest(manifest);
                    analyzerJar.write(wrapArtifactFile);
                    for (String err : analyzer.getErrors()) {
                        if (err.contains("Classes found in the wrong directory")) continue;
                        messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.ERROR, err));
                        hasErrors = true;
                    }
                    for (String warn : analyzer.getWarnings()) {
                        messages.add(new ProcessingMessage(artifact, ProcessingMessage.Type.WARN, warn));
                    }
                }
                if (hasErrors) {
                    Files.deleteIfExists(wrapArtifactFile.toPath());
                    wrappedNode = new WrappedBundle(node, depends, key, null, null, messages);
                    visited.put(node, wrappedNode);
                } else {
                    Files.setLastModifiedTime(wrapArtifactFile.toPath(), Files.getLastModifiedTime(originalFile.toPath(), new LinkOption[0]));
                    wrappedNode = new WrappedBundle(node, depends, key, wrapArtifactFile.toPath(), new Jar(wrapArtifactFile), messages);
                    visited.put(node, wrappedNode);
                }
            } else {
                wrappedNode = new WrappedBundle(node, depends, key, wrapArtifactFile.toPath(), new Jar(wrapArtifactFile), List.of());
                visited.put(node, wrappedNode);
            }
            WrappedBundle wrappedBundle = wrappedNode;
            return wrappedBundle;
        }
    }

    private static boolean isValidOSGi(Manifest originalManifest) {
        if (originalManifest == null) {
            return false;
        }
        Attributes attributes = originalManifest.getMainAttributes();
        String symbolicName = attributes.getValue("Bundle-SymbolicName");
        return symbolicName != null && !symbolicName.isBlank();
    }

    private static Jar getCachedJar(Path cacheFile, Path sourceFile) {
        try {
            if (!MavenBundleWrapper.isOutdated(cacheFile, sourceFile)) {
                return new Jar(cacheFile.toFile());
            }
        }
        catch (IOException e) {
            try {
                Platform.getLog(MavenBundleWrapper.class).error("Reading cached data for " + String.valueOf(cacheFile) + " failed, will regenerate the data ...", (Throwable)e);
            }
            catch (RuntimeException rte) {
                System.err.println("Reading cached data for " + String.valueOf(cacheFile) + " failed, will regenerate the data ...");
            }
        }
        return null;
    }

    private static String getInstructionsKey(Properties properties, List<WrappedBundle> depends) {
        Stream instructionsStream = properties == null ? Stream.empty() : properties.stringPropertyNames().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(key -> key.toLowerCase() + ":" + properties.getProperty((String)key));
        Stream<String> dependsStream = depends.stream().map(WrappedBundle::getInstructionsKey).filter(Objects::nonNull).sorted(String.CASE_INSENSITIVE_ORDER).distinct();
        String string = Stream.concat(instructionsStream, dependsStream).collect(Collectors.joining("#"));
        return DigestUtils.md5Hex((String)string);
    }

    public static Version createOSGiVersion(Artifact artifact) {
        String version = artifact.getVersion();
        return MavenBundleWrapper.createOSGiVersion(version);
    }

    public static Version createOSGiVersion(Model model) {
        return MavenBundleWrapper.createOSGiVersion(model.getVersion());
    }

    public static Version createOSGiVersion(String version) {
        if (version == null || version.isEmpty()) {
            return new Version(0, 0, 1);
        }
        try {
            version = DASH.matcher(version).replaceFirst(".");
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            return new Version(0, 0, 1, version);
        }
    }

    public static boolean isOutdated(Path cacheFile, Path sourceFile) throws IOException {
        if (Files.exists(cacheFile, new LinkOption[0])) {
            FileTime sourceTimeStamp = Files.getLastModifiedTime(sourceFile, new LinkOption[0]);
            FileTime cacheTimeStamp = Files.getLastModifiedTime(cacheFile, new LinkOption[0]);
            return sourceTimeStamp.toMillis() > cacheTimeStamp.toMillis();
        }
        return true;
    }

    private static boolean isExcludedFromWrapping(String name) {
        return name.equals("META-INF/MANIFEST.MF") || name.startsWith("META-INF/SIG-") || name.startsWith("META-INF/") && (name.endsWith(".SF") || name.endsWith(".RSA") || name.endsWith(".DSA"));
    }

    public static void addSourceBundleMetadata(Manifest manifest, String symbolicName, String version) {
        Attributes attr = manifest.getMainAttributes();
        if (attr.isEmpty()) {
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        attr.putValue(ECLIPSE_SOURCE_BUNDLE_HEADER, symbolicName + ";version=\"" + version + "\";roots:=\".\"");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Name", "Source Bundle for " + symbolicName + ":" + version);
        attr.putValue("Bundle-SymbolicName", MavenBundleWrapper.getSourceBundleName(symbolicName));
        attr.putValue("Bundle-Version", version);
    }

    public static String getSourceBundleName(String symbolicName) {
        return symbolicName + ".source";
    }

    public static void transferJarEntries(File source, Manifest manifest, File target) throws IOException {
        Map<String, Attributes> manifestEntries = manifest.getEntries();
        if (manifestEntries != null) {
            manifestEntries.clear();
        }
        try (JarOutputStream output = new JarOutputStream((OutputStream)new FileOutputStream(target), manifest);
             JarInputStream input = new JarInputStream(new FileInputStream(source));){
            JarEntry entry;
            while ((entry = input.getNextJarEntry()) != null) {
                if (MavenBundleWrapper.isExcludedFromWrapping(entry.getName())) continue;
                output.putNextEntry(new ZipEntry(entry.getName()));
                input.transferTo(output);
            }
        }
    }

    public static boolean isValidSourceManifest(Manifest manifest) {
        return manifest != null && manifest.getMainAttributes().getValue(ECLIPSE_SOURCE_BUNDLE_HEADER) != null;
    }
}

