/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.cleancode.QuickFix;
import org.eclipse.tycho.cleancode.QuickFixResult;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuildMojo;

@Mojo(name="quickfix", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class QuickFixMojo
extends AbstractEclipseBuildMojo<QuickFixResult> {
    @Parameter(defaultValue="${project.build.directory}/quickfix.md", property="tycho.quickfix.report")
    private File reportFileName;
    @Parameter
    private List<String> quickfixes;

    protected void handleResult(QuickFixResult result) throws MojoFailureException {
        if (result.isEmpty()) {
            return;
        }
        MarkdownBuilder builder = new MarkdownBuilder(this.reportFileName);
        List<String> fixes = result.fixes().toList();
        builder.h3("The following " + (fixes.size() > 0 ? "warnings" : "warning") + " has been resolved:");
        fixes.forEach(fix -> {
            builder.addListItem(fix);
            this.getLog().info((CharSequence)("QuickFix: " + fix));
        });
        builder.newLine();
        builder.newLine();
        builder.write();
    }

    protected String[] getRequireBundles() {
        Stream.Builder<String> builder = Stream.builder();
        builder.accept("org.eclipse.ui.ide");
        if (this.quickfixes != null) {
            this.quickfixes.forEach(builder);
        }
        return (String[])builder.build().toArray(String[]::new);
    }

    protected QuickFix createExecutable() {
        return new QuickFix(this.project.getBasedir().toPath(), this.debug);
    }

    protected String getName() {
        return "Quick Fix";
    }
}

