/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tycho.cleancode.QuickFixResult;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionRelevance;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class QuickFix
extends AbstractEclipseBuild<QuickFixResult> {
    QuickFix(Path projectDir, boolean debug) {
        super(projectDir, debug);
    }

    protected QuickFixResult createResult(IProject project) throws Exception {
        QuickFixResult result = new QuickFixResult();
        while (this.fixOneMarker(project, result)) {
            QuickFix.runInUI("Save Editors", m -> {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().saveAllEditors(false);
                }
            });
            this.debug("### Perform build to update markers ###");
            this.buildProject(project);
        }
        return result;
    }

    private boolean fixOneMarker(IProject project, QuickFixResult result) throws CoreException {
        IMarker[] markers;
        this.debug("### Check for marker with resolutions...");
        for (IMarker marker : markers = this.getCurrentMarker(project, true)) {
            if (!result.tryFix(marker)) continue;
            this.debug("Check Marker: " + this.getInfo(marker));
            try {
                IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                this.debug("\tMarker has " + resolutions.length + " resolutions");
                IMarkerResolution resolution = Arrays.stream(resolutions).max(Comparator.comparingInt(r -> this.getRelevance((IMarkerResolution)r))).orElse(null);
                if (resolution == null) continue;
                for (IMarkerResolution r2 : resolutions) {
                    this.debug(String.format("\t\t- (%d): %s", this.getRelevance(r2), this.getInfo(r2, false)));
                }
                LinkedHashSet jobs = new LinkedHashSet();
                IStatus status = QuickFix.runInUI("fix marker " + this.getInfo(marker), m -> AbstractEclipseBuild.recordJobs((Set)jobs, (IProgressMonitor)m, nil -> {
                    this.debug("\tApply best resolution to marker: " + this.getInfo(resolution, true));
                    resolution.run(marker);
                }));
                for (Job job : jobs) {
                    this.debug("Wait for Job '" + job.getName() + "' scheduled during marker resolution...");
                    job.join();
                }
                if (status.isOK()) {
                    String fix = this.buildFixMessage(marker);
                    this.debug("\t" + fix);
                    result.addFix(fix);
                    return true;
                }
                this.debug("\tMarker could not be applied!", status.getException());
            }
            catch (Throwable t) {
                this.debug("\tMarker resolutions could not be computed!", t);
            }
        }
        return false;
    }

    private String getInfo(IMarker marker) {
        return marker.getAttribute("message", "") + " @ " + String.valueOf(marker.getResource()) + ":" + marker.getAttribute("lineNumber", -1);
    }

    private IMarker[] getCurrentMarker(IProject project, boolean rebuildOnError) throws CoreException {
        IMarker[] markers;
        for (IMarker marker : markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)) {
            if (marker.getAttribute("severity", -1) != 2) continue;
            if (rebuildOnError) {
                this.debug("Found error marker, try rebuild ...");
                this.buildProject(project);
                return this.getCurrentMarker(project, false);
            }
            this.debug("Found error, can't apply fixes: " + this.getInfo(marker));
            return new IMarker[0];
        }
        return markers;
    }

    private String buildFixMessage(IMarker marker) {
        StringBuilder sb = new StringBuilder(marker.getAttribute("message", "Unknown Problem"));
        IResource resource = marker.getResource();
        if (resource != null) {
            sb.append(" in ");
            sb.append(resource.getFullPath());
            int line = marker.getAttribute("lineNumber", -1);
            if (line > 0) {
                sb.append(" at line ");
                sb.append(line);
            }
        }
        return sb.toString();
    }

    private String getInfo(IMarkerResolution resolution, boolean withDescription) {
        if (withDescription && resolution instanceof IMarkerResolution2) {
            IMarkerResolution2 res2 = (IMarkerResolution2)resolution;
            return resolution.getClass().getName() + ": " + this.getLabel(resolution) + " // " + this.getDescription(res2);
        }
        return resolution.getClass().getName() + ": " + this.getLabel(resolution);
    }

    private int getRelevance(IMarkerResolution resolution) {
        try {
            if (resolution instanceof IMarkerResolutionRelevance) {
                IMarkerResolutionRelevance relevance = (IMarkerResolutionRelevance)resolution;
                return relevance.getRelevanceForResolution();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return 0;
    }

    private String getDescription(IMarkerResolution2 markerResolution) {
        try {
            return markerResolution.getDescription();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getLabel(IMarkerResolution resolution) {
        try {
            return resolution.getLabel();
        }
        catch (RuntimeException e) {
            return resolution.getClass().getName();
        }
    }

    private static IStatus runInUI(String action, ICoreRunnable runnable) throws InterruptedException {
        UIJob job = UIJob.create((String)action, m -> {
            try {
                runnable.run(m);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            catch (Throwable e) {
                return Status.error((String)"Run failed", (Throwable)e);
            }
            return Status.OK_STATUS;
        });
        job.schedule();
        job.join();
        return job.getResult();
    }
}

