/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.cleancode.OrganizeManifest;
import org.eclipse.tycho.cleancode.OrganizeManifestResult;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuildMojo;

@Mojo(name="manifest", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class OrganizeManifestMojo
extends AbstractEclipseBuildMojo<OrganizeManifestResult> {
    @Parameter(defaultValue="${project.build.directory}/organizeManifest.md", property="tycho.organizeManifest.report")
    private File reportFileName;
    @Parameter(property="organizeManifest.calculateUses")
    private boolean calculateUses;
    @Parameter(property="organizeManifest.removeUnusedDependencies")
    private boolean removeUnusedDependencies;
    @Parameter(property="organizeManifest.removeUnusedKeys")
    private boolean removeUnusedKeys;

    protected void handleResult(OrganizeManifestResult result) throws MojoFailureException {
        MarkdownBuilder builder = new MarkdownBuilder(this.reportFileName);
        builder.h3("The following Manifest cleanups where applied:");
        if (this.calculateUses) {
            builder.addListItem("Calculate 'uses' directive for public packages");
        }
        if (this.removeUnusedDependencies) {
            builder.addListItem("Remove unused dependencies");
        }
        if (this.removeUnusedKeys) {
            builder.addListItem("Remove unused <bundle-localization>.properties keys");
        }
        builder.newLine();
        builder.newLine();
        builder.write();
    }

    protected OrganizeManifest createExecutable() {
        OrganizeManifest manifest = new OrganizeManifest(this.project.getBasedir().toPath(), this.debug);
        if (this.calculateUses) {
            this.getLog().info((CharSequence)"Organize Manifest: Calculate 'uses' directive for public packages");
        }
        if (this.removeUnusedDependencies) {
            this.getLog().info((CharSequence)"Organize Manifest: Remove unused dependencies");
        }
        if (this.removeUnusedKeys) {
            this.getLog().info((CharSequence)"Organize Manifest: Remove unused <bundle-localization>.properties keys");
        }
        manifest.setCalculateUses(this.calculateUses);
        manifest.setUnusedDependencies(this.removeUnusedDependencies);
        manifest.setUnusedKeys(this.removeUnusedKeys);
        return manifest;
    }

    protected String getName() {
        return "Organize Manifest";
    }

    protected String[] getRequireBundles() {
        return new String[]{"org.eclipse.pde.ui"};
    }
}

