/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor;
import org.eclipse.tycho.cleancode.OrganizeManifestResult;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;

public class OrganizeManifest
extends AbstractEclipseBuild<OrganizeManifestResult> {
    private boolean addMissing;
    private boolean markInternal;
    private String packageFilter;
    private boolean removeUnresolved;
    private boolean calculateUses;
    private boolean modifyDep;
    private boolean removeDependencies;
    private boolean unusedDependencies;
    private boolean removeLazy;
    private boolean removeUselessFiles;
    private boolean prefixIconNL;
    private boolean unusedKeys;
    private boolean addDependencies;
    private boolean computeImports;
    private static final long serialVersionUID = 1L;

    OrganizeManifest(Path projectDir, boolean debug) {
        super(projectDir, debug);
    }

    protected OrganizeManifestResult createResult(IProject project) throws Exception {
        OrganizeManifestsProcessor processor = new OrganizeManifestsProcessor(List.of(project));
        processor.setAddMissing(this.addMissing);
        processor.setMarkInternal(this.markInternal);
        processor.setPackageFilter(this.packageFilter);
        processor.setRemoveUnresolved(this.removeUnresolved);
        processor.setCalculateUses(this.calculateUses);
        processor.setModifyDep(this.modifyDep);
        processor.setRemoveDependencies(this.removeDependencies);
        processor.setUnusedDependencies(this.unusedDependencies);
        processor.setRemoveLazy(this.removeLazy);
        processor.setRemoveUselessFiles(this.removeUselessFiles);
        processor.setPrefixIconNL(this.prefixIconNL);
        processor.setUnusedKeys(this.unusedKeys);
        processor.setAddDependencies(this.addDependencies);
        processor.setComputeImports(this.computeImports);
        PDERefactor refactor = new PDERefactor((RefactoringProcessor)processor);
        RefactoringStatus status = refactor.checkAllConditions((IProgressMonitor)this);
        if (status.isOK()) {
            Change change = refactor.createChange((IProgressMonitor)this);
            change.initializeValidationData((IProgressMonitor)this);
            PerformChangeOperation performChangeOperation = new PerformChangeOperation(change);
            performChangeOperation.run((IProgressMonitor)this);
        } else if (status.hasError()) {
            throw new RuntimeException("Organize failed: " + String.valueOf(status));
        }
        return new OrganizeManifestResult();
    }

    void setAddMissing(boolean addMissing) {
        this.addMissing = addMissing;
    }

    void setMarkInternal(boolean markInternal) {
        this.markInternal = markInternal;
    }

    void setPackageFilter(String packageFilter) {
        this.packageFilter = packageFilter;
    }

    void setRemoveUnresolved(boolean removeUnresolved) {
        this.removeUnresolved = removeUnresolved;
    }

    void setCalculateUses(boolean calculateUses) {
        this.calculateUses = calculateUses;
    }

    void setModifyDep(boolean modifyDep) {
        this.modifyDep = modifyDep;
    }

    void setRemoveDependencies(boolean removeDependencies) {
        this.removeDependencies = removeDependencies;
    }

    void setUnusedDependencies(boolean unusedDependencies) {
        this.unusedDependencies = unusedDependencies;
    }

    void setRemoveLazy(boolean removeLazy) {
        this.removeLazy = removeLazy;
    }

    void setRemoveUselessFiles(boolean removeUselessFiles) {
        this.removeUselessFiles = removeUselessFiles;
    }

    void setPrefixIconNL(boolean prefixIconNL) {
        this.prefixIconNL = prefixIconNL;
    }

    void setUnusedKeys(boolean unusedKeys) {
        this.unusedKeys = unusedKeys;
    }

    void setAddDependencies(boolean addDependencies) {
        this.addDependencies = addDependencies;
    }

    void setComputeImports(boolean computeImports) {
        this.computeImports = computeImports;
    }
}

