/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CleanupPreferencesUpdater
implements AutoCloseable {
    private Path prefsFile;
    private boolean updated = false;
    private List<String> lines;
    private Map<String, String> cleanUpProfile;

    public CleanupPreferencesUpdater(Path prefsFile, Map<String, String> cleanUpProfile) throws IOException {
        this.prefsFile = prefsFile;
        this.cleanUpProfile = cleanUpProfile;
        this.lines = Files.readAllLines(prefsFile, StandardCharsets.UTF_8);
    }

    public synchronized void updateProjectCleanupProfile() {
        List<String> newLines = this.updateProjectSettingsFile(null, this.lines);
        if (!newLines.equals(this.lines)) {
            this.updated = true;
            this.lines = newLines;
        }
    }

    public synchronized void updateSaveActions() {
        List<String> newLines = this.updateProjectSettingsFile("sp_", this.lines);
        if (!newLines.equals(this.lines)) {
            this.updated = true;
            this.lines = newLines;
        }
    }

    public synchronized boolean hasCleanupProfile() {
        for (String line : this.lines) {
            KV kv = CleanupPreferencesUpdater.parseLine(line);
            if (!kv.key().equals("cleanup_profile")) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasSaveActions() {
        for (String line : this.lines) {
            KV kv = CleanupPreferencesUpdater.parseLine(line);
            if (!kv.key().equals("sp_cleanup.on_save_use_additional_actions")) continue;
            return Boolean.parseBoolean(kv.value());
        }
        return false;
    }

    private List<String> updateProjectSettingsFile(String prefix, List<String> lines) {
        ArrayList<String> updatedLines = new ArrayList<String>();
        HashSet<String> missingKeys = new HashSet<String>(this.cleanUpProfile.keySet());
        for (String line : lines) {
            KV kv = CleanupPreferencesUpdater.parseLine(line);
            if (!kv.matches(prefix)) {
                updatedLines.add(line);
                continue;
            }
            String key = kv.key(prefix);
            if (missingKeys.remove(key)) {
                updatedLines.add(kv.key() + "=" + this.cleanUpProfile.get(key));
                continue;
            }
            updatedLines.add(line);
        }
        for (String key : missingKeys) {
            String prefixed = prefix == null ? key : prefix + key;
            updatedLines.add(prefixed + "=" + this.cleanUpProfile.get(key));
        }
        return updatedLines;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.updated) {
            Files.write(this.prefsFile, this.lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static KV parseLine(String line) {
        String[] kv = line.split("=", 2);
        if (kv.length != 2) {
            return new KV(line, null);
        }
        return new KV(kv[0], kv[1]);
    }

    private record KV(String key, String value) {
        public boolean matches(String prefix) {
            if (this.value == null) {
                return false;
            }
            if (prefix != null && !this.key.startsWith(prefix)) {
                return false;
            }
            return this.key(prefix).startsWith("cleanup.");
        }

        public String key(String prefix) {
            if (prefix == null || !this.key.startsWith(prefix)) {
                return this.key;
            }
            return this.key.substring(prefix.length());
        }
    }
}

