/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.tycho.cleancode.CleanUp;
import org.eclipse.tycho.cleancode.CleanupPreferencesUpdater;
import org.eclipse.tycho.cleancode.CleanupResult;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuildMojo;
import org.eclipse.tycho.model.project.EclipseProject;

@Mojo(name="cleanup", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CleanUpMojo
extends AbstractEclipseBuildMojo<CleanupResult> {
    @Parameter(defaultValue="${project.build.directory}/cleanups.md", property="tycho.cleanup.report")
    private File reportFileName;
    @Parameter
    private Map<String, String> cleanUpProfile;
    @Parameter
    private boolean applyCleanupsIndividually;
    @Parameter
    private List<String> ignores;
    @Parameter(property="updateProjectCleanupProfile")
    private boolean updateProjectCleanupProfile;
    @Parameter(property="updateProjectSaveActions")
    private boolean updateProjectSaveActions;

    protected String[] getRequireBundles() {
        return new String[]{"org.eclipse.jdt.ui"};
    }

    protected String getName() {
        return "Perform Cleanup";
    }

    protected CleanUp createExecutable() {
        return new CleanUp(this.project.getBasedir().toPath(), this.debug, this.cleanUpProfile, this.applyCleanupsIndividually, this.getIgnores());
    }

    private List<Pattern> getIgnores() {
        if (this.ignores == null || this.ignores.isEmpty()) {
            return null;
        }
        return this.ignores.stream().map(Pattern::compile).toList();
    }

    protected void handleResult(CleanupResult result) throws MojoFailureException {
        block16: {
            if (result.isEmpty()) {
                return;
            }
            MarkdownBuilder builder = new MarkdownBuilder(this.reportFileName);
            builder.h3("The following cleanups were applied:");
            result.cleanups().forEach(cleanup -> {
                builder.addListItem(cleanup);
                this.getLog().info((CharSequence)("Applied cleanup: " + cleanup));
            });
            builder.newLine();
            builder.newLine();
            builder.write();
            if (this.updateProjectCleanupProfile || this.updateProjectSaveActions) {
                Path settingsDir = this.project.getBasedir().toPath().resolve(".settings");
                Path prefsFile = settingsDir.resolve("org.eclipse.jdt.ui.prefs");
                try {
                    if (Files.isRegularFile(prefsFile, new LinkOption[0])) {
                        try (CleanupPreferencesUpdater updater = new CleanupPreferencesUpdater(prefsFile, this.cleanUpProfile);){
                            if (this.updateProjectCleanupProfile) {
                                if (updater.hasCleanupProfile()) {
                                    updater.updateProjectCleanupProfile();
                                    this.getLog().info((CharSequence)"Updated cleanup profile settings in project preferences");
                                } else {
                                    this.getLog().info((CharSequence)"Project preferences do not specify a cleanup profile, skipping profile update");
                                }
                            }
                            if (this.updateProjectSaveActions) {
                                if (updater.hasSaveActions()) {
                                    updater.updateSaveActions();
                                    this.getLog().info((CharSequence)"Updated save action settings in project preferences");
                                } else {
                                    this.getLog().info((CharSequence)"Project has disabled additional save actions, skipping save action update");
                                }
                            }
                            break block16;
                        }
                    }
                    this.getLog().info((CharSequence)"Project preferences file not found, skipping settings update");
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Failed to update project preferences", (Throwable)e);
                }
            }
        }
    }

    protected boolean isValid(EclipseProject eclipseProject) {
        return eclipseProject.hasNature("org.eclipse.jdt.core.javanature");
    }
}

