/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.cleancode;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.tycho.cleancode.CleanupResult;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;

public class CleanUp
extends AbstractEclipseBuild<CleanupResult> {
    private Map<String, String> customProfile;
    private boolean applyCleanupsIndividually;
    private List<Pattern> ignores;

    CleanUp(Path projectDir, boolean debug, Map<String, String> customProfile, boolean applyCleanupsIndividually, List<Pattern> ignores) {
        super(projectDir, debug);
        this.customProfile = customProfile;
        this.applyCleanupsIndividually = applyCleanupsIndividually;
        this.ignores = ignores;
    }

    protected CleanupResult createResult(IProject project) throws Exception {
        CleanupResult result = new CleanupResult();
        CleanUpOptions options = this.getOptions(project);
        ICleanUp[] cleanups = this.getCleanups(result, options);
        if (cleanups.length > 0) {
            List<ICompilationUnit> units = this.getCompilationUnits(project);
            if (this.applyCleanupsIndividually) {
                for (ICleanUp cleanUp : cleanups) {
                    this.applyCleanups(project, new ICleanUp[]{cleanUp}, units);
                }
            } else {
                this.applyCleanups(project, cleanups, units);
            }
        }
        this.buildProject(project);
        return result;
    }

    private void applyCleanups(IProject project, ICleanUp[] cleanups, List<ICompilationUnit> units) throws CoreException {
        CleanUpRefactoring refactoring = new CleanUpRefactoring(project.getName());
        for (ICompilationUnit cu : units) {
            refactoring.addCompilationUnit(cu);
        }
        refactoring.setUseOptionsFromProfile(false);
        for (ICleanUp cleanUp : cleanups) {
            refactoring.addCleanUp(cleanUp);
        }
        RefactoringStatus status = refactoring.checkAllConditions((IProgressMonitor)this);
        if (status.isOK()) {
            Change change = refactoring.createChange((IProgressMonitor)this);
            change.initializeValidationData((IProgressMonitor)this);
            PerformChangeOperation performChangeOperation = new PerformChangeOperation(change);
            performChangeOperation.run((IProgressMonitor)this);
        } else if (status.hasError()) {
            throw new RuntimeException("Refactoring failed: " + String.valueOf(status));
        }
    }

    private List<ICompilationUnit> getCompilationUnits(IProject project) throws JavaModelException {
        IPackageFragmentRoot[] packages;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
        for (IPackageFragmentRoot root : packages = javaProject.getPackageFragmentRoots()) {
            if (root.getKind() != 1) continue;
            for (IJavaElement javaElement : root.getChildren()) {
                ICompilationUnit[] compilationUnits;
                if (javaElement.getElementType() != 4) continue;
                IPackageFragment pf = (IPackageFragment)javaElement;
                for (ICompilationUnit compilationUnit : compilationUnits = pf.getCompilationUnits()) {
                    if (this.isIgnored(compilationUnit)) continue;
                    units.add(compilationUnit);
                }
            }
        }
        return units;
    }

    private boolean isIgnored(ICompilationUnit compilationUnit) {
        if (this.ignores == null || this.ignores.isEmpty()) {
            return false;
        }
        IProject project = compilationUnit.getJavaProject().getProject();
        IPath location = project.getFullPath();
        IPath path = compilationUnit.getPath().makeRelativeTo(location);
        String pathString = path.toString();
        for (Pattern ignored : this.ignores) {
            if (!ignored.matcher(pathString).matches()) continue;
            return true;
        }
        return false;
    }

    private ICleanUp[] getCleanups(CleanupResult result, CleanUpOptions options) {
        ICleanUp[] cleanUps;
        for (ICleanUp cleanUp : cleanUps = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps()) {
            try {
                cleanUp.setOptions(options);
                String[] descriptions = cleanUp.getStepDescriptions();
                if (descriptions == null) continue;
                for (String description : descriptions) {
                    result.addCleanup(description);
                }
            }
            catch (Exception e) {
                this.debug("Ignore cleanup '" + String.valueOf(cleanUp) + "' because of initialization error.", e);
            }
        }
        return cleanUps;
    }

    private CleanUpOptions getOptions(IProject project) {
        Map<String, String> options = this.customProfile == null || this.customProfile.isEmpty() ? CleanUpPreferenceUtil.loadOptions((IScopeContext)new ProjectScope(project)) : this.customProfile;
        this.debug("Cleanup Profile: " + options.entrySet().stream().map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining(System.lineSeparator())));
        return new MapCleanUpOptions(options);
    }
}

