/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.util.internal.TestClassMethodNameUtils;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

final class JUnitCoreRunListener
extends JUnit4RunListener {
    private final Map<String, TestSet> classMethodCounts;

    JUnitCoreRunListener(ConcurrentRunListener reporter, Map<String, TestSet> classMethodCounts) {
        super(reporter);
        this.classMethodCounts = classMethodCounts;
    }

    public void testRunStarted(Description description) throws Exception {
        this.fillTestCountMap(description);
        this.reporter.testSetStarting(null);
    }

    public void testRunFinished(Result result) throws Exception {
        try {
            this.reporter.testSetCompleted(null);
        }
        finally {
            this.classMethodCounts.clear();
        }
    }

    private void fillTestCountMap(Description testDesc) {
        for (Description child : testDesc.getChildren()) {
            if (this.asTestLeaf(child)) continue;
            this.fillTestCountMap(child);
        }
    }

    private boolean asTestLeaf(Description description) {
        if (description.isTest()) {
            String testClassName = TestClassMethodNameUtils.extractClassName((String)description.getDisplayName());
            if (testClassName != null) {
                TestSet testSet;
                if (this.classMethodCounts.containsKey(testClassName)) {
                    testSet = this.classMethodCounts.get(testClassName);
                } else {
                    testSet = new TestSet(testClassName, this.getRunMode(), this.classMethodIndexer);
                    this.classMethodCounts.put(testClassName, testSet);
                }
                testSet.incrementTestMethodCount();
            }
            return true;
        }
        return false;
    }

    @Override
    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }
}

