/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle.runner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.schema.PathSchemaProvider;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaProvider;
import org.eclipse.tycho.extras.docbundle.runner.ConvertSchemaToHtmlResult;
import org.xml.sax.helpers.DefaultHandler;

public class ConvertSchemaToHtmlRunner
implements Callable<ConvertSchemaToHtmlResult>,
Serializable {
    private List<File> manifests;
    private File destination;
    private URL cssURL;
    private List<String> additionalSearchPaths;
    private File baseDir;

    public ConvertSchemaToHtmlRunner(List<File> manifests, File destination, URL cssURL, List<String> additionalSearchPaths, File baseDir) {
        this.manifests = manifests;
        this.destination = destination;
        this.cssURL = cssURL;
        this.additionalSearchPaths = additionalSearchPaths;
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConvertSchemaToHtmlResult call() throws Exception {
        SchemaTransformer fTransformer = new SchemaTransformer();
        ConvertSchemaToHtmlResult result = new ConvertSchemaToHtmlResult();
        for (File manifest : this.manifests) {
            IPluginExtensionPoint[] extPoints;
            IPluginModelBase model = this.readManifestFile(manifest);
            if (model == null) {
                return result;
            }
            String pluginID = model.getPluginBase().getId();
            if (pluginID == null) {
                pluginID = this.getPluginID(manifest);
            }
            for (IPluginExtensionPoint extPoint : extPoints = model.getPluginBase().getExtensionPoints()) {
                final String schemaLocation = extPoint.getSchema();
                if (schemaLocation == null || schemaLocation.equals("")) continue;
                Schema schema = null;
                try {
                    ISchemaInclude[] includes;
                    File schemaFile = new File(model.getInstallLocation(), schemaLocation);
                    XMLDefaultHandler handler = new XMLDefaultHandler();
                    XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE().parse(schemaFile, (DefaultHandler)handler);
                    URL url = schemaFile.toURL();
                    final PathSchemaProvider pathSchemaProvider = new PathSchemaProvider(this.additionalSearchPaths.stream().map(pathString -> {
                        IPath path = IPath.fromOSString((String)pathString);
                        if (!path.isAbsolute()) {
                            return IPath.fromOSString((String)this.baseDir.getPath()).append(path);
                        }
                        return path;
                    }).toList());
                    SchemaDescriptor desc = new SchemaDescriptor(extPoint.getFullId(), url, new SchemaProvider(){

                        public ISchema createSchema(ISchemaDescriptor descriptor, String location) {
                            return pathSchemaProvider.createSchema(descriptor, schemaLocation);
                        }
                    });
                    schema = (Schema)desc.getSchema(false);
                    for (ISchemaInclude include : includes = schema.getIncludes()) {
                        ISchema includedSchema = include.getIncludedSchema();
                        if (includedSchema != null) continue;
                        result.addError(NLS.bind((String)PDECoreMessages.ConvertSchemaToHTML_CannotFindIncludedSchema, (Object)include.getLocation(), (Object)schemaFile));
                    }
                    File directory = this.destination;
                    if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                        schema.dispose();
                        ConvertSchemaToHtmlResult convertSchemaToHtmlResult = result;
                        return convertSchemaToHtmlResult;
                    }
                    Object id = extPoint.getId();
                    if (((String)id).indexOf(46) == -1) {
                        id = pluginID + "." + (String)id;
                    }
                    File file = new File(directory, ((String)id).replace('.', '_') + ".html");
                    try (PrintWriter out = new PrintWriter((Writer)Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]), true);){
                        fTransformer.transform((ISchema)schema, out, this.cssURL, (byte)1);
                    }
                }
                finally {
                    if (schema != null) {
                        schema.dispose();
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPluginID(File manifest) {
        File OSGiFile = new File(manifest.getParentFile(), "META-INF/MANIFEST.MF");
        if (!OSGiFile.exists()) return null;
        try (FileInputStream manifestStream = new FileInputStream(OSGiFile);){
            Map headers = ManifestElement.parseBundleManifest((InputStream)manifestStream, new HashMap());
            String value = (String)headers.get("Bundle-SymbolicName");
            if (value == null) {
                String string = null;
                return string;
            }
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
            if (elements.length <= 0) return null;
            String string = elements[0].getValue();
            return string;
        }
        catch (Exception e1) {
            System.out.print(e1.getMessage());
        }
        return null;
    }

    private IPluginModelBase readManifestFile(File manifest) throws IOException, CoreException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(manifest));){
            ExternalFragmentModel model = null;
            switch (manifest.getName().toLowerCase(Locale.ENGLISH)) {
                case "fragment.xml": {
                    model = new ExternalFragmentModel();
                    break;
                }
                case "plugin.xml": {
                    model = new ExternalPluginModel();
                    break;
                }
                default: {
                    ((InputStream)stream).close();
                    throw new IOException(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"manifest"));
                }
            }
            String parentPath = manifest.getParentFile().getAbsolutePath();
            model.setInstallLocation(parentPath);
            model.load((InputStream)stream, false);
            ((InputStream)stream).close();
            ExternalFragmentModel externalFragmentModel = model;
            return externalFragmentModel;
        }
    }
}

