/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.tycho.extras.docbundle.TocOptions;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class TocWriter {
    private TocOptions options;
    private File javadocDir;
    private File basedir;
    private Log log;

    public void setLog(Log log) {
        this.log = log;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setJavadocDir(File javadocDir) {
        this.javadocDir = javadocDir;
    }

    public void setOptions(TocOptions options) {
        this.options = options;
        if (this.options == null) {
            this.options = new TocOptions();
        }
    }

    public void writeTo(File tocFile) throws MojoExecutionException {
        if (tocFile == null) {
            return;
        }
        try {
            this.process(tocFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate toc file", e);
        }
    }

    private void process(File tocFile) throws ParserConfigurationException, DOMException, IOException, TransformerException {
        tocFile.getParentFile().mkdirs();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        this.fillDocument(doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(tocFile);
        transformer.transform(source, result);
    }

    private void fillDocument(Document doc) throws DOMException, IOException {
        ProcessingInstruction pi = doc.createProcessingInstruction("NLS", "TYPE=\"org.eclipse.help.toc\"");
        doc.appendChild(pi);
        Element toc = doc.createElement("toc");
        doc.appendChild(toc);
        toc.setAttribute("label", this.options.getMainLabel());
        Element main = this.createTopic(doc, toc, this.options.getMainLabel(), this.options.getMainFilename());
        Element packages = this.createTopic(doc, main, "Packages", null);
        this.createTopic(doc, main, "Constant Values", "constant-values.html");
        this.createTopic(doc, main, "Deprecated List", "deprecated-list.html");
        File packageList = new File(this.javadocDir, "package-list");
        if (!packageList.exists()) {
            packageList = new File(this.javadocDir, "element-list");
        }
        try (LineNumberReader reader = new LineNumberReader(new FileReader(packageList));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.createTopic(doc, packages, line, line.replace('.', '/') + "/package-summary.html");
            }
        }
    }

    private Element createTopic(Document doc, Element parent, String label, String fileName) throws DOMException, IOException {
        Element topic = doc.createElement("topic");
        parent.appendChild(topic);
        topic.setAttribute("label", label);
        if (fileName != null) {
            topic.setAttribute("href", this.makeRelative(this.basedir, new File(this.javadocDir.toString(), fileName)));
        }
        return topic;
    }

    private String makeRelative(File base, File file) throws IOException {
        String result = base.getCanonicalFile().toURI().relativize(file.getCanonicalFile().toURI()).getPath();
        this.log.info((CharSequence)String.format("Make relative - base: %s, file: %s -> %s", base, file, result));
        return result;
    }
}

