/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PackageNameMatcher {
    private final List<Pattern> patterns;
    private final String description;

    public static PackageNameMatcher compile(List<String> specs) {
        if (specs == null) {
            throw new IllegalArgumentException("null package name specifications");
        }
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (String part : specs) {
            list.add(PackageNameMatcher.buildPattern(part));
        }
        return new PackageNameMatcher(list);
    }

    private static Pattern buildPattern(String spec) {
        if (spec.isEmpty()) {
            throw new IllegalArgumentException("empty package name");
        }
        StringBuilder regex = new StringBuilder();
        for (int idx = 0; idx < spec.length(); ++idx) {
            char ch = spec.charAt(idx);
            if (ch == '*') {
                regex.append(".*");
                continue;
            }
            if (ch == '.') {
                regex.append("\\.");
                continue;
            }
            if (idx == 0 && !Character.isJavaIdentifierStart(ch)) {
                throw new IllegalArgumentException("invalid package name: " + spec);
            }
            if (!Character.isJavaIdentifierPart(ch)) {
                throw new IllegalArgumentException("invalid package name: " + spec);
            }
            regex.append(ch);
        }
        try {
            return Pattern.compile(regex.toString());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("invalid package specification: " + spec, e);
        }
    }

    private PackageNameMatcher(List<Pattern> patterns) {
        this.patterns = patterns;
        this.description = this.buildDescription();
    }

    private String buildDescription() {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this.patterns.size(); ++idx) {
            sb.append('\"').append(this.patterns.get(idx).pattern()).append('\"');
            if (idx >= this.patterns.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public boolean matches(String packageName) {
        if (packageName.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(packageName).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.description);
    }
}

