/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.build.BuildListener;
import org.eclipse.tycho.core.maven.MavenDependencyInjector;
import org.eclipse.tycho.extras.docbundle.ConfigureMojo;
import org.eclipse.tycho.helper.PluginConfigurationHelper;
import org.eclipse.tycho.helper.ProjectHelper;

@Component(role=BuildListener.class, hint="javadoc")
public class JavadocBuildListener
implements BuildListener {
    private static final String JAVADOC_GOAL = "javadoc";
    private static final String ARTIFACT_ID = "maven-javadoc-plugin";
    private static final String GROUP_ID = "org.apache.maven.plugins";
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private PluginConfigurationHelper configurationHelper;

    public void buildStarted(MavenSession session) {
        List projects = session.getProjects();
        for (MavenProject project : projects) {
            if (!this.isJavadocProject(project, session)) continue;
            PluginConfigurationHelper.Configuration configuration = this.configurationHelper.getConfiguration(GROUP_ID, ARTIFACT_ID, JAVADOC_GOAL, project, session);
            List<MavenProject> additionalProjects = configuration.getString("sourcepath").stream().flatMap(sourcepath -> Arrays.stream(sourcepath.split(";|:"))).map(s -> s.strip()).map(s -> new File(project.getBasedir(), (String)s).toPath().normalize()).map(sourcePath -> this.getProject((Path)sourcePath, projects)).filter(Objects::nonNull).distinct().toList();
            MavenDependencyInjector.injectMavenProjectDependencies((MavenProject)project, additionalProjects);
        }
    }

    private MavenProject getProject(Path sourcePath, List<MavenProject> projects) {
        MavenProject match = null;
        int matchNameCount = -1;
        for (MavenProject mavenProject : projects) {
            Path basePath = mavenProject.getBasedir().toPath();
            if (!sourcePath.startsWith(basePath)) continue;
            int nameCount = basePath.getNameCount();
            if (match != null && nameCount <= matchNameCount) continue;
            match = mavenProject;
            matchNameCount = nameCount;
        }
        return match;
    }

    private boolean isJavadocProject(MavenProject project, MavenSession mavenSession) {
        if (this.projectHelper.hasPluginExecution(GROUP_ID, ARTIFACT_ID, JAVADOC_GOAL, project, mavenSession)) {
            PluginConfigurationHelper.Configuration configuration = this.configurationHelper.getConfiguration(ConfigureMojo.class, project, mavenSession);
            return configuration.getBoolean("injectJavadocDependencies").orElse(false);
        }
        return false;
    }

    public void buildEnded(MavenSession session) {
    }
}

