/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=DocletArtifactsResolver.class)
public class DocletArtifactsResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private LegacySupport legacySupport;

    public DocletArtifactsResolver() {
    }

    DocletArtifactsResolver(RepositorySystem repositorySystem, ResolutionErrorHandler resolutionErrorHandler, LegacySupport legacySupport) {
        this.repositorySystem = repositorySystem;
        this.resolutionErrorHandler = resolutionErrorHandler;
        this.legacySupport = legacySupport;
    }

    public Set<String> resolveArtifacts(List<Dependency> dependencies) throws MojoExecutionException {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        if (dependencies == null || dependencies.isEmpty()) {
            return files;
        }
        MavenSession session = this.legacySupport.getSession();
        MavenProject project = session.getCurrentProject();
        for (Dependency dependency : dependencies) {
            Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setArtifact(artifact);
            request.setResolveRoot(true).setResolveTransitively(true);
            request.setLocalRepository(session.getLocalRepository());
            request.setRemoteRepositories(project.getPluginArtifactRepositories());
            request.setOffline(session.isOffline());
            request.setForceUpdate(session.getRequest().isUpdateSnapshots());
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            try {
                this.resolutionErrorHandler.throwErrors(request, result);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve doclet artifact " + dependency.getManagementKey(), (Exception)((Object)e));
            }
            for (Artifact resolvedArtifact : result.getArtifacts()) {
                files.add(resolvedArtifact.getFile().getAbsolutePath());
            }
        }
        return files;
    }
}

