/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.extras.docbundle.runner.ConvertSchemaToHtmlResult;
import org.eclipse.tycho.extras.docbundle.runner.ConvertSchemaToHtmlRunner;
import org.eclipse.tycho.osgi.framework.Bundles;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseApplicationManager;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseWorkspace;
import org.eclipse.tycho.osgi.framework.EclipseWorkspaceManager;
import org.eclipse.tycho.osgi.framework.Features;
import org.osgi.framework.BundleException;

@org.apache.maven.plugins.annotations.Mojo(name="schema-to-html", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ConvertSchemaToHtmlMojo
extends AbstractMojo {
    @Parameter
    private Repository pdeToolsRepository;
    @Parameter
    private File manifest;
    @Parameter
    private List<File> manifests;
    @Parameter
    private File destination;
    @Parameter
    private URL cssURL;
    @Parameter
    private String additionalSearchPaths;
    @Parameter(property="project")
    private MavenProject project;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Component
    private EclipseWorkspaceManager workspaceManager;
    @Component
    private EclipseApplicationManager applicationManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenRepositoryLocation repository = EclipseApplicationManager.getRepository((Repository)this.pdeToolsRepository);
        EclipseApplication application = this.applicationManager.getApplication(repository, Bundles.of((String[])new String[]{"org.eclipse.pde.core"}), Features.of((String[])new String[0]), "Schema to Html");
        EclipseWorkspace workspace = this.workspaceManager.getWorkspace(repository.getURL(), (Mojo)this);
        ArrayList<String> searchPaths = new ArrayList<String>();
        searchPaths.addAll(this.getSearchPaths());
        for (MavenProject reactorProject : this.reactorProjects) {
            String parent;
            if (reactorProject == this.project || !this.isValidProject(reactorProject) || searchPaths.contains(parent = reactorProject.getBasedir().getParent())) continue;
            searchPaths.add(parent);
        }
        List<File> manifestList = this.getManifestList().stream().flatMap(file -> {
            if (file.isDirectory()) {
                File[] files;
                Stream.Builder<File> builder = Stream.builder();
                for (File dir : files = file.listFiles()) {
                    MavenProject mp;
                    File pluginXml = new File(dir, "plugin.xml");
                    if (!pluginXml.isFile() || (mp = this.getReactor(dir)) == null || !this.isValidProject(mp)) continue;
                    try {
                        pluginXml = pluginXml.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    builder.add(pluginXml);
                }
                return builder.build();
            }
            return Stream.of(file);
        }).toList();
        try (EclipseFramework framework = application.startFramework(workspace, List.of());){
            ConvertSchemaToHtmlResult result = (ConvertSchemaToHtmlResult)framework.execute((Callable)new ConvertSchemaToHtmlRunner(manifestList, this.destination, this.cssURL, searchPaths, this.project.getBasedir()), new String[0]);
            Log log = this.getLog();
            List<String> list = result.errors().toList();
            if (!list.isEmpty()) {
                list.forEach(arg_0 -> ((Log)log).error(arg_0));
                throw new MojoFailureException("There are schema generation errors");
            }
        }
        catch (BundleException e) {
            throw new MojoFailureException("Can't start framework!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().getName().equals(CoreException.class.getName())) {
                throw new MojoFailureException(cause.getMessage(), cause);
            }
            throw new MojoExecutionException(cause);
        }
    }

    private boolean isValidProject(MavenProject mp) {
        return "eclipse-plugin".equals(mp.getPackaging());
    }

    private MavenProject getReactor(File dir) {
        Path path = dir.toPath();
        for (MavenProject mavenProject : this.reactorProjects) {
            Path project = mavenProject.getBasedir().toPath();
            try {
                if (!Files.isSameFile(path, project)) continue;
                return mavenProject;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    List<String> getSearchPaths() {
        if (this.additionalSearchPaths == null || this.additionalSearchPaths.isBlank()) {
            return List.of();
        }
        String[] paths = this.additionalSearchPaths.split(",");
        ArrayList<String> result = new ArrayList<String>(paths.length);
        for (String pathString : paths) {
            result.add(pathString);
        }
        return result;
    }

    private List<File> getManifestList() {
        if (this.manifests != null && !this.manifests.isEmpty()) {
            return this.manifests;
        }
        if (this.manifest != null) {
            return List.of(this.manifest);
        }
        return List.of();
    }
}

