/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.extras.docbundle.runner.BuildHelpIndexRunner;
import org.eclipse.tycho.osgi.framework.Bundles;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseApplicationManager;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseWorkspace;
import org.eclipse.tycho.osgi.framework.EclipseWorkspaceManager;
import org.eclipse.tycho.osgi.framework.Features;
import org.osgi.framework.BundleException;

@org.apache.maven.plugins.annotations.Mojo(name="build-help-index", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class BuildHelpIndexMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/plugin.xml", required=true)
    private File manifest;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private Repository buildToolsRepository;
    @Component
    private EclipseApplicationManager applicationManager;
    @Component
    private EclipseWorkspaceManager workspaceManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.manifest == null || !this.manifest.exists()) {
            throw new MojoExecutionException("Manifest is not a file: " + String.valueOf(this.manifest));
        }
        MavenRepositoryLocation repository = EclipseApplicationManager.getRepository((Repository)this.buildToolsRepository);
        EclipseApplication application = this.applicationManager.getApplication(repository, Bundles.of((String[])new String[]{"org.eclipse.help.base"}), Features.of((String[])new String[0]), "Build Document Index");
        EclipseWorkspace workspace = this.workspaceManager.getWorkspace(repository.getURL(), (Mojo)this);
        try (EclipseFramework framework = application.startFramework(workspace, List.of());){
            this.outputDirectory.mkdirs();
            framework.execute((Callable)new BuildHelpIndexRunner(this.manifest, this.outputDirectory), new String[0]);
        }
        catch (BundleException e) {
            throw new MojoFailureException("Can't start framework!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().getName().equals(CoreException.class.getName())) {
                throw new MojoFailureException(cause.getMessage(), cause);
            }
            throw new MojoExecutionException(cause);
        }
    }
}

