/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoFileReportEventListener;
import org.apache.maven.surefire.shared.utils.StringUtils;

public class FileReporter
extends StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> {
    private final boolean usePhrasedFileName;
    private final boolean usePhrasedClassNameInRunning;
    private final boolean usePhrasedClassNameInTestCaseSummary;

    public FileReporter(File reportsDirectory, String reportNameSuffix, Charset encoding, boolean usePhrasedFileName, boolean usePhrasedClassNameInRunning, boolean usePhrasedClassNameInTestCaseSummary) {
        super(reportsDirectory, reportNameSuffix, encoding);
        this.usePhrasedFileName = usePhrasedFileName;
        this.usePhrasedClassNameInRunning = usePhrasedClassNameInRunning;
        this.usePhrasedClassNameInTestCaseSummary = usePhrasedClassNameInTestCaseSummary;
    }

    static File getReportFile(File reportsDirectory, String reportEntryName, String reportNameSuffix, String fileExtension) {
        String fileName = reportEntryName + (StringUtils.isNotBlank(reportNameSuffix) ? "-" + reportNameSuffix : "") + fileExtension;
        return new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(fileName));
    }

    @Override
    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        File reportFile = FileReporter.getReportFile(this.getReportsDirectory(), this.usePhrasedFileName ? report.getReportSourceName() : report.getSourceName(), this.getReportNameSuffix(), ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try (BufferedWriter writer = FileReporter.createFileReporterWriter(reportFile, this.getEncoding());){
            writer.write("-------------------------------------------------------------------------------");
            writer.newLine();
            String tesSet = this.usePhrasedClassNameInRunning ? report.getReportSourceName() : report.getSourceName();
            writer.write("Test set: " + tesSet);
            writer.newLine();
            writer.write("-------------------------------------------------------------------------------");
            writer.newLine();
            writer.write(testSetStats.getTestSetSummary(report, this.usePhrasedClassNameInTestCaseSummary));
            writer.newLine();
            for (String testResult : testResults) {
                writer.write(testResult);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getLocalizedMessage(), e);
        }
    }

    private static BufferedWriter createFileReporterWriter(File reportFile, Charset encoding) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), encoding), 65536);
    }
}

