/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.impl.AbstractJUnit5Provider;
import org.eclipse.tycho.surefire.provider.impl.JUnit4Provider;
import org.eclipse.tycho.surefire.provider.impl.ProviderHelper;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.VersionRange;

@Component(role=TestFrameworkProvider.class, hint="junit5")
public class JUnit5Provider
extends AbstractJUnit5Provider {
    private static final VersionRange JUNIT5_VERSION_RANGE = new VersionRange("[5,6)");

    @Override
    public List<Dependency> getRequiredArtifacts() {
        return List.of(ProviderHelper.newDependency("org.eclipse.tycho.surefire.junit5"));
    }

    @Override
    public boolean isEnabled(MavenProject project, List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        return JUnit5Provider.isJUnit5(project, testBundleClassPath, JUNIT5_VERSION_RANGE) && !JUnit4Provider.isJUnit4(project, testBundleClassPath);
    }

    @Override
    public VersionRange getVersionRange() {
        return JUNIT5_VERSION_RANGE;
    }
}

