/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Comment;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.NodesVisitor;
import ch.digitalfondue.jfiveparse.Text;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class W3CDom {
    public static org.w3c.dom.Document toW3CDocument(Document doc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            W3CDom.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
            W3CDom.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
            W3CDom.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
            W3CDom.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document d = builder.newDocument();
            doc.traverse(new W3CDNodeVisitor(d));
            return d;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void setFeature(DocumentBuilderFactory dbFactory, String feature, boolean value) {
        try {
            dbFactory.setFeature(feature, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static class W3CDNodeVisitor
    implements NodesVisitor {
        protected final org.w3c.dom.Document document;
        protected org.w3c.dom.Node currentNode;
        protected final Deque<Map<String, String>> xmlNamespaces = new ArrayDeque<Map<String, String>>();

        public W3CDNodeVisitor(org.w3c.dom.Document document) {
            this.document = document;
            this.currentNode = document;
            this.xmlNamespaces.push(new HashMap());
        }

        @Override
        public void start(Node node) {
            switch (node.getNodeType()) {
                case 1: {
                    Element elem = (Element)node;
                    this.xmlNamespaces.push(new HashMap<String, String>(this.xmlNamespaces.peek()));
                    org.w3c.dom.Element e = this.toElement(elem);
                    this.currentNode.appendChild(e);
                    this.currentNode = e;
                    break;
                }
                case 3: {
                    this.currentNode.appendChild(this.document.createTextNode(((Text)node).getData()));
                    break;
                }
                case 8: {
                    this.currentNode.appendChild(this.document.createComment(((Comment)node).getData()));
                    break;
                }
            }
        }

        private static String extractXmlnsPrefix(String xmlns) {
            int idx = xmlns.indexOf(58);
            return idx == -1 ? "" : xmlns.substring(idx + 1);
        }

        private static String extractXmlnsPrefixFromAttrOrElem(String elemOrAttr) {
            int idx = elemOrAttr.indexOf(58);
            return idx == -1 ? "" : elemOrAttr.substring(0, idx);
        }

        protected org.w3c.dom.Element buildNamespacedElement(Element element) {
            String elemPrefix = W3CDNodeVisitor.extractXmlnsPrefixFromAttrOrElem(element.getNodeName());
            String ns = element.getNamespaceURI();
            if (!elemPrefix.isEmpty() && this.xmlNamespaces.peek().containsKey(elemPrefix)) {
                ns = this.xmlNamespaces.peek().get(elemPrefix);
            }
            return this.document.createElementNS(ns, element.getNodeName());
        }

        protected org.w3c.dom.Element toElement(Element elem) {
            for (String attrName : elem.getAttributes().keySet()) {
                AttributeNode attr = elem.getAttributeNode(attrName);
                if (!"xmlns".equals(attr.getName()) && !attr.getName().startsWith("xmlns:")) continue;
                this.xmlNamespaces.peek().put(W3CDNodeVisitor.extractXmlnsPrefix(attr.getName()), attr.getValue());
            }
            org.w3c.dom.Element e = this.buildNamespacedElement(elem);
            for (String attrName : elem.getAttributes().keySet()) {
                AttributeNode attr = elem.getAttributeNode(attrName);
                if ("xmlns".equals(attr.getName()) || attr.getName().startsWith("xmlns:")) {
                    e.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getValue());
                    continue;
                }
                String prefix = W3CDNodeVisitor.extractXmlnsPrefixFromAttrOrElem(attr.getName());
                String attrNs = prefix.isEmpty() ? attr.getNamespace() : this.xmlNamespaces.peek().getOrDefault(prefix, attr.getNamespace());
                e.setAttributeNS(attrNs, attr.getName(), attr.getValue());
            }
            return e;
        }

        @Override
        public void end(Node node) {
            if (node.getNodeType() == 1) {
                this.xmlNamespaces.pop();
                this.currentNode = this.currentNode.getParentNode();
            }
        }

        @Override
        public boolean complete() {
            return false;
        }
    }
}

