/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.TreeConstructor;
import ch.digitalfondue.jfiveparse.TreeConstructorAftersBeforeInitialInHead;
import ch.digitalfondue.jfiveparse.TreeConstructorInFramesetSelectTemplate;
import java.util.HashMap;
import java.util.Map;

class TreeConstructorInBodyForeignContentText {
    private static final Map<String, String> SVG_ELEMENT_CASE_CORRECTION = new HashMap<String, String>();

    TreeConstructorInBodyForeignContentText() {
    }

    private static void handleInBodyCharacter(TreeConstructor treeConstructor) {
        char chr = treeConstructor.getChr();
        if (chr != '\u0000') {
            treeConstructor.reconstructActiveFormattingElements();
            treeConstructor.insertCharacter(chr);
            if (!Common.isTabLfFfCrOrSpace(chr)) {
                treeConstructor.framesetOkToFalse();
            }
        } else {
            treeConstructor.emitParseError();
        }
    }

    private static void inBodyStartTag(String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        switch (tagNameID) {
            case 41: {
                TreeConstructorInBodyForeignContentText.startHtml(treeConstructor);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 46: 
            case 51: 
            case 54: 
            case 62: 
            case 66: 
            case 71: 
            case 76: {
                TreeConstructorAftersBeforeInitialInHead.inHead((byte)5, tagName, tagNameID, treeConstructor);
                break;
            }
            case 10: {
                TreeConstructorInBodyForeignContentText.startBody(treeConstructor);
                break;
            }
            case 30: {
                TreeConstructorInBodyForeignContentText.startFrameset(treeConstructor);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 38: 
            case 39: 
            case 48: 
            case 52: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 79: 
            case 89: 
            case 90: {
                TreeConstructorInBodyForeignContentText.startAddressUl(treeConstructor);
                break;
            }
            case 50: {
                TreeConstructorInBodyForeignContentText.startMenu(treeConstructor);
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                TreeConstructorInBodyForeignContentText.startH1H6(treeConstructor);
                break;
            }
            case 47: 
            case 61: {
                TreeConstructorInBodyForeignContentText.startPreListing(treeConstructor);
                break;
            }
            case 28: {
                TreeConstructorInBodyForeignContentText.startForm(treeConstructor);
                break;
            }
            case 45: {
                TreeConstructorInBodyForeignContentText.startLi(treeConstructor);
                break;
            }
            case 17: 
            case 22: {
                TreeConstructorInBodyForeignContentText.startDdDt(treeConstructor);
                break;
            }
            case 60: {
                TreeConstructorInBodyForeignContentText.startPlaintext(treeConstructor);
                break;
            }
            case 12: {
                TreeConstructorInBodyForeignContentText.startButton(treeConstructor);
                break;
            }
            case 88: {
                TreeConstructorInBodyForeignContentText.startA(treeConstructor);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                TreeConstructorInBodyForeignContentText.startBU(treeConstructor);
                break;
            }
            case 103: {
                TreeConstructorInBodyForeignContentText.startNobr(treeConstructor);
                break;
            }
            case 2: 
            case 49: 
            case 56: {
                TreeConstructorInBodyForeignContentText.startAppletObject(treeConstructor);
                break;
            }
            case 68: {
                TreeConstructorInBodyForeignContentText.startTable(treeConstructor);
                break;
            }
            case 3: 
            case 11: 
            case 23: 
            case 43: 
            case 80: 
            case 104: {
                TreeConstructorInBodyForeignContentText.startAreaWbr(treeConstructor);
                break;
            }
            case 44: {
                TreeConstructorInBodyForeignContentText.startInput(treeConstructor);
                break;
            }
            case 59: 
            case 65: 
            case 78: {
                TreeConstructorInBodyForeignContentText.startParamTrack(treeConstructor);
                break;
            }
            case 40: {
                TreeConstructorInBodyForeignContentText.startHr(treeConstructor);
                break;
            }
            case 105: {
                TreeConstructorInBodyForeignContentText.startImage(treeConstructor);
                break;
            }
            case 72: {
                TreeConstructorInBodyForeignContentText.startTextarea(treeConstructor);
                break;
            }
            case 81: {
                TreeConstructorInBodyForeignContentText.startXmp(treeConstructor);
                break;
            }
            case 42: {
                TreeConstructorInBodyForeignContentText.startIframe(treeConstructor);
                break;
            }
            case 53: 
            case 55: {
                TreeConstructorInBodyForeignContentText.startNoembedNoscript(tagNameID, treeConstructor);
                break;
            }
            case 64: {
                TreeConstructorInBodyForeignContentText.startSelect(treeConstructor);
                break;
            }
            case 82: 
            case 83: {
                TreeConstructorInBodyForeignContentText.startOptgroupOption(treeConstructor);
                break;
            }
            case 84: 
            case 87: {
                TreeConstructorInBodyForeignContentText.startRbRtc(treeConstructor);
                break;
            }
            case 85: 
            case 86: {
                TreeConstructorInBodyForeignContentText.startRpRt(treeConstructor);
                break;
            }
            case 106: {
                TreeConstructorInBodyForeignContentText.startMath(treeConstructor);
                break;
            }
            case 107: {
                TreeConstructorInBodyForeignContentText.startSvg(treeConstructor);
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 37: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 77: {
                if (treeConstructor.disableIgnoreTokenInBodyStartTag) {
                    TreeConstructorInBodyForeignContentText.inBodyStartTagAnythingElse(treeConstructor);
                    break;
                }
                treeConstructor.emitParseError();
                break;
            }
            default: {
                TreeConstructorInBodyForeignContentText.inBodyStartTagAnythingElse(treeConstructor);
            }
        }
    }

    private static void startSvg(TreeConstructor treeConstructor) {
        Attributes attrs = treeConstructor.getAttributes();
        Common.adjustSVGAttributes(attrs);
        Common.adjustForeignAttributes(attrs);
        treeConstructor.insertElementToken("svg", (byte)107, "http://www.w3.org/2000/svg", (byte)2, attrs);
        if (treeConstructor.isSelfClosing()) {
            treeConstructor.popCurrentNode();
            treeConstructor.ackSelfClosingTagIfSet();
        }
    }

    private static void startMath(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        Attributes attrs = treeConstructor.getAttributes();
        Common.adjustMathMLAttributes(attrs);
        Common.adjustForeignAttributes(attrs);
        treeConstructor.insertElementToken("math", (byte)106, "http://www.w3.org/1998/Math/MathML", (byte)3, attrs);
        if (treeConstructor.isSelfClosing()) {
            treeConstructor.popCurrentNode();
            treeConstructor.ackSelfClosingTagIfSet();
        }
    }

    private static void startRpRt(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInScope((byte)108)) {
            treeConstructor.generateImpliedEndTag("rtc", "http://www.w3.org/1999/xhtml");
        }
        if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)108) && !Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)87)) {
            treeConstructor.emitParseError();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startRbRtc(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInScope((byte)108)) {
            treeConstructor.generateImpliedEndTag();
        }
        if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)108)) {
            treeConstructor.emitParseError();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startOptgroupOption(TreeConstructor treeConstructor) {
        if (Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)83)) {
            treeConstructor.popCurrentNode();
        }
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
    }

    private static void startSelect(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
        treeConstructor.framesetOkToFalse();
        int insertionMode = treeConstructor.getInsertionMode();
        if (insertionMode == 9 || insertionMode == 11 || insertionMode == 13 || insertionMode == 14 || insertionMode == 2) {
            treeConstructor.setInsertionMode(16);
        } else {
            treeConstructor.setInsertionMode(15);
        }
    }

    private static void startNoembedNoscript(byte tagNameID, TreeConstructor treeConstructor) {
        if (55 == tagNameID && !treeConstructor.isScriptingFlag()) {
            TreeConstructorInBodyForeignContentText.inBodyStartTagAnythingElse(treeConstructor);
        } else {
            TreeConstructor.genericRawTextElementParsing(treeConstructor);
        }
    }

    private static void startIframe(TreeConstructor treeConstructor) {
        treeConstructor.framesetOkToFalse();
        TreeConstructor.genericRawTextElementParsing(treeConstructor);
    }

    private static void startXmp(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.framesetOkToFalse();
        TreeConstructor.genericRawTextElementParsing(treeConstructor);
    }

    private static void startTextarea(TreeConstructor treeConstructor) {
        treeConstructor.insertHtmlElementToken();
        treeConstructor.setTokenizerState(12);
        treeConstructor.saveInsertionMode();
        treeConstructor.framesetOkToFalse();
        treeConstructor.setInsertionMode(0);
        treeConstructor.ignoreCharacterTokenLF();
    }

    private static void startImage(TreeConstructor treeConstructor) {
        treeConstructor.emitParseError();
        treeConstructor.setTagName(new ResizableCharBuilder("img"));
        treeConstructor.dispatch();
    }

    private static void startHr(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
        treeConstructor.popCurrentNode();
        treeConstructor.ackSelfClosingTagIfSet();
        treeConstructor.framesetOkToFalse();
    }

    private static void startParamTrack(TreeConstructor treeConstructor) {
        treeConstructor.insertHtmlElementToken();
        treeConstructor.popCurrentNode();
        treeConstructor.ackSelfClosingTagIfSet();
    }

    private static void startInput(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        Element element = treeConstructor.insertHtmlElementToken();
        treeConstructor.popCurrentNode();
        treeConstructor.ackSelfClosingTagIfSet();
        boolean hasTypeAttr = element.getAttributes().containsKey("type");
        if (!hasTypeAttr || !"hidden".equalsIgnoreCase(element.getAttributes().get("type").getValue())) {
            treeConstructor.framesetOkToFalse();
        }
    }

    private static void startAreaWbr(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
        treeConstructor.popCurrentNode();
        treeConstructor.ackSelfClosingTagIfSet();
        treeConstructor.framesetOkToFalse();
    }

    private static void startTable(TreeConstructor treeConstructor) {
        if (!treeConstructor.isQuirksMode() && treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
        treeConstructor.framesetOkToFalse();
        treeConstructor.setInsertionMode(9);
    }

    private static void startAppletObject(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
        treeConstructor.insertMarkerInActiveFormattingElements();
        treeConstructor.framesetOkToFalse();
    }

    private static void startNobr(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        if (treeConstructor.hasElementInScope((byte)103)) {
            treeConstructor.emitParseError();
            treeConstructor.adoptionAgencyAlgorithm((byte)103);
            treeConstructor.reconstructActiveFormattingElements();
        }
        Element nobr = treeConstructor.insertHtmlElementToken();
        treeConstructor.pushInActiveFormattingElements(nobr);
    }

    private static void startBU(TreeConstructor treeConstructor) {
        treeConstructor.reconstructActiveFormattingElements();
        Element element = treeConstructor.insertHtmlElementToken();
        treeConstructor.pushInActiveFormattingElements(element);
    }

    private static void startA(TreeConstructor treeConstructor) {
        int aIdx = treeConstructor.getIndexInActiveFormattingElementsBetween((byte)88, (byte)1);
        if (aIdx != -1) {
            Element a = treeConstructor.getActiveFormattingElementAt(aIdx);
            treeConstructor.emitParseError();
            treeConstructor.adoptionAgencyAlgorithm((byte)88);
            treeConstructor.removeInActiveFormattingElements(a);
            treeConstructor.removeFromOpenElements(a);
        }
        treeConstructor.reconstructActiveFormattingElements();
        Element createdA = treeConstructor.insertHtmlElementToken();
        treeConstructor.pushInActiveFormattingElements(createdA);
    }

    private static void startButton(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)12)) {
            treeConstructor.emitParseError();
            treeConstructor.generateImpliedEndTag();
            treeConstructor.popOpenElementsUntilWithHtmlNS((byte)12);
        }
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
        treeConstructor.framesetOkToFalse();
    }

    private static void startPlaintext(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
        treeConstructor.setTokenizerState(14);
    }

    private static void startDdDt(TreeConstructor treeConstructor) {
        treeConstructor.framesetOkToFalse();
        int idx = treeConstructor.openElementsSize() - 1;
        Element node = treeConstructor.openElementAt(idx);
        while (true) {
            if (Common.isHtmlNS(node, (byte)17)) {
                treeConstructor.generateImpliedEndTag("dd", "http://www.w3.org/1999/xhtml");
                if (Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)17)) {
                    treeConstructor.emitParseError();
                }
                treeConstructor.popOpenElementsUntilWithHtmlNS((byte)17);
                break;
            }
            if (Common.isHtmlNS(node, (byte)22)) {
                treeConstructor.generateImpliedEndTag("dt", "http://www.w3.org/1999/xhtml");
                if (Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)22)) {
                    // empty if block
                }
                treeConstructor.popOpenElementsUntilWithHtmlNS((byte)22);
                break;
            }
            if (Common.isSpecialCategory(node) && !Common.isHtmlNS(node, (byte)1) && !Common.isHtmlNS(node, (byte)20) && !Common.isHtmlNS(node, (byte)58)) break;
            node = treeConstructor.openElementAt(--idx);
        }
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startLi(TreeConstructor treeConstructor) {
        treeConstructor.framesetOkToFalse();
        int idx = treeConstructor.openElementsSize() - 1;
        Element node = treeConstructor.openElementAt(idx);
        while (true) {
            if (Common.isHtmlNS(node, (byte)45)) {
                treeConstructor.generateImpliedEndTag("li", "http://www.w3.org/1999/xhtml");
                if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)45)) {
                    treeConstructor.emitParseError();
                }
                treeConstructor.popOpenElementsUntilWithHtmlNS((byte)45);
                break;
            }
            if (Common.isSpecialCategory(node) && !Common.isHtmlNS(node, (byte)1) && !Common.isHtmlNS(node, (byte)20) && !Common.isHtmlNS(node, (byte)58)) break;
            node = treeConstructor.openElementAt(--idx);
        }
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startForm(TreeConstructor treeConstructor) {
        boolean templateIsNotPresent;
        boolean bl = templateIsNotPresent = !treeConstructor.stackOfOpenElementsContains((byte)71, (byte)1);
        if (treeConstructor.getForm() != null && templateIsNotPresent) {
            treeConstructor.emitParseError();
        } else {
            if (treeConstructor.hasElementInButtonScope((byte)58)) {
                treeConstructor.closePElement();
            }
            Element formElement = treeConstructor.insertHtmlElementToken();
            if (templateIsNotPresent) {
                treeConstructor.setForm(formElement);
            }
        }
    }

    private static void startPreListing(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
        treeConstructor.ignoreCharacterTokenLF();
        treeConstructor.framesetOkToFalse();
    }

    private static void startH1H6(TreeConstructor treeConstructor) {
        Element e;
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        if (Common.isHtmlNSBetween(e = treeConstructor.getCurrentNode(), (byte)31, (byte)36)) {
            treeConstructor.emitParseError();
            treeConstructor.popCurrentNode();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startAddressUl(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startMenu(TreeConstructor treeConstructor) {
        if (treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.closePElement();
        }
        treeConstructor.insertHtmlElementToken();
    }

    private static void startFrameset(TreeConstructor treeConstructor) {
        treeConstructor.emitParseError();
        if (treeConstructor.openElementsSize() != 1 && Common.isHtmlNS(treeConstructor.openElementAt(1), (byte)10) && !Boolean.FALSE.equals(treeConstructor.getFramesetOk())) {
            Element second = treeConstructor.openElementAt(1);
            if (second.getParentNode() != null) {
                second.getParentNode().removeChild(second);
            }
            while (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)41)) {
                treeConstructor.popCurrentNode();
            }
            treeConstructor.insertHtmlElementToken();
            treeConstructor.setInsertionMode(19);
        }
    }

    private static void startBody(TreeConstructor treeConstructor) {
        treeConstructor.emitParseError();
        if (treeConstructor.openElementsSize() != 1 && Common.isHtmlNS(treeConstructor.openElementAt(1), (byte)10) && !treeConstructor.stackOfOpenElementsContains((byte)71, (byte)1)) {
            treeConstructor.framesetOkToFalse();
            Element secondInserted = treeConstructor.openElementAt(1);
            for (String attr : treeConstructor.getKeySetOfAttributes()) {
                if (secondInserted.getAttributes().containsKey(attr)) continue;
                secondInserted.getAttributes().put(treeConstructor.getAttribute(attr));
            }
        }
    }

    private static void startHtml(TreeConstructor treeConstructor) {
        treeConstructor.emitParseError();
        if (!treeConstructor.stackOfOpenElementsContains((byte)71, (byte)1)) {
            Element firstInserted = treeConstructor.openElementAt(0);
            for (String attr : treeConstructor.getKeySetOfAttributes()) {
                if (firstInserted.getAttributes().containsKey(attr)) continue;
                firstInserted.getAttributes().put(treeConstructor.getAttribute(attr));
            }
        }
    }

    private static void inBodyStartTagAnythingElse(TreeConstructor treeConstructor) {
        if (treeConstructor.interpretSelfClosingAnythingElse && treeConstructor.isSelfClosing()) {
            treeConstructor.insertHtmlElementToken();
            treeConstructor.popCurrentNode();
            treeConstructor.ackSelfClosingTagIfSet();
        } else {
            treeConstructor.reconstructActiveFormattingElements();
            treeConstructor.insertHtmlElementToken();
        }
    }

    private static void inBodyEndTag(String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        switch (tagNameID) {
            case 71: {
                TreeConstructorAftersBeforeInitialInHead.inHead((byte)4, tagName, tagNameID, treeConstructor);
                break;
            }
            case 10: {
                TreeConstructorInBodyForeignContentText.endBody(treeConstructor);
                break;
            }
            case 41: {
                TreeConstructorInBodyForeignContentText.endHtml(treeConstructor);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 38: 
            case 39: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 57: 
            case 61: 
            case 63: 
            case 67: 
            case 79: 
            case 89: 
            case 90: {
                TreeConstructorInBodyForeignContentText.endAddressUl(tagNameID, treeConstructor);
                break;
            }
            case 28: {
                TreeConstructorInBodyForeignContentText.endForm(treeConstructor);
                break;
            }
            case 58: {
                TreeConstructorInBodyForeignContentText.endP(treeConstructor);
                break;
            }
            case 45: {
                TreeConstructorInBodyForeignContentText.endLi(treeConstructor);
                break;
            }
            case 17: 
            case 22: {
                TreeConstructorInBodyForeignContentText.endDdDt(tagName, tagNameID, treeConstructor);
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                TreeConstructorInBodyForeignContentText.endH1H6(tagNameID, treeConstructor);
                break;
            }
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                treeConstructor.adoptionAgencyAlgorithm(tagNameID);
                break;
            }
            case 2: 
            case 49: 
            case 56: {
                TreeConstructorInBodyForeignContentText.endAppletObject(tagNameID, treeConstructor);
                break;
            }
            case 11: {
                TreeConstructorInBodyForeignContentText.endBr(treeConstructor);
                break;
            }
            default: {
                TreeConstructorInBodyForeignContentText.anyOtherEndTag(tagName, treeConstructor);
            }
        }
    }

    private static void endBr(TreeConstructor treeConstructor) {
        treeConstructor.emitParseError();
        treeConstructor.removeAttributes();
        treeConstructor.reconstructActiveFormattingElements();
        treeConstructor.insertHtmlElementToken();
        treeConstructor.popCurrentNode();
        treeConstructor.ackSelfClosingTagIfSet();
        treeConstructor.framesetOkToFalse();
    }

    private static void endAppletObject(byte tagNameID, TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInScope(tagNameID)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.generateImpliedEndTag();
            if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), tagNameID)) {
                treeConstructor.emitParseError();
            }
            treeConstructor.popOpenElementsUntilWithHtmlNS(tagNameID);
            treeConstructor.clearUpToLastMarkerActiveFormattingElements();
        }
    }

    private static void endH1H6(byte tagNameID, TreeConstructor treeConstructor) {
        if (!(treeConstructor.hasElementInScope((byte)31) || treeConstructor.hasElementInScope((byte)32) || treeConstructor.hasElementInScope((byte)33) || treeConstructor.hasElementInScope((byte)34) || treeConstructor.hasElementInScope((byte)35) || treeConstructor.hasElementInScope((byte)36))) {
            treeConstructor.emitParseError();
        } else {
            Element e;
            treeConstructor.generateImpliedEndTag();
            if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), tagNameID)) {
                treeConstructor.emitParseError();
            }
            while (!Common.isHtmlNSBetween(e = treeConstructor.popCurrentNode(), (byte)31, (byte)36)) {
            }
        }
    }

    private static void endDdDt(String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInScope(tagNameID)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.generateImpliedEndTag(tagName, "http://www.w3.org/1999/xhtml");
            if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), tagNameID)) {
                treeConstructor.emitParseError();
            }
            treeConstructor.popOpenElementsUntilWithHtmlNS(tagNameID);
        }
    }

    private static void endLi(TreeConstructor treeConstructor) {
        if (!treeConstructor.hasLiElementInListScope()) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.generateImpliedEndTag("li", "http://www.w3.org/1999/xhtml");
            if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)45)) {
                treeConstructor.emitParseError();
            }
            treeConstructor.popOpenElementsUntilWithHtmlNS((byte)45);
        }
    }

    private static void endP(TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInButtonScope((byte)58)) {
            treeConstructor.emitParseError();
            treeConstructor.insertHtmlElementWithEmptyAttributes("p", (byte)58);
        }
        treeConstructor.closePElement();
    }

    private static void endForm(TreeConstructor treeConstructor) {
        boolean templateIsNotPresent;
        boolean bl = templateIsNotPresent = !treeConstructor.stackOfOpenElementsContains((byte)71, (byte)1);
        if (templateIsNotPresent) {
            Element node = treeConstructor.getForm();
            treeConstructor.setForm(null);
            if (node == null || !treeConstructor.hasElementInScope(node)) {
                treeConstructor.emitParseError();
            } else {
                treeConstructor.generateImpliedEndTag();
                if (treeConstructor.getCurrentNode() != node) {
                    treeConstructor.emitParseError();
                }
                treeConstructor.removeFromOpenElements(node);
            }
        } else if (!treeConstructor.hasElementInScope((byte)28)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.generateImpliedEndTag();
            if (!Common.isHtmlNS(treeConstructor.getCurrentNode(), (byte)28)) {
                treeConstructor.emitParseError();
            }
            treeConstructor.popOpenElementsUntilWithHtmlNS((byte)28);
        }
    }

    private static void endAddressUl(byte tagNameID, TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInScope(tagNameID)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.generateImpliedEndTag();
            Element currentNode = treeConstructor.getCurrentNode();
            if (currentNode.namespaceID != 1 || currentNode.nodeNameID != tagNameID) {
                treeConstructor.emitParseError();
            }
            treeConstructor.popOpenElementsUntilWithHtmlNS(tagNameID);
        }
    }

    private static void endHtml(TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInScope((byte)10)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.setInsertionMode(18);
            treeConstructor.dispatch();
        }
    }

    private static void endBody(TreeConstructor treeConstructor) {
        if (!treeConstructor.hasElementInScope((byte)10)) {
            treeConstructor.emitParseError();
        } else {
            treeConstructor.setInsertionMode(18);
        }
    }

    static void inBody(byte tokenType, String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        switch (tokenType) {
            case 0: {
                TreeConstructorInBodyForeignContentText.handleInBodyCharacter(treeConstructor);
                return;
            }
            case 1: {
                treeConstructor.insertComment();
                return;
            }
            case 2: {
                treeConstructor.emitParseError();
                return;
            }
            case 3: {
                TreeConstructorInBodyForeignContentText.inBodyEof(tokenType, tagName, tagNameID, treeConstructor);
                return;
            }
            case 4: {
                TreeConstructorInBodyForeignContentText.inBodyEndTag(tagName, tagNameID, treeConstructor);
                break;
            }
            case 5: {
                TreeConstructorInBodyForeignContentText.inBodyStartTag(tagName, tagNameID, treeConstructor);
            }
        }
    }

    private static void inBodyEof(byte tokenType, String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        if (!treeConstructor.isStackTemplatesInsertionModeIsEmpty()) {
            TreeConstructorInFramesetSelectTemplate.inTemplate(tokenType, tagName, tagNameID, treeConstructor);
        } else {
            treeConstructor.stopParsing();
        }
    }

    static void anyOtherEndTag(String tagName, TreeConstructor treeConstructor) {
        int idx = treeConstructor.openElementsSize() - 1;
        Element node = treeConstructor.openElementAt(idx);
        while (true) {
            if (Common.isHtmlNS(node, tagName)) {
                Element e;
                treeConstructor.generateImpliedEndTag(tagName, "http://www.w3.org/1999/xhtml");
                if (node != treeConstructor.getCurrentNode()) {
                    treeConstructor.emitParseError();
                }
                while ((e = treeConstructor.popCurrentNode()) != node) {
                }
                break;
            }
            if (Common.isSpecialCategory(node)) {
                treeConstructor.emitParseError();
                return;
            }
            node = treeConstructor.openElementAt(--idx);
        }
    }

    static void foreignContent(byte tokenType, String tagName, byte tagNameID, TreeConstructor treeConstructor) {
        if (tokenType == 0 && treeConstructor.getChr() == '\u0000') {
            treeConstructor.emitParseError();
            treeConstructor.insertCharacter('\ufffd');
        } else if (tokenType == 0 && Common.isTabLfFfCrOrSpace(treeConstructor.getChr())) {
            treeConstructor.insertCharacter();
        } else if (tokenType == 0) {
            treeConstructor.insertCharacter();
            treeConstructor.framesetOkToFalse();
        } else if (tokenType == 1) {
            treeConstructor.insertComment();
        } else if (tokenType == 2) {
            treeConstructor.emitParseError();
        } else if (tokenType == 5 && (91 == tagNameID || 92 == tagNameID || 9 == tagNameID || 10 == tagNameID || 11 == tagNameID || 14 == tagNameID || 93 == tagNameID || 17 == tagNameID || 20 == tagNameID || 21 == tagNameID || 22 == tagNameID || 94 == tagNameID || 23 == tagNameID || 31 == tagNameID || 32 == tagNameID || 33 == tagNameID || 34 == tagNameID || 35 == tagNameID || 36 == tagNameID || 37 == tagNameID || 40 == tagNameID || 96 == tagNameID || 43 == tagNameID || 45 == tagNameID || 47 == tagNameID || 50 == tagNameID || 51 == tagNameID || 103 == tagNameID || 57 == tagNameID || 58 == tagNameID || 61 == tagNameID || 108 == tagNameID || 97 == tagNameID || 98 == tagNameID || 109 == tagNameID || 100 == tagNameID || 99 == tagNameID || 110 == tagNameID || 111 == tagNameID || 68 == tagNameID || 101 == tagNameID || 102 == tagNameID || 79 == tagNameID || 112 == tagNameID || 95 == tagNameID && (treeConstructor.hasAttribute("color") || treeConstructor.hasAttribute("face") || treeConstructor.hasAttribute("size"))) || tokenType == 4 && (11 == tagNameID || 58 == tagNameID)) {
            treeConstructor.emitParseError();
            while (true) {
                Element cur = treeConstructor.getCurrentNode();
                if (1 == cur.namespaceID || Common.isMathMLIntegrationPoint(cur) || Common.isHtmlIntegrationPoint(cur)) break;
                treeConstructor.popCurrentNode();
            }
            treeConstructor.insertionModeInHtmlContent();
        } else if (tokenType == 5) {
            TreeConstructorInBodyForeignContentText.anyOtherStartTag(tagName, treeConstructor);
        } else if (tokenType == 4 && Common.is(treeConstructor.getCurrentNode(), (byte)62, (byte)2)) {
            treeConstructor.popCurrentNode();
        } else if (tokenType == 4) {
            Element node = treeConstructor.getCurrentNode();
            if (!tagName.equals(Common.convertToAsciiLowerCase(node.getNodeName()))) {
                treeConstructor.emitParseError();
            }
            int idx = treeConstructor.openElementsSize() - 1;
            do {
                if (node == treeConstructor.openElementAt(0)) {
                    return;
                }
                if (tagName.equals(Common.convertToAsciiLowerCase(node.getNodeName()))) {
                    while (node != treeConstructor.popCurrentNode()) {
                    }
                    return;
                }
                node = treeConstructor.openElementAt(--idx);
            } while (1 != node.namespaceID);
            treeConstructor.insertionModeInHtmlContent();
            return;
        }
    }

    private static void anyOtherStartTag(String tagName, TreeConstructor treeConstructor) {
        Element currentNode = treeConstructor.getAdjustedCurrentNode();
        if (3 == currentNode.namespaceID) {
            Common.adjustMathMLAttributes(treeConstructor.getAttributes());
        }
        if (2 == currentNode.namespaceID) {
            if (SVG_ELEMENT_CASE_CORRECTION.containsKey(tagName)) {
                tagName = SVG_ELEMENT_CASE_CORRECTION.get(tagName);
            }
            Common.adjustSVGAttributes(treeConstructor.getAttributes());
        }
        Common.adjustForeignAttributes(treeConstructor.getAttributes());
        treeConstructor.insertElementToken(tagName, Common.tagNameToID(tagName), currentNode.getNamespaceURI(), currentNode.namespaceID, treeConstructor.getAttributes());
        if (treeConstructor.isSelfClosing()) {
            treeConstructor.popCurrentNode();
        }
    }

    static void text(byte tokenType, TreeConstructor treeConstructor) {
        switch (tokenType) {
            case 0: {
                treeConstructor.insertCharacter();
                break;
            }
            case 3: {
                TreeConstructorInBodyForeignContentText.textEof(treeConstructor);
                break;
            }
            case 4: {
                TreeConstructorInBodyForeignContentText.textEndTag(treeConstructor);
            }
        }
    }

    private static void textEndTag(TreeConstructor treeConstructor) {
        treeConstructor.popCurrentNode();
        treeConstructor.switchToOriginalInsertionMode();
    }

    private static void textEof(TreeConstructor treeConstructor) {
        treeConstructor.popCurrentNode();
        treeConstructor.switchToOriginalInsertionMode();
        treeConstructor.dispatch();
    }

    static {
        SVG_ELEMENT_CASE_CORRECTION.put("altglyph", "altGlyph");
        SVG_ELEMENT_CASE_CORRECTION.put("altglyphdef", "altGlyphDef");
        SVG_ELEMENT_CASE_CORRECTION.put("altglyphitem", "altGlyphItem");
        SVG_ELEMENT_CASE_CORRECTION.put("animatecolor", "animateColor");
        SVG_ELEMENT_CASE_CORRECTION.put("animatemotion", "animateMotion");
        SVG_ELEMENT_CASE_CORRECTION.put("animatetransform", "animateTransform");
        SVG_ELEMENT_CASE_CORRECTION.put("clippath", "clipPath");
        SVG_ELEMENT_CASE_CORRECTION.put("feblend", "feBlend");
        SVG_ELEMENT_CASE_CORRECTION.put("fecolormatrix", "feColorMatrix");
        SVG_ELEMENT_CASE_CORRECTION.put("fecomponenttransfer", "feComponentTransfer");
        SVG_ELEMENT_CASE_CORRECTION.put("fecomposite", "feComposite");
        SVG_ELEMENT_CASE_CORRECTION.put("feconvolvematrix", "feConvolveMatrix");
        SVG_ELEMENT_CASE_CORRECTION.put("fediffuselighting", "feDiffuseLighting");
        SVG_ELEMENT_CASE_CORRECTION.put("fedisplacementmap", "feDisplacementMap");
        SVG_ELEMENT_CASE_CORRECTION.put("fedistantlight", "feDistantLight");
        SVG_ELEMENT_CASE_CORRECTION.put("fedropshadow", "feDropShadow");
        SVG_ELEMENT_CASE_CORRECTION.put("feflood", "feFlood");
        SVG_ELEMENT_CASE_CORRECTION.put("fefunca", "feFuncA");
        SVG_ELEMENT_CASE_CORRECTION.put("fefuncb", "feFuncB");
        SVG_ELEMENT_CASE_CORRECTION.put("fefuncg", "feFuncG");
        SVG_ELEMENT_CASE_CORRECTION.put("fefuncr", "feFuncR");
        SVG_ELEMENT_CASE_CORRECTION.put("fegaussianblur", "feGaussianBlur");
        SVG_ELEMENT_CASE_CORRECTION.put("feimage", "feImage");
        SVG_ELEMENT_CASE_CORRECTION.put("femerge", "feMerge");
        SVG_ELEMENT_CASE_CORRECTION.put("femergenode", "feMergeNode");
        SVG_ELEMENT_CASE_CORRECTION.put("femorphology", "feMorphology");
        SVG_ELEMENT_CASE_CORRECTION.put("feoffset", "feOffset");
        SVG_ELEMENT_CASE_CORRECTION.put("fepointlight", "fePointLight");
        SVG_ELEMENT_CASE_CORRECTION.put("fespecularlighting", "feSpecularLighting");
        SVG_ELEMENT_CASE_CORRECTION.put("fespotlight", "feSpotLight");
        SVG_ELEMENT_CASE_CORRECTION.put("fetile", "feTile");
        SVG_ELEMENT_CASE_CORRECTION.put("feturbulence", "feTurbulence");
        SVG_ELEMENT_CASE_CORRECTION.put("foreignobject", "foreignObject");
        SVG_ELEMENT_CASE_CORRECTION.put("glyphref", "glyphRef");
        SVG_ELEMENT_CASE_CORRECTION.put("lineargradient", "linearGradient");
        SVG_ELEMENT_CASE_CORRECTION.put("radialgradient", "radialGradient");
        SVG_ELEMENT_CASE_CORRECTION.put("textpath", "textPath");
    }
}

