/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.TreeConstructor;
import java.util.ArrayList;

class TreeConstructorActiveFormattingElements {
    final ArrayList<Element> activeFormattingElements = new ArrayList();
    private final TreeConstructor treeConstructor;
    Element bookmark;

    TreeConstructorActiveFormattingElements(TreeConstructor treeConstructor) {
        this.treeConstructor = treeConstructor;
    }

    void insertMarker() {
        this.activeFormattingElements.add(new Marker());
    }

    void insertBookmark(Element formattingElement) {
        Bookmark b = new Bookmark();
        this.activeFormattingElements.add(this.activeFormattingElements.lastIndexOf(formattingElement), b);
        this.bookmark = b;
    }

    void removeBookmark() {
        this.activeFormattingElements.remove(this.bookmark);
        this.bookmark = null;
    }

    void moveBookmarkAfter(Element newNode) {
        this.activeFormattingElements.remove(this.bookmark);
        this.activeFormattingElements.add(this.activeFormattingElements.lastIndexOf(newNode) + 1, this.bookmark);
    }

    void push(Element element) {
        int lastMarkerPositionOrStart = 0;
        for (int i = this.activeFormattingElements.size() - 1; i >= 0; --i) {
            if (!(this.activeFormattingElements.get(i) instanceof Marker)) continue;
            lastMarkerPositionOrStart = i;
            break;
        }
        int sameElementCount = 0;
        int size = this.activeFormattingElements.size();
        int sameElementPosition = -1;
        String elementName = element.getNodeName();
        String elementNS = element.getNamespaceURI();
        Attributes elementAttrs = element.getAttributes();
        for (int i = lastMarkerPositionOrStart; i < size; ++i) {
            Element current = this.activeFormattingElements.get(i);
            if (current instanceof Marker || !elementName.equals(current.getNodeName()) || !elementNS.equals(current.getNamespaceURI()) || !elementAttrs.equals(current.getAttributes())) continue;
            ++sameElementCount;
            if (sameElementPosition != -1) continue;
            sameElementPosition = i;
        }
        if (sameElementCount >= 3) {
            this.activeFormattingElements.remove(sameElementPosition);
        }
        this.activeFormattingElements.add(element);
    }

    void reconstruct() {
        if (this.activeFormattingElements.isEmpty()) {
            return;
        }
        int lastIndex = this.activeFormattingElements.size() - 1;
        Element last = this.activeFormattingElements.get(lastIndex);
        boolean lastIsMarker = last instanceof Marker;
        if (lastIsMarker || this.treeConstructor.openElementsIndexOf(last) != -1) {
            return;
        }
        this.reconstructionPhase(lastIndex, last);
    }

    private void reconstructionPhase(int lastIndex, Element last) {
        Element entry = last;
        int entryIndex = lastIndex;
        while (entryIndex > 0) {
            boolean entryIsMarker;
            if (!(entryIsMarker = (entry = this.activeFormattingElements.get(--entryIndex)) instanceof Marker) && this.treeConstructor.openElementsIndexOf(entry) == -1) continue;
            entry = this.activeFormattingElements.get(++entryIndex);
            break;
        }
        while (true) {
            Element newElement = this.treeConstructor.insertElementToken(entry.getNodeName(), entry.nodeNameID, entry.getNamespaceURI(), entry.namespaceID, entry.getAttributes().copy());
            this.activeFormattingElements.set(entryIndex, newElement);
            if (lastIndex == entryIndex) break;
            entry = this.activeFormattingElements.get(++entryIndex);
        }
    }

    void clearUpToLastMarker() {
        Element e;
        while (!this.activeFormattingElements.isEmpty() && !((e = this.activeFormattingElements.remove(this.activeFormattingElements.size() - 1)) instanceof Marker)) {
        }
    }

    Element getElementAtIndex(int idx) {
        return this.activeFormattingElements.get(idx);
    }

    int getBetweenLastElementAndMarkerIndex(byte tagNameID) {
        for (int i = this.activeFormattingElements.size() - 1; i >= 0; --i) {
            Element e = this.activeFormattingElements.get(i);
            if (e instanceof Marker) {
                return -1;
            }
            if (tagNameID != e.nodeNameID) continue;
            return i;
        }
        return -1;
    }

    int getBetweenLastElementAndMarkerIndex(byte tagNameID, byte namespaceID) {
        for (int i = this.activeFormattingElements.size() - 1; i >= 0; --i) {
            Element e = this.activeFormattingElements.get(i);
            if (e instanceof Marker) {
                return -1;
            }
            if (!Common.is(e, tagNameID, namespaceID)) continue;
            return i;
        }
        return -1;
    }

    int indexOf(Element e) {
        return this.activeFormattingElements.lastIndexOf(e);
    }

    boolean contains(Element e) {
        return this.activeFormattingElements.lastIndexOf(e) != -1;
    }

    void removeAtIndex(int index) {
        this.activeFormattingElements.remove(index);
    }

    void remove(Element e) {
        int idx = this.activeFormattingElements.lastIndexOf(e);
        if (idx != -1) {
            this.activeFormattingElements.remove(idx);
        }
    }

    void replace(Element node, Element elem) {
        this.activeFormattingElements.set(this.activeFormattingElements.lastIndexOf(node), elem);
    }

    private static final class Bookmark
    extends Element {
        Bookmark() {
            super(null, null);
        }
    }

    private static final class Marker
    extends Element {
        Marker() {
            super(null, null);
        }
    }
}

