/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Comment;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.DocumentType;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.StopParse;
import ch.digitalfondue.jfiveparse.Text;
import ch.digitalfondue.jfiveparse.Tokenizer;
import ch.digitalfondue.jfiveparse.TreeConstructorActiveFormattingElements;
import ch.digitalfondue.jfiveparse.TreeConstructorAftersBeforeInitialInHead;
import ch.digitalfondue.jfiveparse.TreeConstructorInBodyForeignContentText;
import ch.digitalfondue.jfiveparse.TreeConstructorInFramesetSelectTemplate;
import ch.digitalfondue.jfiveparse.TreeConstructorInTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class TreeConstructor {
    private ResizableCharBuilder insertCharacterPreviousTextNode;
    static final byte CHARACTER = 0;
    static final byte COMMENT = 1;
    static final byte DOCTYPE = 2;
    static final byte EOF = 3;
    static final byte END_TAG = 4;
    static final byte START_TAG = 5;
    private boolean scriptingFlag;
    private Tokenizer tokenizer;
    private int insertionMode = 3;
    private int originalInsertionMode;
    private final ArrayList<Element> openElements = new ArrayList();
    private final TreeConstructorActiveFormattingElements activeFormattingElements = new TreeConstructorActiveFormattingElements(this);
    private final ArrayList<Integer> stackTemplatesInsertionMode = new ArrayList();
    private final Document document = new Document();
    final boolean disableIgnoreTokenInBodyStartTag;
    final boolean interpretSelfClosingAnythingElse;
    private byte tokenType;
    private char chr;
    private ResizableCharBuilder comment;
    private StringBuilder doctypeName;
    private StringBuilder doctypePublicId;
    private StringBuilder doctypeSystemId;
    private boolean correctness;
    private String tagName;
    private byte tagNameID;
    private String originalTagName;
    private boolean selfClosing;
    private Attributes attrs;
    private Element head;
    private Element form;
    private Element context;
    private Boolean framesetOk;
    private boolean isHtmlFragmentParsing;
    private boolean fosterParentingEnabled;
    private boolean ignoreCharacterTokenLF;
    private ResizableCharBuilder pendingTableCharactersToken;
    private boolean quirksMode;
    private boolean inHtmlContent;

    void setTokenizerState(int state) {
        this.tokenizer.setState(state);
    }

    void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    TreeConstructor(boolean disableIgnoreTokenInBodyStartTag, boolean interpretSelfClosingAnythingElse) {
        this.disableIgnoreTokenInBodyStartTag = disableIgnoreTokenInBodyStartTag;
        this.interpretSelfClosingAnythingElse = interpretSelfClosingAnythingElse;
    }

    private void setTagNameAndSaveOriginal(ResizableCharBuilder rawTagName) {
        this.setTagName(rawTagName);
        this.originalTagName = rawTagName.containsUpperCase ? rawTagName.asString() : this.tagName;
    }

    void setTagName(ResizableCharBuilder rawTagName) {
        String tagName;
        this.tagName = tagName = rawTagName.toLowerCase();
        this.tagNameID = Common.tagNameToID(tagName);
    }

    Element getAdjustedCurrentNode() {
        if (this.openElements.isEmpty()) {
            return null;
        }
        int size = this.openElements.size();
        if (this.isHtmlFragmentParsing && size == 1) {
            return this.context;
        }
        return this.openElements.get(size - 1);
    }

    void dispatch() {
        if (this.ignoreCharacterTokenLF) {
            this.ignoreCharacterTokenLF = false;
            if (this.tokenType == 0 && this.chr == '\n') {
                return;
            }
        }
        this.inHtmlContent = this.checkIsInHtmlContent();
        if (this.inHtmlContent) {
            this.insertionModeInHtmlContent();
        } else {
            TreeConstructorInBodyForeignContentText.foreignContent(this.tokenType, this.tagName, this.tagNameID, this);
        }
    }

    private boolean checkIsInHtmlContent() {
        Element adjustedCurrentNode = this.getAdjustedCurrentNode();
        return this.openElements.isEmpty() || adjustedCurrentNode != null && (1 == adjustedCurrentNode.namespaceID || this.checkIsInHtmlContentSVGMathML(adjustedCurrentNode)) || this.tokenType == 3;
    }

    private boolean checkIsInHtmlContentSVGMathML(Element adjustedCurrentNode) {
        return Common.isMathMLIntegrationPoint(adjustedCurrentNode) && (this.tokenType == 5 && !"mglyph".equals(this.tagName) && !"malignmark".equals(this.tagName) || this.tokenType == 0) || "annotation-xml".equals(adjustedCurrentNode.getNodeName()) && 3 == adjustedCurrentNode.namespaceID && this.tokenType == 5 && "svg".equals(this.tagName) || Common.isHtmlIntegrationPoint(adjustedCurrentNode) && (this.tokenType == 5 || this.tokenType == 0);
    }

    void insertionModeInHtmlContent() {
        switch (this.insertionMode) {
            case 0: {
                TreeConstructorInBodyForeignContentText.text(this.tokenType, this);
                break;
            }
            case 1: {
                TreeConstructorInBodyForeignContentText.inBody(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 2: {
                TreeConstructorInTable.inCell(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            default: {
                this.insertionModeInHtmlContentAll();
            }
        }
    }

    private void insertionModeInHtmlContentAll() {
        switch (this.insertionMode) {
            case 3: {
                TreeConstructorAftersBeforeInitialInHead.initial(this.tokenType, this);
                break;
            }
            case 4: {
                TreeConstructorAftersBeforeInitialInHead.beforeHtml(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 5: {
                TreeConstructorAftersBeforeInitialInHead.beforeHead(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 6: {
                TreeConstructorAftersBeforeInitialInHead.inHead(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 7: {
                TreeConstructorAftersBeforeInitialInHead.inHeadNoScript(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 8: {
                TreeConstructorAftersBeforeInitialInHead.afterHead(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 1: {
                TreeConstructorInBodyForeignContentText.inBody(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 0: {
                TreeConstructorInBodyForeignContentText.text(this.tokenType, this);
                break;
            }
            case 9: {
                TreeConstructorInTable.inTable(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 10: {
                TreeConstructorInTable.inTableText(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 11: {
                TreeConstructorInTable.inCaption(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 12: {
                TreeConstructorInTable.inColumnGroup(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 13: {
                TreeConstructorInTable.inTableBody(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 14: {
                TreeConstructorInTable.inRow(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 2: {
                TreeConstructorInTable.inCell(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 15: {
                TreeConstructorInFramesetSelectTemplate.inSelect(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 16: {
                TreeConstructorInFramesetSelectTemplate.inSelectTable(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 17: {
                TreeConstructorInFramesetSelectTemplate.inTemplate(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 18: {
                TreeConstructorAftersBeforeInitialInHead.afterBody(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 19: {
                TreeConstructorInFramesetSelectTemplate.inFrameset(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 20: {
                TreeConstructorAftersBeforeInitialInHead.afterFrameset(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 21: {
                TreeConstructorAftersBeforeInitialInHead.afterAfterBody(this.tokenType, this.tagName, this.tagNameID, this);
                break;
            }
            case 22: {
                TreeConstructorAftersBeforeInitialInHead.afterAfterFrameset(this.tokenType, this.tagName, this.tagNameID, this);
            }
        }
    }

    void stopParsing() {
        throw new StopParse();
    }

    void closePElement() {
        this.generateImpliedEndTag("p", "http://www.w3.org/1999/xhtml");
        Element e = this.getCurrentNode();
        if (58 != e.nodeNameID || 1 != e.namespaceID) {
            this.emitParseError();
        }
        this.popOpenElementsUntilWithHtmlNS((byte)58);
    }

    Element getCurrentNode() {
        return this.openElements.get(this.openElements.size() - 1);
    }

    void generateImpliedEndTag() {
        this.generateImpliedEndTag(null, null);
    }

    void generateImpliedEndTag(String excludeTagName, String excludeNameSpace) {
        while (true) {
            Element currentNode;
            boolean check;
            boolean bl = check = Common.isImpliedTag(currentNode = this.getCurrentNode()) && (excludeTagName == null || !currentNode.getNodeName().equals(excludeTagName) || !currentNode.getNamespaceURI().equals(excludeNameSpace));
            if (!check) break;
            this.popCurrentNode();
        }
    }

    boolean hasElementInScope(byte tagNameID) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (Common.isHtmlNS(node, tagNameID)) {
                return true;
            }
            if (!Common.isInCommonInScope(node)) continue;
            return false;
        }
        return false;
    }

    boolean hasElementInScope(Element e) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (node == e) {
                return true;
            }
            if (!Common.isInCommonInScope(node)) continue;
            return false;
        }
        return false;
    }

    boolean hasElementInButtonScope(byte tagNameID) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (Common.isHtmlNS(node, tagNameID)) {
                return true;
            }
            if (!Common.isInCommonInScope(node) && !Common.isHtmlNS(node, (byte)12)) continue;
            return false;
        }
        return false;
    }

    boolean hasLiElementInListScope() {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (Common.isHtmlNS(node, (byte)45)) {
                return true;
            }
            if (!Common.isInCommonInScope(node) && !Common.isHtmlNS(node, (byte)57) && !Common.isHtmlNS(node, (byte)79)) continue;
            return false;
        }
        return false;
    }

    boolean hasElementInTableScope(byte tagNameID) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (Common.isHtmlNS(node, tagNameID)) {
                return true;
            }
            if (!Common.isHtmlNS(node, (byte)41) && !Common.isHtmlNS(node, (byte)68) && !Common.isHtmlNS(node, (byte)71)) continue;
            return false;
        }
        return false;
    }

    boolean hasElementInSelectScope(byte tagNameID) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element node = this.openElements.get(i);
            if (Common.isHtmlNS(node, tagNameID)) {
                return true;
            }
            if (Common.isHtmlNS(node, (byte)83) || Common.isHtmlNS(node, (byte)82)) continue;
            return false;
        }
        return true;
    }

    void adoptionAgencyAlgorithm(byte subjectID) {
        Element current = this.getCurrentNode();
        if (Common.isHtmlNS(current, subjectID) && !this.activeFormattingElements.contains(current)) {
            this.popCurrentNode();
            return;
        }
        int outerLoopCounter = 0;
        while (outerLoopCounter < 8) {
            int position;
            Node toInsert;
            Element furthestBlock;
            ++outerLoopCounter;
            int formattingElementIdx = this.activeFormattingElements.getBetweenLastElementAndMarkerIndex(subjectID);
            if (formattingElementIdx == -1) {
                TreeConstructorInBodyForeignContentText.anyOtherEndTag(this.tagName, this);
                return;
            }
            Element formattingElement = this.activeFormattingElements.getElementAtIndex(formattingElementIdx);
            if (this.openElements.lastIndexOf(formattingElement) == -1) {
                this.emitParseError();
                this.activeFormattingElements.removeAtIndex(formattingElementIdx);
                return;
            }
            if (!this.hasElementInScope(formattingElement)) {
                this.emitParseError();
                return;
            }
            if (formattingElement != this.getCurrentNode()) {
                this.emitParseError();
            }
            if ((furthestBlock = this.getFurthestBlock(formattingElement)) == null) {
                Element e;
                while ((e = this.popCurrentNode()) != formattingElement) {
                }
                this.activeFormattingElements.removeAtIndex(formattingElementIdx);
                return;
            }
            Element commonAncestor = this.openElements.get(this.openElements.lastIndexOf(formattingElement) - 1);
            this.activeFormattingElements.insertBookmark(formattingElement);
            Element node = furthestBlock;
            Element lastNode = furthestBlock;
            int innerLoopCounter = 0;
            Element nodeBefore = null;
            while (true) {
                ++innerLoopCounter;
                int nodeIdx = this.openElements.lastIndexOf(node);
                if ((node = nodeIdx != -1 ? this.openElements.get(nodeIdx - 1) : nodeBefore) == formattingElement) break;
                if (innerLoopCounter > 3 && this.activeFormattingElements.contains(node)) {
                    this.activeFormattingElements.remove(node);
                }
                if (!this.activeFormattingElements.contains(node)) {
                    nodeBefore = this.openElements.get(this.openElements.lastIndexOf(node) - 1);
                    continue;
                }
                Element newElement = TreeConstructor.buildElement(node.nodeName, node.nodeNameID, node.originalNodeName, node.namespaceURI, node.namespaceID, node.getAttributes().copy());
                commonAncestor.appendChild(newElement);
                this.activeFormattingElements.replace(node, newElement);
                this.openElements.set(this.openElements.lastIndexOf(node), newElement);
                node = newElement;
                if (lastNode == furthestBlock) {
                    this.activeFormattingElements.moveBookmarkAfter(newElement);
                }
                node.appendChild(lastNode);
                lastNode = node;
            }
            Node[] place = this.findAppropriatePlaceForInsertingNode(commonAncestor);
            if (place[1] == null) {
                toInsert = place[0];
                position = toInsert.getChildCount();
            } else {
                toInsert = place[0];
                position = toInsert.getChildNodes().indexOf(place[1]);
            }
            toInsert.insertChildren(position, lastNode);
            Element elem = TreeConstructor.buildElement(formattingElement.getNodeName(), formattingElement.nodeNameID, formattingElement.originalNodeName, formattingElement.getNamespaceURI(), formattingElement.namespaceID, formattingElement.getAttributes().copy());
            ArrayList<Node> childs = new ArrayList<Node>(furthestBlock.getChildNodes());
            furthestBlock.empty();
            for (Node n : childs) {
                elem.appendChild(n);
            }
            furthestBlock.appendChild(elem);
            this.activeFormattingElements.remove(formattingElement);
            this.activeFormattingElements.activeFormattingElements.set(this.activeFormattingElements.indexOf(this.activeFormattingElements.bookmark), elem);
            this.activeFormattingElements.removeBookmark();
            this.openElements.remove(formattingElement);
            this.openElements.add(this.openElements.lastIndexOf(furthestBlock) + 1, elem);
        }
    }

    private Element getFurthestBlock(Element formattingElement) {
        Element furthestBlock = null;
        for (int idx = this.openElements.size() - 1; idx >= 0; --idx) {
            Element currentOpenElement = this.openElements.get(idx);
            if (Common.isSpecialCategory(currentOpenElement)) {
                furthestBlock = currentOpenElement;
            }
            if (currentOpenElement != formattingElement || furthestBlock == null) continue;
            return furthestBlock;
        }
        return null;
    }

    static void genericRawTextElementParsing(TreeConstructor treeConstructor) {
        treeConstructor.insertHtmlElementToken();
        treeConstructor.tokenizer.setState(4);
        treeConstructor.originalInsertionMode = treeConstructor.insertionMode;
        treeConstructor.insertionMode = 0;
    }

    static void genericRCDataParsing(TreeConstructor treeConstructor) {
        treeConstructor.insertHtmlElementToken();
        treeConstructor.tokenizer.setState(12);
        treeConstructor.originalInsertionMode = treeConstructor.insertionMode;
        treeConstructor.insertionMode = 0;
    }

    void ackSelfClosingTagIfSet() {
    }

    void insertCharacter() {
        this.insertCharacter(this.chr);
    }

    static Element buildElement(String name, byte nameID, String originalName, String namespace, byte namespaceID, Attributes attrs) {
        return new Element(name, nameID, originalName, namespace, namespaceID, attrs);
    }

    Element insertElementToken(String name, byte nameId, String namespace, byte nameSpaceID, Attributes attrs) {
        Element element = TreeConstructor.buildElement(name, nameId, name, namespace, nameSpaceID, attrs);
        return this.insertHtmlElementToken(element);
    }

    Element insertHtmlElementWithEmptyAttributes(String name, byte nameID) {
        Element element = TreeConstructor.buildElement(name, nameID, name, "http://www.w3.org/1999/xhtml", (byte)1, null);
        return this.insertHtmlElementToken(element);
    }

    Element insertHtmlElementToken() {
        Element element = TreeConstructor.buildElement(this.tagName, this.tagNameID, this.originalTagName, "http://www.w3.org/1999/xhtml", (byte)1, this.attrs);
        return this.insertHtmlElementToken(element);
    }

    Node[] findAppropriatePlaceForInsertingNode(Element overrideTarget) {
        Element target = overrideTarget != null ? overrideTarget : this.getCurrentNode();
        byte targetNameID = target.nodeNameID;
        if (this.fosterParentingEnabled && 1 == target.namespaceID && (68 == targetNameID || 69 == targetNameID || 73 == targetNameID || 75 == targetNameID || 77 == targetNameID)) {
            int lastTemplatePos = this.findLastElementPositionMatching((byte)71, (byte)1);
            int lastTablePos = this.findLastElementPositionMatching((byte)68, (byte)1);
            if (lastTemplatePos != -1 && (lastTablePos == -1 || lastTemplatePos > lastTablePos)) {
                return new Node[]{this.openElements.get(lastTemplatePos), null};
            }
            if (lastTablePos == -1) {
                return new Node[]{this.openElements.get(0), null};
            }
            Element lastTable = this.openElements.get(lastTablePos);
            if (lastTable.getParentNode() != null) {
                return new Node[]{lastTable.getParentNode(), lastTable};
            }
            Element previous = this.openElements.get(lastTablePos - 1);
            return new Node[]{previous, null};
        }
        return new Node[]{target, null};
    }

    private int findLastElementPositionMatching(byte nameID, byte namespaceID) {
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            Element e = this.openElements.get(i);
            if (!Common.is(e, nameID, namespaceID)) continue;
            return i;
        }
        return -1;
    }

    boolean stackOfOpenElementsContains(byte nameID, byte namespaceID) {
        return this.findLastElementPositionMatching(nameID, namespaceID) != -1;
    }

    void insertCharacter(char charToInsert) {
        Text t;
        Node last;
        int position;
        List<Node> nodes;
        Node toInsert;
        if (!this.fosterParentingEnabled) {
            toInsert = this.getCurrentNode();
            nodes = toInsert.getChildNodes();
            position = nodes.size();
        } else {
            Node[] place = this.findAppropriatePlaceForInsertingNode(null);
            if (place[1] == null) {
                toInsert = place[0];
                nodes = toInsert.getChildNodes();
                position = nodes.size();
            } else {
                toInsert = place[0];
                nodes = toInsert.getChildNodes();
                position = nodes.indexOf(place[1]);
            }
        }
        if (!nodes.isEmpty() && position > 0 && (last = nodes.get(position - 1)).getNodeType() == 3) {
            t = (Text)last;
            t.dataBuilder.append(charToInsert);
        } else {
            t = new Text(new ResizableCharBuilder());
            t.dataBuilder.append(charToInsert);
            toInsert.insertChildren(position, t);
        }
        this.insertCharacterPreviousTextNode = t.dataBuilder;
    }

    private Element insertHtmlElementToken(Element element) {
        int position;
        Node toInsert;
        if (this.fosterParentingEnabled) {
            Node[] place = this.findAppropriatePlaceForInsertingNode(null);
            if (place[1] == null) {
                toInsert = place[0];
                position = toInsert.getChildCount();
            } else {
                toInsert = place[0];
                position = toInsert.getChildNodes().indexOf(place[1]);
            }
        } else {
            if (this.openElements.isEmpty()) {
                return element;
            }
            toInsert = this.openElements.get(this.openElements.size() - 1);
            position = toInsert.getChildCount();
        }
        toInsert.insertChildren(position, element);
        this.openElements.add(element);
        return element;
    }

    void insertComment() {
        int position;
        Node toInsert;
        if (this.fosterParentingEnabled) {
            Node[] place = this.findAppropriatePlaceForInsertingNode(null);
            if (place[1] == null) {
                toInsert = place[0];
                position = toInsert.getChildCount();
            } else {
                toInsert = place[0];
                position = toInsert.getChildNodes().indexOf(place[1]);
            }
        } else {
            toInsert = this.openElements.get(this.openElements.size() - 1);
            position = toInsert.getChildCount();
        }
        toInsert.insertChildren(position, new Comment(this.comment));
    }

    void insertCommentToDocument() {
        this.document.appendChild(new Comment(this.comment));
    }

    void insertCommentToHtmlElement() {
        this.openElements.get(0).appendChild(new Comment(this.comment));
    }

    Element popCurrentNode() {
        return this.openElements.remove(this.openElements.size() - 1);
    }

    void popOpenElementsUntilWithHtmlNS(byte nameID) {
        Element e;
        while (!Common.isHtmlNS(e = this.popCurrentNode(), nameID)) {
        }
    }

    void pushInStackTemplatesInsertionMode(int insertionMode) {
        this.stackTemplatesInsertionMode.add(insertionMode);
    }

    boolean isStackTemplatesInsertionModeIsEmpty() {
        return this.stackTemplatesInsertionMode.isEmpty();
    }

    void popFromStackTemplatesInsertionMode() {
        this.stackTemplatesInsertionMode.remove(this.stackTemplatesInsertionMode.size() - 1);
    }

    void emitParseError() {
    }

    void emitCharacter(char chr) {
        this.tokenType = 0;
        this.insertCharacterPreviousTextNode = null;
        this.chr = chr;
        this.dispatch();
    }

    void emitComment(ResizableCharBuilder comment) {
        this.comment = comment;
        this.tokenType = 1;
        this.dispatch();
    }

    void emitDoctypeToken(StringBuilder doctypeName, StringBuilder doctypePublicId, StringBuilder doctypeSystemId, boolean correctness) {
        this.doctypeName = doctypeName;
        this.doctypePublicId = doctypePublicId;
        this.doctypeSystemId = doctypeSystemId;
        this.correctness = correctness;
        this.tokenType = (byte)2;
        this.dispatch();
    }

    void emitEOF() {
        this.tokenType = (byte)3;
        this.dispatch();
        throw new StopParse();
    }

    void emitEndTagToken(ResizableCharBuilder name) {
        this.setTagName(name);
        this.tokenType = (byte)4;
        this.dispatch();
    }

    void emitStartTagToken(ResizableCharBuilder name, Attributes attrs, boolean selfClosing) {
        this.setTagNameAndSaveOriginal(name);
        this.attrs = attrs;
        this.selfClosing = selfClosing;
        this.tokenType = (byte)5;
        this.dispatch();
    }

    Document getDocument() {
        return this.document;
    }

    boolean isScriptingFlag() {
        return this.scriptingFlag;
    }

    void setScriptingFlag(boolean scriptingFlag) {
        this.scriptingFlag = scriptingFlag;
    }

    void resetInsertionModeAppropriately() {
        boolean last = false;
        int counter = this.openElements.size() - 1;
        Element node = this.openElements.get(counter);
        while (true) {
            if (node == this.openElements.get(0)) {
                last = true;
            }
            if (this.isHtmlFragmentParsing) {
                node = this.context;
            }
            if (Common.isHtmlNS(node, (byte)64)) {
                if (last) {
                    this.insertionMode = 15;
                    break;
                }
                int ancestorIdx = counter;
                Element ancestor = node;
                while (ancestor != this.openElements.get(0) && !Common.isHtmlNS(ancestor = this.openElements.get(--ancestorIdx), (byte)71)) {
                    if (!Common.isHtmlNS(ancestor, (byte)68)) continue;
                    this.insertionMode = 16;
                    return;
                }
                this.insertionMode = 15;
                break;
            }
            if ((Common.isHtmlNS(node, (byte)70) || Common.isHtmlNS(node, (byte)74)) && !last) {
                this.insertionMode = 2;
                break;
            }
            if (Common.isHtmlNS(node, (byte)77)) {
                this.insertionMode = 14;
                break;
            }
            if (Common.isHtmlNS(node, (byte)69) || Common.isHtmlNS(node, (byte)75) || Common.isHtmlNS(node, (byte)73)) {
                this.insertionMode = 13;
                break;
            }
            if (Common.isHtmlNS(node, (byte)13)) {
                this.insertionMode = 11;
                break;
            }
            if (Common.isHtmlNS(node, (byte)16)) {
                this.insertionMode = 12;
                break;
            }
            if (Common.isHtmlNS(node, (byte)68)) {
                this.insertionMode = 9;
                break;
            }
            if (Common.isHtmlNS(node, (byte)71)) {
                this.insertionMode = this.stackTemplatesInsertionMode.get(this.stackTemplatesInsertionMode.size() - 1);
                break;
            }
            if (Common.isHtmlNS(node, (byte)37)) {
                this.insertionMode = 6;
                break;
            }
            if (Common.isHtmlNS(node, (byte)10)) {
                this.insertionMode = 1;
                break;
            }
            if (Common.isHtmlNS(node, (byte)30)) {
                this.insertionMode = 19;
                break;
            }
            if (Common.isHtmlNS(node, (byte)41)) {
                if (this.head == null) {
                    this.insertionMode = 5;
                    break;
                }
                this.insertionMode = 8;
                break;
            }
            if (last) {
                this.insertionMode = 1;
                break;
            }
            node = this.openElements.get(--counter);
        }
    }

    byte getTokenType() {
        return this.tokenType;
    }

    void setTokenType(byte tokenType) {
        this.tokenType = tokenType;
    }

    char getChr() {
        return this.chr;
    }

    void setChr(char chr) {
        this.chr = chr;
    }

    ResizableCharBuilder getInsertCharacterPreviousTextNode() {
        return this.insertCharacterPreviousTextNode;
    }

    void resetInsertCharacterPreviousTextNode() {
        this.insertCharacterPreviousTextNode = null;
    }

    boolean isInHtmlContent() {
        return this.inHtmlContent;
    }

    boolean isQuirksMode() {
        return this.quirksMode;
    }

    void setQuirksMode(boolean quirksMode) {
        this.quirksMode = quirksMode;
    }

    DocumentType buildDocumentType() {
        return new DocumentType(TreeConstructor.toStringOrEmptyString(this.doctypeName), TreeConstructor.toStringOrEmptyString(this.doctypePublicId), TreeConstructor.toStringOrEmptyString(this.doctypeSystemId));
    }

    private static String toStringOrEmptyString(StringBuilder sb) {
        return sb == null ? "" : sb.toString();
    }

    boolean isSelfClosing() {
        return this.selfClosing;
    }

    void ignoreCharacterTokenLF() {
        this.ignoreCharacterTokenLF = true;
    }

    void pushIntoStackTemplatesInsertionMode(int insMode) {
        this.stackTemplatesInsertionMode.add(insMode);
    }

    Element getHead() {
        return this.head;
    }

    void setHead(Element head) {
        this.head = head;
    }

    void enableFosterParenting() {
        this.fosterParentingEnabled = true;
    }

    void disableFosterParenting() {
        this.fosterParentingEnabled = false;
    }

    void createPendingTableCharactersToken() {
        this.pendingTableCharactersToken = new ResizableCharBuilder();
    }

    void appendToPendingTableCharactersToken(int chr) {
        this.pendingTableCharactersToken.append((char)chr);
    }

    ResizableCharBuilder getPendingTableCharactersToken() {
        return this.pendingTableCharactersToken;
    }

    Element getForm() {
        return this.form;
    }

    void setForm(Element form) {
        this.form = form;
    }

    void setContext(Element node) {
        this.context = node;
    }

    boolean isHtmlFragmentParsing() {
        return this.isHtmlFragmentParsing;
    }

    void setHtmlFragmentParsing(boolean isHtmlFragmentParsing) {
        this.isHtmlFragmentParsing = isHtmlFragmentParsing;
    }

    Boolean getFramesetOk() {
        return this.framesetOk;
    }

    void framesetOkToFalse() {
        this.framesetOk = Boolean.FALSE;
    }

    void clearUpToLastMarkerActiveFormattingElements() {
        this.activeFormattingElements.clearUpToLastMarker();
    }

    void reconstructActiveFormattingElements() {
        this.activeFormattingElements.reconstruct();
    }

    void insertMarkerInActiveFormattingElements() {
        this.activeFormattingElements.insertMarker();
    }

    void pushInActiveFormattingElements(Element element) {
        this.activeFormattingElements.push(element);
    }

    void removeInActiveFormattingElements(Element element) {
        this.activeFormattingElements.remove(element);
    }

    Element getActiveFormattingElementAt(int idx) {
        return this.activeFormattingElements.getElementAtIndex(idx);
    }

    int getIndexInActiveFormattingElementsBetween(byte nameID, byte namespaceID) {
        return this.activeFormattingElements.getBetweenLastElementAndMarkerIndex(nameID, namespaceID);
    }

    void saveInsertionMode() {
        this.originalInsertionMode = this.insertionMode;
    }

    void switchToOriginalInsertionMode() {
        this.insertionMode = this.originalInsertionMode;
    }

    int getInsertionMode() {
        return this.insertionMode;
    }

    void setInsertionMode(int insertionMode) {
        this.insertionMode = insertionMode;
    }

    int openElementsSize() {
        return this.openElements.size();
    }

    void removeFromOpenElements(Element e) {
        this.openElements.remove(e);
    }

    void addToOpenElements(Element e) {
        this.openElements.add(e);
    }

    Element openElementAt(int idx) {
        return this.openElements.get(idx);
    }

    int openElementsIndexOf(Element elem) {
        return this.openElements.lastIndexOf(elem);
    }

    boolean hasAttribute(String key) {
        return this.attrs.containsKey(key);
    }

    AttributeNode getAttribute(String key) {
        return this.attrs.get(key);
    }

    Attributes getAttributes() {
        return this.attrs;
    }

    void removeAttributes() {
        this.attrs = null;
    }

    Set<String> getKeySetOfAttributes() {
        return this.attrs.keySet();
    }
}

