/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.Tokenizer;
import ch.digitalfondue.jfiveparse.TokenizerCharacterReference;

class TokenizerRCDataAndScriptStates {
    private static final ResizableCharBuilder SCRIPT = new ResizableCharBuilder("script");

    TokenizerRCDataAndScriptStates() {
    }

    static void handleRCDataState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 38: {
                tokenizer.setState(13);
                break;
            }
            case 60: {
                tokenizer.setState(15);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitEOF();
                break;
            }
            default: {
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleCharacterReferenceInRCDataState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        tokenizer.setState(12);
        char[] chars = TokenizerCharacterReference.consumeCharacterReference(-1, false, processedInputStream, tokenizer);
        if (chars == null) {
            tokenizer.emitCharacter(38);
        } else {
            for (char c : chars) {
                tokenizer.emitCharacter(c);
            }
        }
    }

    static void handleRCDataLessThanSignState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 47) {
            tokenizer.createTemporaryBuffer();
            tokenizer.setState(16);
        } else {
            tokenizer.setStateAndEmitCharacter(12, 60);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleRCDataEndTagOpenState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
            tokenizer.newEndTokenTag();
            tokenizer.appendCurrentTagToken(chr);
            tokenizer.appendToTemporaryBuffer(chr);
            tokenizer.setState(17);
        } else {
            tokenizer.setStateAndEmitCharacter(12, 60);
            tokenizer.emitCharacter(47);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleRCDataEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(7);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseRCDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 47: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(42);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseRCDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 62: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(0);
                    tokenizer.emitTagToken();
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseRCDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendCurrentTagToken(chr);
                    tokenizer.appendToTemporaryBuffer(chr);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseRCDataEndTagNameState(tokenizer, processedInputStream, chr);
            }
        }
    }

    private static void anythingElseRCDataEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream, int chr) {
        tokenizer.setStateAndEmitCharacter(12, 60);
        tokenizer.emitCharacter(47);
        tokenizer.emitTemporaryBufferAsCharacters();
        processedInputStream.reconsume(chr);
    }

    static void handleScriptDataState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case -1: {
                tokenizer.emitEOF();
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case 60: {
                tokenizer.setState(21);
                break;
            }
            default: {
                int previousInsertionMode = tokenizer.getTokenHandlerInsertionMode();
                tokenizer.emitCharacter(chr);
                int currentInsertionMode = tokenizer.getTokenHandlerInsertionMode();
                ResizableCharBuilder textNode = tokenizer.getTokenHandlerInsertCharacterPreviousTextNode();
                if (tokenizer.getState() != 5 || previousInsertionMode != currentInsertionMode || textNode == null) break;
                while (true) {
                    int internalChr = processedInputStream.getNextInputCharacterAndConsume();
                    switch (internalChr) {
                        case -1: {
                            tokenizer.resetTokenHandlerInsertCharacterPreviousTextNode();
                            tokenizer.emitEOF();
                            return;
                        }
                        case 0: {
                            tokenizer.emitParseError();
                            tokenizer.emitCharacter(65533);
                            return;
                        }
                        case 60: {
                            tokenizer.setState(21);
                            return;
                        }
                    }
                    textNode.append((char)internalChr);
                }
            }
        }
    }

    static void handleScriptDataLessThanSignState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 47: {
                tokenizer.createTemporaryBuffer();
                tokenizer.setState(22);
                break;
            }
            case 33: {
                tokenizer.setState(24);
                tokenizer.emitCharacter(60);
                tokenizer.emitCharacter(33);
                break;
            }
            default: {
                tokenizer.setState(5);
                tokenizer.emitCharacter(60);
                processedInputStream.reconsume(chr);
            }
        }
    }

    static void handleScriptDataEndTagOpenState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
            tokenizer.newEndTokenTag();
            tokenizer.appendCurrentTagToken(chr);
            tokenizer.appendToTemporaryBuffer(chr);
            tokenizer.setState(23);
        } else {
            tokenizer.setState(5);
            tokenizer.emitCharacter(60);
            tokenizer.emitCharacter(47);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(7);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 47: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(42);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 62: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(0);
                    tokenizer.emitTagToken();
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendCurrentTagToken(chr);
                    tokenizer.appendToTemporaryBuffer(chr);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEndTagNameState(tokenizer, processedInputStream, chr);
            }
        }
    }

    private static void anythingElseScriptDataEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream, int chr) {
        tokenizer.setState(5);
        tokenizer.emitCharacter(60);
        tokenizer.emitCharacter(47);
        tokenizer.emitTemporaryBufferAsCharacters();
        processedInputStream.reconsume(chr);
    }

    static void handleScriptDataEscapeStartState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 45) {
            tokenizer.setState(25);
            tokenizer.emitCharacter(45);
        } else {
            tokenizer.setState(5);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataEscapeStartDashState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 45) {
            tokenizer.setState(28);
            tokenizer.emitCharacter(45);
        } else {
            tokenizer.setState(5);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataEscapedDashDashState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(29);
                break;
            }
            case 62: {
                tokenizer.setState(5);
                tokenizer.emitCharacter(62);
                break;
            }
            case 0: {
                tokenizer.emitParseErrorAndSetState(26);
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.setState(26);
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataEscapedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.setState(27);
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(29);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.setState(0);
                tokenizer.emitParseError();
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataEscapedDashState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.setState(28);
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(29);
                break;
            }
            case 0: {
                tokenizer.emitParseErrorAndSetState(26);
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.setState(26);
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataEscapedLessThanSignState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 47) {
            tokenizer.createTemporaryBuffer();
            tokenizer.setState(30);
        } else if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
            tokenizer.createTemporaryBuffer();
            tokenizer.appendToTemporaryBuffer(chr);
            tokenizer.setState(32);
            tokenizer.emitCharacter(60);
            tokenizer.emitCharacter(chr);
        } else {
            tokenizer.setState(26);
            tokenizer.emitCharacter(60);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataEscapedEndTagOpenState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
            tokenizer.newEndTokenTag();
            tokenizer.appendCurrentTagToken(chr);
            tokenizer.appendToTemporaryBuffer(chr);
            tokenizer.setState(31);
        } else {
            tokenizer.setState(26);
            tokenizer.emitCharacter(60);
            tokenizer.emitCharacter(47);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataEscapedEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(7);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEscapedEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 47: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(42);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEscapedEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 62: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(0);
                    tokenizer.emitTagToken();
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEscapedEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendCurrentTagToken(chr);
                    tokenizer.appendToTemporaryBuffer(chr);
                    break;
                }
                TokenizerRCDataAndScriptStates.anythingElseScriptDataEscapedEndTagNameState(tokenizer, processedInputStream, chr);
            }
        }
    }

    private static void anythingElseScriptDataEscapedEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream, int chr) {
        tokenizer.setState(26);
        tokenizer.emitCharacter(60);
        tokenizer.emitCharacter(47);
        tokenizer.emitTemporaryBufferAsCharacters();
        processedInputStream.reconsume(chr);
    }

    static void handleScriptDataDoubleEscapeStartState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: 
            case 47: 
            case 62: {
                if (tokenizer.isTemporaryBufferEquals(SCRIPT)) {
                    tokenizer.setState(33);
                } else {
                    tokenizer.setState(26);
                }
                tokenizer.emitCharacter(chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendToTemporaryBuffer(chr);
                    tokenizer.emitCharacter(chr);
                    break;
                }
                tokenizer.setState(26);
                processedInputStream.reconsume(chr);
            }
        }
    }

    static void handleScriptDataDoubleEscapedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.setState(34);
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(36);
                tokenizer.emitCharacter(60);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataDoubleEscapedDashState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.setState(35);
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(36);
                tokenizer.emitCharacter(60);
                break;
            }
            case 0: {
                tokenizer.emitParseErrorAndSetState(33);
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.setState(33);
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataDoubleEscapedDashDashState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 45: {
                tokenizer.emitCharacter(45);
                break;
            }
            case 60: {
                tokenizer.setState(36);
                tokenizer.emitCharacter(60);
                break;
            }
            case 62: {
                tokenizer.setState(5);
                tokenizer.emitCharacter(62);
                break;
            }
            case 0: {
                tokenizer.emitParseErrorAndSetState(33);
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.setState(33);
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleScriptDataDoubleEscapedLessThanSignState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 47) {
            tokenizer.createTemporaryBuffer();
            tokenizer.setState(37);
            tokenizer.emitCharacter(47);
        } else {
            tokenizer.setState(33);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleScriptDataDoubleEscapedEndState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: 
            case 47: 
            case 62: {
                int state = tokenizer.isTemporaryBufferEquals(SCRIPT) ? 26 : 33;
                tokenizer.setStateAndEmitCharacter(state, chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendToTemporaryBuffer(chr);
                    tokenizer.emitCharacter(chr);
                    break;
                }
                tokenizer.setState(33);
                processedInputStream.reconsume(chr);
            }
        }
    }
}

