/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.Tokenizer;

class TokenizerPlainAndRawTextStates {
    TokenizerPlainAndRawTextStates() {
    }

    static void handlePlainTextState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitEOF();
                break;
            }
            default: {
                tokenizer.emitCharacter(chr);
            }
        }
    }

    static void handleRawtextState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 60: {
                tokenizer.setState(18);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.emitCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitEOF();
                break;
            }
            default: {
                int previousInsertionMode = tokenizer.getTokenHandlerInsertionMode();
                tokenizer.emitCharacter(chr);
                int currentInsertionMode = tokenizer.getTokenHandlerInsertionMode();
                ResizableCharBuilder textNode = tokenizer.getTokenHandlerInsertCharacterPreviousTextNode();
                if (tokenizer.getState() != 4 || previousInsertionMode != currentInsertionMode || textNode == null) break;
                while (true) {
                    int internalChr = processedInputStream.getNextInputCharacterAndConsume();
                    switch (internalChr) {
                        case 60: {
                            tokenizer.resetTokenHandlerInsertCharacterPreviousTextNode();
                            tokenizer.setState(18);
                            return;
                        }
                        case 0: {
                            tokenizer.emitParseError();
                            tokenizer.emitCharacter(65533);
                            return;
                        }
                        case -1: {
                            tokenizer.resetTokenHandlerInsertCharacterPreviousTextNode();
                            tokenizer.emitEOF();
                            return;
                        }
                    }
                    textNode.append((char)internalChr);
                }
            }
        }
    }

    static void handleRawTextLessThanSignState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (chr == 47) {
            tokenizer.createTemporaryBuffer();
            tokenizer.setState(19);
        } else {
            tokenizer.setStateAndEmitCharacter(4, 60);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleRawTextEndTagOpenState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
            tokenizer.newEndTokenTag();
            tokenizer.appendCurrentTagToken(chr);
            tokenizer.appendToTemporaryBuffer(chr);
            tokenizer.setState(20);
        } else {
            tokenizer.setStateAndEmitCharacter(4, 60);
            tokenizer.emitCharacter(47);
            processedInputStream.reconsume(chr);
        }
    }

    static void handleRawTextEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(7);
                    break;
                }
                TokenizerPlainAndRawTextStates.anythingElseRawTextEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 47: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(42);
                    break;
                }
                TokenizerPlainAndRawTextStates.anythingElseRawTextEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            case 62: {
                if (tokenizer.isAppropriateEndTagToken()) {
                    tokenizer.setState(0);
                    tokenizer.emitTagToken();
                    break;
                }
                TokenizerPlainAndRawTextStates.anythingElseRawTextEndTagNameState(tokenizer, processedInputStream, chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr) || Common.isLowerCaseASCIILetter(chr)) {
                    tokenizer.appendCurrentTagToken(chr);
                    tokenizer.appendToTemporaryBuffer(chr);
                    break;
                }
                TokenizerPlainAndRawTextStates.anythingElseRawTextEndTagNameState(tokenizer, processedInputStream, chr);
            }
        }
    }

    private static void anythingElseRawTextEndTagNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream, int chr) {
        tokenizer.setStateAndEmitCharacter(4, 60);
        tokenizer.emitCharacter(47);
        tokenizer.emitTemporaryBufferAsCharacters();
        processedInputStream.reconsume(chr);
    }
}

