/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.Tokenizer;

class TokenizerDoctypeStates {
    TokenizerDoctypeStates() {
    }

    static void handleDoctypeState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                tokenizer.setState(52);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.createNewDoctypeToken();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(null, null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseErrorAndSetState(52);
                processedInputStream.reconsume(chr);
            }
        }
    }

    static void handleBeforeDoctypeNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.createNewDoctypeToken();
                tokenizer.appendDoctypeNameCharacter(65533);
                tokenizer.setState(53);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.createNewDoctypeToken();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(null, null, null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.createNewDoctypeToken();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(null, null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                if (Common.isUpperCaseASCIILetter(chr)) {
                    tokenizer.createNewDoctypeToken();
                    tokenizer.appendDoctypeNameCharacter(chr + 32);
                    tokenizer.setState(53);
                    break;
                }
                tokenizer.createNewDoctypeToken();
                tokenizer.appendDoctypeNameCharacter(chr);
                tokenizer.setState(53);
            }
        }
    }

    static void handleDoctypeNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                tokenizer.setState(54);
                break;
            }
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.appendDoctypeNameCharacter(65533);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.appendDoctypeNameCharacter(chr);
            }
        }
    }

    static void handleAfterDoctypeNameState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                int[] sixChars = new int[]{chr, processedInputStream.peekNextInputCharacter(1), processedInputStream.peekNextInputCharacter(2), processedInputStream.peekNextInputCharacter(3), processedInputStream.peekNextInputCharacter(4), processedInputStream.peekNextInputCharacter(5)};
                if (Common.matchCharsCaseInsensitivePublic(sixChars)) {
                    processedInputStream.consume(5);
                    tokenizer.setState(55);
                    break;
                }
                if (Common.matchCharCaseInsensitiveSystem(sixChars)) {
                    processedInputStream.consume(5);
                    tokenizer.setState(61);
                    break;
                }
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleAfterDoctypePublicKeywordState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                tokenizer.setState(56);
                break;
            }
            case 34: {
                tokenizer.emitParseError();
                tokenizer.createDoctypePublicIdentifier();
                tokenizer.setState(57);
                break;
            }
            case 39: {
                tokenizer.emitParseError();
                tokenizer.createDoctypePublicIdentifier();
                tokenizer.setState(58);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleBeforeDoctypePublicIdentifierState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 34: {
                tokenizer.createDoctypePublicIdentifier();
                tokenizer.setState(57);
                break;
            }
            case 39: {
                tokenizer.createDoctypePublicIdentifier();
                tokenizer.setState(58);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), null, null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleDoctypePublicIdentifierDoubleQuotedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 34: {
                tokenizer.setState(59);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.appendDoctypePublicIdentifier(65533);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.appendDoctypePublicIdentifier(chr);
            }
        }
    }

    static void handleDoctypePublicIdentifierSingleQuotedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 39: {
                tokenizer.setState(59);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.appendDoctypePublicIdentifier(65533);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.appendDoctypePublicIdentifier(chr);
            }
        }
    }

    static void handleAfterDoctypePublicIdentifierState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                tokenizer.setState(60);
                break;
            }
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case 34: {
                tokenizer.emitParseError();
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(63);
                break;
            }
            case 39: {
                tokenizer.emitParseError();
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(64);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleBetweenDoctypePublicAndSystemIdentifiersState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case 34: {
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(63);
                break;
            }
            case 39: {
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(64);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleAfterDoctypeSystemKeywordState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                tokenizer.setState(62);
                break;
            }
            case 34: {
                tokenizer.emitParseError();
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(63);
                break;
            }
            case 39: {
                tokenizer.emitParseError();
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(64);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleBeforeDoctypeSystemIdentifierState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 34: {
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(63);
                break;
            }
            case 39: {
                tokenizer.createDoctypeSystemIdentifier();
                tokenizer.setState(64);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), null);
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(66);
            }
        }
    }

    static void handleDoctypeSystemIdentifierDoubleQuotedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 34: {
                tokenizer.setState(65);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.appendDoctypeSystemIdentifierCharacter(65533);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.appendDoctypeSystemIdentifierCharacter(chr);
            }
        }
    }

    static void handleDoctypeSystemIdentifierSingleQuotedState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 39: {
                tokenizer.setState(65);
                break;
            }
            case 0: {
                tokenizer.emitParseError();
                tokenizer.appendDoctypeSystemIdentifierCharacter(65533);
                break;
            }
            case 62: {
                tokenizer.emitParseError();
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.appendDoctypeSystemIdentifierCharacter(chr);
            }
        }
    }

    static void handleAfterDoctypeSystemIdentifierState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 9: 
            case 10: 
            case 12: 
            case 32: {
                break;
            }
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                break;
            }
            case -1: {
                tokenizer.emitParseErrorAndSetState(0);
                tokenizer.setDoctypeForceQuirksFlag(true);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                processedInputStream.reconsume(chr);
                break;
            }
            default: {
                tokenizer.emitParseErrorAndSetState(66);
            }
        }
    }

    static void handleBogusDoctypeState(Tokenizer tokenizer, ProcessedInputStream processedInputStream) {
        int chr = processedInputStream.getNextInputCharacterAndConsume();
        switch (chr) {
            case 62: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                break;
            }
            case -1: {
                tokenizer.setState(0);
                tokenizer.emitDoctypeToken(tokenizer.getDoctypeNameToken(), tokenizer.getDoctypePublicIdentifier(), tokenizer.getDoctypeSystemIdentifier());
                processedInputStream.reconsume(chr);
                break;
            }
        }
    }
}

